/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view;

import netjfwatcher.snmp.mibtree.ManagerMibTree;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;




/**
 * Engine Managerp[XyNeBuNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EngineManagerPerspective implements IPerspectiveFactory {
	public static final String ID = "netjfwatcher.engine.view.EngineManagerPerspective";
    /**
     * Engine Managerp[XyNeBũCAEgs܂B
     *
     * @param layout IPageLayout
     */
    public void createInitialLayout(final IPageLayout layout) {
        /* EditorArea\off */
        layout.setEditorAreaVisible(false);

        String editorArea = layout.getEditorArea();

        /* Viewzu */
        IFolderLayout top =
            layout.createFolder("top", IPageLayout.TOP, 0.8f, editorArea);
        top.addView(GenericResourceView.class.getName());
        top.addView(DatabasePropertyView.class.getName());
        top.addView(MailPropertyView.class.getName());
        top.addView(EngineScheduleView.class.getName());
        top.addView(EngineThreadView.class.getName());
        top.addView(GarbageCollectionView.class.getName());

        /* MIB` */
        ManagerMibTree.getInstance();
    }
}
