/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.node;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableNodeRegister;
import netjfwatcher.engine.command.control.CommandMappingTableResource;
import netjfwatcher.engine.model.action.MediaResource;
import netjfwatcher.engine.nodecontrol.NodeAdd;
import netjfwatcher.engine.nodecontrol.NodeDelete;
import netjfwatcher.engine.nodecontrol.NodeEdit;
import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.server.protocol.ping.PingExcecEngine;
import netjfwatcher.engine.socket.ConnectionNodeControl;
import netjfwatcher.engine.socket.ConnectionNodeInformation;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.snmp.preference.SnmpPreference;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * Ďm[h̒ǉE폜yѕҏWsEditor ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EditorNodeOperation extends AbstractEditorNodeView {
	/** View^Cg suffix */
	public static final String TITLE_SUFFIX = "Node Add/Edit/Delete";

	/* Composite Size */
	private static final int[] SCROLL_COMPOSITE_SIZE = { 800, 800 };

	/** eLXg\ */
	public static final int TEXT_WIDTH1 = 150;

	/** HTTP URL\eLXg */
	public static final int URL_TEXT_WIDTH = 400;

	/** AgentAhX List */
	public static final int AGENT_LIST_WIDTH = 200;

	/** AgentAhX List */
	public static final int AGENT_LIST_VERTICALSPAN = 7;

	/* Agent Address List item Height */
	private static final int AGENT_ADDRESS_LIST_ITEM_HEIGHT = 8;

	/* HorizontalSpan 3 */
	private static final int HORIZONTAL_SPAN3 = 3;

	/* verticalSpan = 4; */
	private static final int VERTICAL_SPAN4 = 4;

	/* MO */
	private static Logger logger;

	private static final int LIMIT_DATA = 60;

	private static final int PING_THRESHOLD_LIMIT_DATA = 20;

	private static final int NO_LIMIT_DATA = 0;

	private NodeInformation targetNodeInfo;
	/*
	 * f[^x[X擾m[hĎ i[Xg
	 */
	private ArrayList nodeInfoList;

	/*
	 * AgentAhXǉAҏWyэ폜 AhX`FbNXg
	 */
	private HashMap checkAddressList = new HashMap();

	/* AgentAhXXg\Xg */
	private List agentAddressList;

	/* m[h\eLXg */
	private Text nodeNameText;

	/* m[hIP Address\eLXg */
	private Text nodeIPAddressText;

	/* m[hO[v\eLXg */
	private Text nodeGroupText;

	/* m[hʕ\eLXg */
	private Combo nodeKindCombo;

	/* PingĎ\eLXg */
	private Text pingPeriodText;

	/* PingĎ臒l\eLXg */
	private Text pingThresholdText;

	/* SNMP Version\ComboBox */
	private Combo snmpVersionCombo;

	/* SNMPĎx\ComboBox */
	private Combo snmpLevelCombo;

	/* SNMPĎ\eLXg */
	private Text snmpPeriodText;

	/* SNMP ReadR~jeB\eLXg */
	private Text snmpROCommunityText;

	/* SNMP R/WR~jeB\eLXg */
	private Text snmpRWCommunityText;

	/* HTTPĎURL\eLXg */
	private Text httpUrlText;

	/* HTTPĎ|[g\eLXg */
	private Text httpPortText;

	/* HTTPĎ\eLXg */
	private Text httpPeriodText;

	/* HTTPĎ^CAEgl\eLXg */
	private Text httpTimeoutText;

	/* POPĎ\eLXg */
	private Text pop3PeriodText;

	/* POPĎ|[g\eLXg */
	private Text pop3PortText;

	/* POPĎ^CAEgl\eLXg */
	private Text pop3TimeoutText;

	/* POPĎ[U\eLXg */
	private Text pop3UserText;

	/* POPĎpX[h\eLXg */
	private Text pop3PasswordText;

	/* SMTPĎ\eLXg */
	private Text smtpPeriodText;

	/* SMTPĎ|[g\eLXg */
	private Text smtpPortText;

	/* SMTPĎ^CAEgl\eLXg */
	private Text smtpTimeoutText;

	/* SMTPĎMAhX\eLXg */
	private Text smtpTestAddressText;

	/* SMTPĎmFPopzXg\eLXg */
	private Text smtpCheckPop3HostText;

	/* SMTPĎmFPop|[g\eLXg */
	private Text smtpCheckPop3PortText;

	/* SMTPĎmFPop[U\eLXg */
	private Text smtpCheckPop3UserText;

	/* SMTPĎmFPoppX[h\eLXg */
	private Text smtpCheckPop3PasswordText;

	/* SMTPĎmFPopĎ^CAEgl\eLXg */
	private Text smtpCheckPop3TimeoutText;

	/* AgentXg[h{^ */
	private Button loadAgentAddressListButton;

	/* m[hǉ{^ */
	private Button addButton;

	/* m[hҏW{^ */
	private Button editButton;

	/* m[h폜{^ */
	private Button deleteButton;

	/* m[hĎ`FbNCX^X */
	private EditorNodeOperationCheckNode checkNode = new EditorNodeOperationCheckNode();

	/**
	 * Ďm[h̒ǉE폜yѕҏWsEditor ViewNXCX^X ܂B
	 */
	public EditorNodeOperation() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * PartControl𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		/* ͐ݒlm[hĎ擾 */
		EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView) getEditorInput();
		targetNodeInfo = nodeViewEditorInput.getNodeInfo();
		isSocket = nodeViewEditorInput.isSocket();

		if (targetNodeInfo == null) {
			logger.warning("NodeInfo null");
		}

		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);

		GridLayout layout = new GridLayout(1, false);
		scrollComposite.setLayout(layout);

		GridData gridData = null;

		GridLayout gridLayout0 = new GridLayout(1, true);
		Composite composite0 = new Composite(scrollComposite, SWT.NONE);
		composite0.setLayout(gridLayout0);
		composite0.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL
				| GridData.VERTICAL_ALIGN_FILL));

		/*
		 * AgentAhXXgzuComposite
		 */
		GridLayout gridLayout = new GridLayout(4, true);
		Composite composite1 = new Composite(composite0, SWT.NONE);
		composite1.setLayout(gridLayout);
		composite1.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL
				| GridData.VERTICAL_ALIGN_FILL));

		/*
		 * m[hĎzuComposite
		 */
		GridLayout gridLayout2 = new GridLayout(5, false);
		Composite composite2 = new Composite(composite0, SWT.NONE);
		composite2.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL
				| GridData.VERTICAL_ALIGN_FILL));
		composite2.setLayout(gridLayout2);

		gridData = new GridData();

		Label label = new Label(composite1, SWT.NONE);
		label.setText("Agent address list");
		label.setLayoutData(new GridData());

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		agentAddressList = new List(composite1, SWT.SINGLE | SWT.BORDER
				| SWT.V_SCROLL);

		GridData data = new GridData(GridData.FILL_BOTH);
		data.horizontalSpan = 1;
		data.verticalSpan = AGENT_LIST_VERTICALSPAN;
		data.widthHint = AGENT_LIST_WIDTH;
		data.heightHint = agentAddressList.getItemHeight()
				* AGENT_ADDRESS_LIST_ITEM_HEIGHT;

		agentAddressList.select(0);
		agentAddressList.setLayoutData(data);

		/* {^CAEg */
		setButtonLayout(data, composite1);

		label = new Label(composite2, SWT.NONE);
		label.setText("Node Name");
		gridData = new GridData();
		label.setLayoutData(gridData);

		nodeNameText = new Text(composite2, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		nodeNameText.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Ping");

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Period(sec)");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		pingPeriodText = new Text(composite2, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		pingPeriodText.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Node IPAddress");
		gridData = new GridData();
		label.setLayoutData(gridData);

		nodeIPAddressText = new Text(composite2, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		nodeIPAddressText.setLayoutData(gridData);

		// Ping label verticalSpan dummy
		label = new Label(composite2, SWT.NONE);
		label.setText("");

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Threshold(" + PingExcecEngine.PING_RESPONSE_TIME_UNIT_MS
				+ ")");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		pingThresholdText = new Text(composite2, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		pingThresholdText.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Group");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		nodeGroupText = new Text(composite2, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		nodeGroupText.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Snmp");

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Version");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		snmpVersionCombo = new Combo(composite2, SWT.DROP_DOWN | SWT.READ_ONLY);

		snmpVersionCombo.add("V1");
		snmpVersionCombo.add("V2");
		snmpVersionCombo.add("V3");
		snmpVersionCombo.select(0);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		snmpVersionCombo.setLayoutData(gridData);

		/* m[hComboBoxZbg */
		setNodeKind(composite2);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		nodeKindCombo.setLayoutData(gridData);
		nodeKindCombo.setVisibleItemCount(15);


		// Snmp label verticalSpan dummy
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = VERTICAL_SPAN4;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Level");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		// snmpLevelText = new Text(composite2, SWT.BORDER);
		snmpLevelCombo = new Combo(composite2, SWT.DROP_DOWN | SWT.READ_ONLY);
		snmpLevelCombo.add(SnmpPreference.SNMP_LEVEL0_DESCRIPTION);
		snmpLevelCombo.add(SnmpPreference.SNMP_LEVEL1_DESCRIPTION);
		snmpLevelCombo.add(SnmpPreference.SNMP_LEVEL2_DESCRIPTION);
		snmpLevelCombo.add(SnmpPreference.SNMP_LEVEL3_DESCRIPTION);
		snmpLevelCombo.add(SnmpPreference.SNMP_LEVEL4_DESCRIPTION);
		snmpLevelCombo.select(0);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		snmpLevelCombo.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Period(sec)");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		snmpPeriodText = new Text(composite2, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		snmpPeriodText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("RO Community");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		snmpROCommunityText = new Text(composite2, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		snmpROCommunityText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("RW Community");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		snmpRWCommunityText = new Text(composite2, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		snmpRWCommunityText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Http");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Period(sec)");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		httpPeriodText = new Text(composite2, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		httpPeriodText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("URL");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		httpUrlText = new Text(composite2, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = URL_TEXT_WIDTH;
		httpUrlText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Port");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		httpPortText = new Text(composite2, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		httpPortText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Timeout(msec)");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		httpTimeoutText = new Text(composite2, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		httpTimeoutText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Pop3");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Period(sec)");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		pop3PeriodText = new Text(composite2, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		pop3PeriodText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("User");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		pop3UserText = new Text(composite2, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		pop3UserText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Password");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		pop3PasswordText = new Text(composite2, SWT.PASSWORD | SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		pop3PasswordText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Port");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		pop3PortText = new Text(composite2, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		pop3PortText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Timeout(msec)");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		pop3TimeoutText = new Text(composite2, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		pop3TimeoutText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("SMTP");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Period(sec)");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		smtpPeriodText = new Text(composite2, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		smtpPeriodText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Port");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		smtpPortText = new Text(composite2, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		smtpPortText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Timeout(msec)");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		smtpTimeoutText = new Text(composite2, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		smtpTimeoutText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Address (xxx@xxx)");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		smtpTestAddressText = new Text(composite2, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		smtpTestAddressText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Smtp check Pop3 Host");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		smtpCheckPop3HostText = new Text(composite2, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		smtpCheckPop3HostText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Smtp check Pop3 User");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		smtpCheckPop3UserText = new Text(composite2, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		smtpCheckPop3UserText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Smtp check Pop3 Password");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		smtpCheckPop3PasswordText = new Text(composite2, SWT.PASSWORD
				| SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		smtpCheckPop3PasswordText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Smtp check Pop3 Port");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		smtpCheckPop3PortText = new Text(composite2, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		smtpCheckPop3PortText.setLayoutData(gridData);

		/* Dummy column */
		label = new Label(composite2, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTAL_SPAN3;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite2, SWT.NONE);
		label.setText("Smtp check Pop3 Timeout(msec)");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		smtpCheckPop3TimeoutText = new Text(composite2, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		smtpCheckPop3TimeoutText.setLayoutData(gridData);

		scrollComposite.setContent(composite0);
		scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0],
				SCROLL_COMPOSITE_SIZE[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		/* VieweLXgɃftHglZbg */
		setTextDefaultNodeInfo();

		/* Agentm[hXgZbg */
		setAgentNodeList();

		/*
		 * f[^x[Xm[hĎ擾AIm[hɑΉ m[hĎViewɃZbg
		 */
		if ((targetNodeInfo != null) && (targetNodeInfo.getIpaddress() != null)) {
			for (int i = 0; i < nodeInfoList.size(); i++) {
				NodeInformation nodeInfo = (NodeInformation) nodeInfoList
						.get(i);

				if (targetNodeInfo.getIpaddress().equals(
						nodeInfo.getIpaddress())) {
					agentAddressList.select(i);

					nodeInfo = checkNode.checkNodeInfo(nodeInfo);
					setTextNodeInfo(nodeInfo);
				} else {
					if (targetNodeInfo != null && targetNodeInfo.getNodeKind() != null) {
						nodeInfo = checkNode.checkNodeInfo(targetNodeInfo);
						setTextNodeInfo(nodeInfo);
					}
				}
			}
		}

		/* {^Xi[ */
		setButtonListener();
	}

	/*
	 * {^Layouts܂B
	 * 
	 * @param data GridData @param composite1 Composite
	 */
	private void setButtonLayout(GridData data, Composite composite1) {
		/* Button */
		loadAgentAddressListButton = new Button(composite1, SWT.NONE);
		loadAgentAddressListButton.setText("Agent address list load");
		data = new GridData();
		data.horizontalSpan = HORIZONTAL_SPAN3;
		loadAgentAddressListButton.setLayoutData(data);

		addButton = new Button(composite1, SWT.NONE);
		addButton.setText("Node Add");
		data = new GridData();
		data.horizontalSpan = HORIZONTAL_SPAN3;
		addButton.setLayoutData(data);

		editButton = new Button(composite1, SWT.NONE);
		editButton.setText("Node Edit");
		data = new GridData();
		data.horizontalSpan = HORIZONTAL_SPAN3;
		editButton.setLayoutData(data);

		deleteButton = new Button(composite1, SWT.NONE);
		deleteButton.setText("Node Delete");
		data = new GridData();
		data.horizontalSpan = HORIZONTAL_SPAN3;
		deleteButton.setLayoutData(data);
	}

	/*
	 * {^Xi[Zbg܂B
	 */
	private void setButtonListener() {
		/*
		 * AgentAhX[hăXgɕ\{^ Listener
		 */
		loadAgentAddressListButton
				.addSelectionListener(new SelectionListener() {
					public void widgetSelected(SelectionEvent event) {
						loadAgentAddressListButton.setEnabled(false);
						addButton.setEnabled(false);
						editButton.setEnabled(false);
						deleteButton.setEnabled(false);

						try {
							/* Agentm[hXgZbg */
							setAgentNodeList();
						} finally {
							addButton.setEnabled(true);
							editButton.setEnabled(true);
							deleteButton.setEnabled(true);
							loadAgentAddressListButton.setEnabled(true);
						}
					}

					public void widgetDefaultSelected(SelectionEvent event) {
					}
				});

		/* AgentAhXXgIListener */
		agentAddressList.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				int index = agentAddressList.getSelectionIndex();
				if(index < 0) {
					return;
				}
				NodeInformation nodeInfo = (NodeInformation) nodeInfoList
						.get(index);

				nodeInfo = checkNode.checkNodeInfo(nodeInfo);
				setTextNodeInfo(nodeInfo);
			}
		});

		/* m[hǉ{^Xi[ */
		addButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				addButton.setEnabled(false);
				editButton.setEnabled(false);
				deleteButton.setEnabled(false);
				loadAgentAddressListButton.setEnabled(false);

				addNode();

				addButton.setEnabled(true);
				editButton.setEnabled(true);
				deleteButton.setEnabled(true);
				loadAgentAddressListButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/* m[hҏW{^Xi[ */
		editButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				addButton.setEnabled(false);
				editButton.setEnabled(false);
				deleteButton.setEnabled(false);
				loadAgentAddressListButton.setEnabled(false);

				editNode();

				addButton.setEnabled(true);
				editButton.setEnabled(true);
				deleteButton.setEnabled(true);
				loadAgentAddressListButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/* m[h폜{^Xi[ */
		deleteButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				addButton.setEnabled(false);
				editButton.setEnabled(false);
				deleteButton.setEnabled(false);
				loadAgentAddressListButton.setEnabled(false);

				deleteNode();

				addButton.setEnabled(true);
				editButton.setEnabled(true);
				deleteButton.setEnabled(true);
				loadAgentAddressListButton.setEnabled(true);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
	}

	/*
	 * m[hComboBoxZbg܂B
	 * 
	 * @param composite2 Composite
	 */
	private void setNodeKind(Composite composite2) {
		Label label = new Label(composite2, SWT.NONE);
		label.setText("Node Kind");

		GridData gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		nodeKindCombo = new Combo(composite2, SWT.DROP_DOWN | SWT.READ_ONLY);

		HashMap nodeIconMap = MediaResource.getInstance().getIconDataList();
		Iterator it;

		for (it = nodeIconMap.keySet().iterator(); it.hasNext();) {
			String key = (String) it.next();
			nodeKindCombo.add(key);
		}

		nodeKindCombo.select(0);
	}

	/*
	 * ftHg̃m[hĎeLXg\܂B
	 * 
	 */
	private void setTextDefaultNodeInfo() {
		nodeKindCombo.select(0);
		snmpVersionCombo.select(0);
		snmpLevelCombo.select(0);

		nodeGroupText
				.setText(EditorNodeOperationInitialData.INITIAL_NODE_GROUP);
		pingPeriodText
				.setText(EditorNodeOperationInitialData.INITIAL_NODE_PING_PERIOD);
		pingThresholdText
				.setText(EditorNodeOperationInitialData.INITIAL_NODE_PING_THRESHOLD);
		snmpPeriodText
				.setText(EditorNodeOperationInitialData.INITIAL_NODE_SNMP_PERIOD);
		snmpROCommunityText
				.setText(EditorNodeOperationInitialData.INITIAL_NODE_SNMP_ROCOMMUNITY);
		snmpRWCommunityText
				.setText(EditorNodeOperationInitialData.INITIAL_NODE_SNMP_RWCOMMUNITY);
		httpUrlText
				.setText(EditorNodeOperationInitialData.INITIAL_NODE_HTTP_URL);
		httpPortText
				.setText(EditorNodeOperationInitialData.INITIAL_NODE_HTTP_PORT);
		httpPeriodText
				.setText(EditorNodeOperationInitialData.INITIAL_NODE_HTTP_PERIOD);
		httpTimeoutText
				.setText(EditorNodeOperationInitialData.INITIAL_NODE_HTTP_TIMEOUT);
		pop3PeriodText
				.setText(EditorNodeOperationInitialData.INITIAL_NODE_POP_PERIOD);
		pop3PortText
				.setText(EditorNodeOperationInitialData.INITIAL_NODE_POP_PORT);
		pop3TimeoutText
				.setText(EditorNodeOperationInitialData.INITIAL_NODE_POP_TIMEOUT);
		smtpPeriodText
				.setText(EditorNodeOperationInitialData.INITIAL_NODE_SMTP_PERIOD);
		smtpPortText
				.setText(EditorNodeOperationInitialData.INITIAL_NODE_SMTP_PORT);
		smtpTimeoutText
				.setText(EditorNodeOperationInitialData.INITIAL_NODE_SMTP_TIMEOUT);
		smtpCheckPop3PortText
				.setText(EditorNodeOperationInitialData.INITIAL_NODE_POP_PORT);
		smtpCheckPop3TimeoutText
				.setText(EditorNodeOperationInitialData.INITIAL_NODE_POP_TIMEOUT);
	}

	/*
	 * Ďm[hǉ܂B
	 */
	private void addNode() {
		String addIPAddress = nodeIPAddressText.getText();

		try {
			InetAddress host = InetAddress.getByName(addIPAddress);
			addIPAddress = host.getHostAddress();
		} catch (UnknownHostException e2) {
			MessageDialog.openError(getEditorSite().getShell(), "Error",
					"UnknownHostException" + " IP Address = " + addIPAddress);
			nodeIPAddressText.setFocus();

			return;
		}

		setAgentNodeList();

		if ((addIPAddress == null) || addIPAddress.equals("")) {
			MessageDialog.openError(getEditorSite().getShell(), "Error",
					"Illegal IP Address");
			nodeIPAddressText.setFocus();

			return;
		}

		if (checkAddressList.containsKey(addIPAddress)) {
			MessageDialog.openError(getEditorSite().getShell(), "Error",
					"Already IP Address = " + addIPAddress);

			nodeIPAddressText.setFocus();

			return;
		}

		int snmpVersion = snmpVersionCombo.getSelectionIndex();

		if (snmpVersion == 2) {
			if (SnmpV3ManagerConfig.getInstance().getResourceFileParse()
					.getSnmpV3AgentInfo(addIPAddress) == null) {
				MessageDialog.openError(getEditorSite().getShell(), "Error",
						"Not found SNMP V3 Agent Address = " + addIPAddress);

				return;
			}
		}

		int httpPeriod = 0;

		try {
			httpPeriod = Integer.parseInt(httpPeriodText.getText());
		} catch (NumberFormatException e3) {
			MessageDialog.openError(getEditorSite().getShell(),
					"Illegal Http period", "Illegal Http period "
							+ httpPeriodText.getText());
			logger.warning("Illegal Http period " + httpPeriodText.getText());

			httpPeriodText.setFocus();

			return;
		}

		if (httpPeriod > 0) {
			try {
				URL accessURL = new URL(httpUrlText.getText());

				if ((accessURL.getHost() == null)
						|| accessURL.getHost().equals("")
						|| (accessURL.getProtocol() == null)
						|| accessURL.getProtocol().equals("")) {
					MessageDialog.openError(getEditorSite().getShell(),
							"Illegal URL", "Illegal URL " + "  host="
									+ accessURL.getHost() + "  protocol="
									+ accessURL.getProtocol());
					logger.warning("Illegal URL " + "   host="
							+ accessURL.getHost() + "  protocol="
							+ accessURL.getProtocol());

					httpUrlText.setFocus();

					return;
				}
			} catch (MalformedURLException e1) {
				MessageDialog.openError(getEditorSite().getShell(),
						"Illegal URL", e1.getMessage() + " "
								+ httpUrlText.getText());
				logger.warning("Illegal URL " + e1.getMessage() + " "
						+ httpUrlText.getText());

				httpUrlText.setFocus();

				return;
			}
		}

		NodeInformation addNodeInfo = createNodeInfo();

		if (addNodeInfo == null) {
			return;
		}

		if (!isSocket) {
			NodeAdd nodeAddInstance = NodeAdd.getInstance();
			nodeAddInstance.addNode(addNodeInfo, true);
		} else {
			String engineAddress = ClientEngineInfo
					.getClientEngineInfoInstance().getEngineAddress();

			ConnectionNodeControl threadstop = new ConnectionNodeControl(
					engineAddress);

			try {
				String responseCode = threadstop.requestThread(addIPAddress,
						CommandMappingTableResource.THREAD_START_COMMAND_ID,
						addNodeInfo);

				if (!responseCode
						.equals(CommandMappingTableResource.ACK_RESPONSE)) {
				}
			} catch (EngineConnectException e1) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", "Engine connect error "
						+ e1.getMessage() + " Engine=" + engineAddress);
				shell.dispose();

				return;
			} catch (IOException e1) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", "Engine connect error "
						+ e1.getMessage() + " Engine=" + engineAddress);
				shell.dispose();

				return;
			}
		}

		setAgentNodeList();
		setTextDefaultNodeInfo();
	}

	/*
	 * Ďm[hҏW܂B
	 * 
	 */
	private void editNode() {
		String addIPAddress = nodeIPAddressText.getText();

		if ((addIPAddress == null) || addIPAddress.equals("")) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Error", "Illegal IP Address");
			shell.dispose();

			return;
		}

		if (!checkAddressList.containsKey(addIPAddress)) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Error", "Not found IP Address = "
					+ addIPAddress);
			shell.dispose();

			return;
		}

		NodeInformation addNodeInfo = createNodeInfo();

		if (addNodeInfo == null) {
			return;
		}
		NodeInformation checkNodeInfo = getNodeInfo(addIPAddress);

		if (checkNodeInfo != null) {

			addNodeInfo.setNodeX(checkNodeInfo.getNodeX());
			addNodeInfo.setNodeY(checkNodeInfo.getNodeY());
		}
		if (!isSocket) {
			NodeEdit editNodeInstance = NodeEdit.getInstance();

			try {
				editNodeInstance.editNodeInfo(addNodeInfo);
			} catch (DatabaseConnectionException e1) {
				MessageDialog.openError(getEditorSite().getShell(),
						"Abort edit Node", e1.getMessage());
				logger.warning("Abort edit Node " + e1.getMessage());

				return;
			} catch (SQLException e1) {
				MessageDialog.openError(getEditorSite().getShell(),
						"Abort edit Node", e1.getMessage());
				logger.warning("Abort edit Node " + e1.getMessage());

				return;
			}
		} else {
			String engineAddress = ClientEngineInfo
					.getClientEngineInfoInstance().getEngineAddress();
			ConnectionNodeControl threadstop = new ConnectionNodeControl(
					engineAddress);

			try {
				threadstop.requestThread(addIPAddress,
						CommandMappingTableResource.THREAD_RESTART_COMMAND_ID,
						addNodeInfo);
			} catch (EngineConnectException e1) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", "Engine connect error "
						+ e1.getMessage() + " Engine=" + engineAddress);
				shell.dispose();

				return;
			} catch (IOException e1) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", "Engine connect error "
						+ e1.getMessage() + " Engine=" + engineAddress);
				shell.dispose();

				return;
			}
		}

		setAgentNodeList();
	}

	/*
	 * Ďm[h폜܂B
	 * 
	 */
	private void deleteNode() {
		String addIPAddress = nodeIPAddressText.getText();

		if ((addIPAddress == null) || addIPAddress.equals("")) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Error", "Illegal IP Address");
			deleteButton.setEnabled(true);
			shell.dispose();

			return;
		}

		if (!checkAddressList.containsKey(addIPAddress)) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Error", "Not found IP Address = "
					+ addIPAddress);
			deleteButton.setEnabled(true);
			shell.dispose();

			return;
		}

		if (!isSocket) {
			NodeDelete del = NodeDelete.getInstance();
			del.removeThreadList(addIPAddress);
		} else {
			String engineAddress = ClientEngineInfo
					.getClientEngineInfoInstance().getEngineAddress();

			ConnectionNodeControl threadstop = new ConnectionNodeControl(
					engineAddress);

			try {
				threadstop.requestThread(addIPAddress,
						CommandMappingTableResource.THREAD_STOP_COMMAND_ID,
						null);
			} catch (EngineConnectException e1) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", "Engine connect error "
						+ e1.getMessage() + " Engine=" + engineAddress);
				deleteButton.setEnabled(true);
				shell.dispose();

				return;
			} catch (IOException e1) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", "Engine connect error "
						+ e1.getMessage() + " Engine=" + engineAddress);
				deleteButton.setEnabled(true);
				shell.dispose();

				return;
			}
		}

		setAgentNodeList();
	}

	/*
	 * Ďm[hXgZbg܂B
	 * 
	 */
	private void setAgentNodeList() {

		agentAddressList.removeAll();

		if (nodeInfoList != null) {
			nodeInfoList.clear();
		}

		checkAddressList.clear();

		nodeInfoList = getNodeList();

		if(nodeInfoList == null) {
			return;
		}
		for (int i = 0; i < nodeInfoList.size(); i++) {
			NodeInformation nodeInfo = (NodeInformation) nodeInfoList.get(i);

			/* Agent Address ListZbg */
			agentAddressList.add(nodeInfo.getNodename() + " : "
					+ nodeInfo.getIpaddress());

			/* m[hǉAҏWyэ폜AddressL`FbNListZbg */
			checkAddressList.put(nodeInfo.getIpaddress(), nodeInfo);
		}
	}

	/*
	 * Text͏̑Ó`FbNɃm[hĎ𐶐 ĕԂ܂B m[hǉyуm[hĎҏW{^Xi[Ă΂ ܂B
	 * 
	 * @return m[hĎ
	 */
	private NodeInformation createNodeInfo() {
		NodeInformation workNodeInfo = new NodeInformation();

		if (showErrorDialog(pingPeriodText, LIMIT_DATA)) {
			workNodeInfo.setPingPeriod(pingPeriodText.getText());
		} else {
			return null;
		}

		if (showErrorDialog(pingThresholdText, PING_THRESHOLD_LIMIT_DATA)) {
			workNodeInfo.setPingThreshold(pingThresholdText.getText());
		} else {
			return null;
		}

		if (showErrorDialog(snmpPeriodText, LIMIT_DATA)) {
			workNodeInfo.setSnmpPeriod(snmpPeriodText.getText());
		} else {
			return null;
		}

		if (showErrorDialog(httpPeriodText, LIMIT_DATA)) {
			workNodeInfo.setHttpPeriod(httpPeriodText.getText());
		} else {
			return null;
		}

		if (showErrorDialog(httpTimeoutText, LIMIT_DATA)) {
			workNodeInfo.setHttpTimeout(httpTimeoutText.getText());
		} else {
			return null;
		}

		if (showErrorDialog(pop3PeriodText, LIMIT_DATA)) {
			workNodeInfo.setPopPeriod(pop3PeriodText.getText());
		} else {
			return null;
		}

		if (showErrorDialog(pop3PortText, NO_LIMIT_DATA)) {
			workNodeInfo.setPopPort(pop3PortText.getText());
		} else {
			return null;
		}

		if (showErrorDialog(pop3TimeoutText, LIMIT_DATA)) {
			workNodeInfo.setPopTimeout(pop3TimeoutText.getText());
		} else {
			return null;
		}

		if (showErrorDialog(smtpPeriodText, LIMIT_DATA)) {
			workNodeInfo.setSmtpPeriod(smtpPeriodText.getText());
		} else {
			return null;
		}

		if (showErrorDialog(smtpPortText, NO_LIMIT_DATA)) {
			workNodeInfo.setSmtpPort(smtpPortText.getText());
		} else {
			return null;
		}

		if (showErrorDialog(smtpTimeoutText, LIMIT_DATA)) {
			workNodeInfo.setSmtpTimeout(smtpTimeoutText.getText());
		} else {
			return null;
		}

		if (showErrorDialog(smtpCheckPop3PortText, NO_LIMIT_DATA)) {
			workNodeInfo.setSmtpCheckPort(smtpCheckPop3PortText.getText());
		} else {
			return null;
		}

		if (showErrorDialog(smtpCheckPop3TimeoutText, LIMIT_DATA)) {
			workNodeInfo
					.setSmtpCheckTimeout(smtpCheckPop3TimeoutText.getText());
		} else {
			return null;
		}

		workNodeInfo.setPopUser(pop3UserText.getText());
		workNodeInfo.setPopPassword(pop3PasswordText.getText());
		workNodeInfo.setSmtpSendAddress(smtpTestAddressText.getText());
		workNodeInfo.setSmtpCheckHost(smtpCheckPop3HostText.getText());
		workNodeInfo.setSmtpCheckUser(smtpCheckPop3UserText.getText());
		workNodeInfo.setSmtpCheckPassword(smtpCheckPop3PasswordText.getText());

		workNodeInfo.setHttpUrl(httpUrlText.getText());

		if (showErrorDialog(httpPortText, NO_LIMIT_DATA)) {
			workNodeInfo.setHttpPort(httpPortText.getText());
		} else {
			return null;
		}

		String nodeName = null;

		try {
			InetAddress host = InetAddress.getByName(nodeIPAddressText
					.getText());
			String addIPAddress = host.getHostAddress();
			workNodeInfo.setIpaddress(addIPAddress);
			nodeName = host.getHostName();
		} catch (UnknownHostException e2) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Error", "UnknownHostException");
			shell.dispose();
			nodeIPAddressText.setFocus();

			return null;
		}

		if (nodeNameText.getText().equals("")) {
			workNodeInfo.setNodename(nodeName);
		} else {
			workNodeInfo.setNodename(nodeNameText.getText());
		}

		String engineAddress = EditorNodeOperationInitialData.INITIAL_ENGINE_ADDRESS;

		try {
			engineAddress = InetAddress.getLocalHost().getHostAddress();
		} catch (UnknownHostException e) {
			logger.warning(e.getMessage());
		}

		workNodeInfo.setEngineAddress(engineAddress);
		workNodeInfo.setGroup(nodeGroupText.getText());

		workNodeInfo.setNodeKind(nodeKindCombo.getText());

		workNodeInfo.setRoCommunity(snmpROCommunityText.getText());
		workNodeInfo.setRwCommunity(snmpRWCommunityText.getText());

		int snmpVersion = snmpVersionCombo.getSelectionIndex();

		switch (snmpVersion) {
		case 0:
			workNodeInfo.setSnmpVersion(SnmpPreference.SNMPV1_DESCRIPTION);

			break;

		case 1:
			workNodeInfo.setSnmpVersion(SnmpPreference.SNMPV2_DESCRIPTION);

			break;

		case 2:
			workNodeInfo.setSnmpVersion(SnmpPreference.SNMPV3_DESCRIPTION);

			break;

		default:
			logger.warning("Illegal SNMP Version " + snmpVersion);
			workNodeInfo.setSnmpVersion(SnmpPreference.SNMPV1_DESCRIPTION);
		}

		String snmpLevel = snmpLevelCombo.getText();

		if (snmpLevel.equals(SnmpPreference.SNMP_LEVEL0_DESCRIPTION)) {
			workNodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL0_CODE_STRING);
		} else if (snmpLevel.equals(SnmpPreference.SNMP_LEVEL1_DESCRIPTION)) {
			workNodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL1_CODE_STRING);
		} else if (snmpLevel.equals(SnmpPreference.SNMP_LEVEL2_DESCRIPTION)) {
			workNodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL2_CODE_STRING);
		} else if (snmpLevel.equals(SnmpPreference.SNMP_LEVEL3_DESCRIPTION)) {
			workNodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL3_CODE_STRING);
		} else if (snmpLevel.equals(SnmpPreference.SNMP_LEVEL4_DESCRIPTION)) {
			workNodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL4_CODE_STRING);
		} else {
			workNodeInfo.setSnmpLevel(SnmpPreference.SNMP_LEVEL0_CODE_STRING);
		}

		if(targetNodeInfo.getNodeX() != null && !targetNodeInfo.getNodeX().equals("")) {
			workNodeInfo.setNodeX(targetNodeInfo.getNodeX());
		}
		if(targetNodeInfo.getNodeY() != null && !targetNodeInfo.getNodeY().equals("")) {
			workNodeInfo.setNodeY(targetNodeInfo.getNodeY());
		}
		return workNodeInfo;
	}

	/*
	 * Text͒l`FbNAُ펞ɂ̓G[_CAO\܂B
	 * 
	 * @param checkText `FbNText @return `FbN
	 */
	private boolean showErrorDialog(Text checkText, int limitData) {
		try {
			int checkData = Integer.parseInt(checkText.getText());

			if ((limitData == 0) || (checkData == 0)) {
				return true;
			}

			if (limitData > checkData) {
				Shell shell = new Shell();
				MessageDialog.openError(shell, "Error", "Input error. Please "
						+ checkData + " >= " + limitData);
				checkText.setFocus();
				shell.dispose();

				return false;
			}
		} catch (NumberFormatException e1) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Error", "Input error");
			checkText.setFocus();
			shell.dispose();

			return false;
		}

		return true;
	}

	/*
	 * m[hĎTextɃZbg܂B
	 * 
	 */
	private void setTextNodeInfo(NodeInformation refreshNodeInfo) {
		nodeNameText.setText(refreshNodeInfo.getNodename());
		nodeIPAddressText.setText(refreshNodeInfo.getIpaddress());
		nodeGroupText.setText(refreshNodeInfo.getGroup());

		if (refreshNodeInfo.getNodeKind() != null) {
			nodeKindCombo.setText(refreshNodeInfo.getNodeKind());
		}

		if (refreshNodeInfo.getPingPeriod() != null) {
			pingPeriodText.setText(refreshNodeInfo.getPingPeriod());
		}

		if (refreshNodeInfo.getPingThreshold() != null) {
			pingThresholdText.setText(refreshNodeInfo.getPingThreshold());
		}

		if (refreshNodeInfo.getSnmpVersion() != null) {
			if (refreshNodeInfo.getSnmpVersion().equals(
					SnmpPreference.SNMPV1_DESCRIPTION)) {
				snmpVersionCombo.select(0);
			} else if (refreshNodeInfo.getSnmpVersion().equals(
					SnmpPreference.SNMPV2_DESCRIPTION)) {
				snmpVersionCombo.select(1);
			} else if (refreshNodeInfo.getSnmpVersion().equals(
					SnmpPreference.SNMPV3_DESCRIPTION)) {
				snmpVersionCombo.select(2);
			}
		}

		if (refreshNodeInfo.getSnmpLevel() != null) {
			if (refreshNodeInfo.getSnmpLevel().equals(
					SnmpPreference.SNMP_LEVEL0_CODE_STRING)) {
				snmpLevelCombo.select(0);
			} else if (refreshNodeInfo.getSnmpLevel().equals(
					SnmpPreference.SNMP_LEVEL1_CODE_STRING)) {
				snmpLevelCombo.select(1);
			} else if (refreshNodeInfo.getSnmpLevel().equals(
					SnmpPreference.SNMP_LEVEL2_CODE_STRING)) {
				snmpLevelCombo.select(2);
			} else if (refreshNodeInfo.getSnmpLevel().equals(
					SnmpPreference.SNMP_LEVEL3_CODE_STRING)) {
				snmpLevelCombo.select(3);
			} else if (refreshNodeInfo.getSnmpLevel().equals(
					SnmpPreference.SNMP_LEVEL4_CODE_STRING)) {
				snmpLevelCombo.select(4);
			}
		}

		if (refreshNodeInfo.getSnmpPeriod() != null) {
			snmpPeriodText.setText(refreshNodeInfo.getSnmpPeriod());
		}

		if (refreshNodeInfo.getRoCommunity() != null) {
			snmpROCommunityText.setText(refreshNodeInfo.getRoCommunity());
		}

		if (refreshNodeInfo.getRwCommunity() != null) {
			snmpRWCommunityText.setText(refreshNodeInfo.getRwCommunity());
		}

		if (refreshNodeInfo.getHttpUrl() != null) {
			httpUrlText.setText(refreshNodeInfo.getHttpUrl());
		}

		if (refreshNodeInfo.getHttpPort() != null) {
			httpPortText.setText(refreshNodeInfo.getHttpPort());
		}

		if (refreshNodeInfo.getHttpPeriod() != null) {
			httpPeriodText.setText(refreshNodeInfo.getHttpPeriod());
		}

		if (refreshNodeInfo.getHttpTimeout() != null) {
			httpTimeoutText.setText(refreshNodeInfo.getHttpTimeout());
		}

		if (refreshNodeInfo.getPopPeriod() != null) {
			pop3PeriodText.setText(refreshNodeInfo.getPopPeriod());
		}

		if (refreshNodeInfo.getPopUser() != null) {
			pop3UserText.setText(refreshNodeInfo.getPopUser());
		}

		if (refreshNodeInfo.getPopPassword() != null) {
			pop3PasswordText.setText(refreshNodeInfo.getPopPassword());
		}

		if (refreshNodeInfo.getPopPort() != null) {
			pop3PortText.setText(refreshNodeInfo.getPopPort());
		}

		if (refreshNodeInfo.getPopTimeout() != null) {
			pop3TimeoutText.setText(refreshNodeInfo.getPopTimeout());
		}

		if (refreshNodeInfo.getSmtpPeriod() != null) {
			smtpPeriodText.setText(refreshNodeInfo.getSmtpPeriod());
		}

		if (refreshNodeInfo.getSmtpPort() != null) {
			smtpPortText.setText(refreshNodeInfo.getSmtpPort());
		}

		if (refreshNodeInfo.getSmtpTimeout() != null) {
			smtpTimeoutText.setText(refreshNodeInfo.getSmtpTimeout());
		}

		if (refreshNodeInfo.getSmtpSendAddress() != null) {
			smtpTestAddressText.setText(refreshNodeInfo.getSmtpSendAddress());
		}

		if (refreshNodeInfo.getSmtpCheckHost() != null) {
			smtpCheckPop3HostText.setText(refreshNodeInfo.getSmtpCheckHost());
		}

		if (refreshNodeInfo.getSmtpCheckUser() != null) {
			smtpCheckPop3UserText.setText(refreshNodeInfo.getSmtpCheckUser());
		}

		if (refreshNodeInfo.getSmtpCheckPassword() != null) {
			smtpCheckPop3PasswordText.setText(refreshNodeInfo
					.getSmtpCheckPassword());
		}

		if (refreshNodeInfo.getSmtpCheckPort() != null) {
			smtpCheckPop3PortText.setText(refreshNodeInfo.getSmtpCheckPort());
		}

		if (refreshNodeInfo.getSmtpCheckTimeout() != null) {
			smtpCheckPop3TimeoutText.setText(refreshNodeInfo
					.getSmtpCheckTimeout());
		}
	}

	/**
	 * Xe[^XC\Zbg܂B
	 * 
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}

	/**
	 * tH[JXZbgꂽ̏łB
	 */
	public void setFocus() {
	}

	/*
	 * m[hĎ񃊃Xg擾AԂ܂B
	 */
	private ArrayList getNodeList() {
		ArrayList nodeList = null;

		try {
			if (!isSocket) {
				DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister
						.getInstance();
				nodeList = nodeRegisterDBTable.getNodeInfoList(null, null);
			} else {
				String engineAddress = ClientEngineInfo
						.getClientEngineInfoInstance().getEngineAddress();

				ConnectionNodeInformation connectNodeInfo = new ConnectionNodeInformation(
						engineAddress);
				nodeList = connectNodeInfo.getNodeInformationList(null, null);
			}
		} catch (SQLException e1) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Node List import error", e1
					.getMessage());
			logger.warning("Node List import error " + e1.getMessage());
			e1.printStackTrace();
			shell.dispose();
		} catch (Exception e1) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Node List import error", e1
					.getMessage());
			logger.warning("Node List import error " + e1.getMessage());
			e1.printStackTrace();
			shell.dispose();
		}

		return nodeList;
	}

	/*
	 * m[hĎ擾AԂ܂B
	 */
	private NodeInformation getNodeInfo(String ipAddress) {
		NodeInformation nodeInfo = null;

		try {
			if (!isSocket) {
				DBTableNodeRegister nodeRegisterDBTable = DBTableNodeRegister
						.getInstance();
				ArrayList nodeList = nodeRegisterDBTable.findTarget(ipAddress);
				if (nodeList.size() > 0) {
					nodeInfo = (NodeInformation) nodeList.get(0);
				}
			} else {
				String engineAddress = ClientEngineInfo
						.getClientEngineInfoInstance().getEngineAddress();

				ConnectionNodeInformation connectNodeInfo = new ConnectionNodeInformation(
						engineAddress);
				nodeInfo = connectNodeInfo.getNodeInformation(ipAddress);
			}
		} catch (SQLException e1) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Node List import error", e1
					.getMessage());
			logger.warning("Node List import error " + e1.getMessage());
			e1.printStackTrace();
			shell.dispose();
		} catch (Exception e1) {
			Shell shell = new Shell();
			MessageDialog.openError(shell, "Node List import error", e1
					.getMessage());
			logger.warning("Node List import error " + e1.getMessage());
			e1.printStackTrace();
			shell.dispose();
		}

		return nodeInfo;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isDirty()
	 */
	public boolean isDirty() {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.ISaveablePart#isSaveAsAllowed()
	 */
	public boolean isSaveAsAllowed() {
		return false;
	}
}
