/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.engine.view.editorpart.snmp;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.database.access.control.DatabaseConnectionException;
import netjfwatcher.database.access.model.DBTableStatisticsMIBControl;
import netjfwatcher.engine.nodewatchinfo.StatisticsMibInfo;
import netjfwatcher.engine.resource.StatisticsMibFileLoad;
import netjfwatcher.engine.resource.StatisticsMibFileParse;
import netjfwatcher.engine.resourceconfig.ClientEngineInfo;
import netjfwatcher.engine.server.protocol.control.ListQueueStatisticsMibControl;
import netjfwatcher.engine.server.protocol.snmp.ExecuteStatisticsMibGet;
import netjfwatcher.engine.snmpmanager.statistics.StatisticsMibDBRegister;
import netjfwatcher.engine.snmpmanager.statistics.ThreadStatisticsMibGetControl;
import netjfwatcher.engine.socket.ConnectionStatisticsMibGet;
import netjfwatcher.engine.socket.EngineConnectException;
import netjfwatcher.engine.socket.info.NodeInformation;
import netjfwatcher.engine.socket.info.StatisticsMibControl;
import netjfwatcher.engine.socket.info.StatisticsMibProperty;
import netjfwatcher.engine.socket.info.StatisticsMibSetStatus;
import netjfwatcher.engine.view.editorpart.common.AbstractEditorNodeView;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;
import netjfwatcher.snmp.mibtree.ManagerMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * SNMPv̎ݒsViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class EditorNodeSnmpStatisricsSet extends AbstractEditorNodeView {
	/** Snmpv̎ݒ^Cg */
	public static final String TITLE_SUFFIX = " Snmp Statistics set";

	/** ScrollTCY */
	private static final int[] SCROLL_COMPOSITE_SIZE = { 800, 600 };

	/** Snmpv̎List */
	public static final int STATISTICS_MIB_COLLECT_LIST_WIDTH = 250;

	/** Snmpv̎ListcXp */
	public static final int STATISTICS_MIB_COLLECT_LIST_VERTICALSPAN = 11;

	/** SnmpvMIBXg */
	public static final int SNMP_STATISTICS_MIB_LIST_WIDTH = 200;

	/** SnmpvMIBXgcXp */
	public static final int SNMP_STATISTICS_MIB_LIST_VERTICALSPAN = 11;

	/** eLXg */
	public static final int TEXT_WIDTH1 = 120;

	/* MO */
	private static Logger logger;

	/* m[hĎ */
	private NodeInformation targetNodeInfo;

	/* AgentAhXXg\Xg */
	private List collectSnmpStatisticsList;

	/* SNMPvMIB̎撆OIDێXg */
	private ArrayList oidList = new ArrayList();

	/* SNMPvMIBIXg */
	private List baseSnmpStatisticsList;

	/* SNMPvMIBێXg */
	private ArrayList statisticsMibList;

	/* m[h\eLXg */
	private Text statisticsNodeNameText;

	/* m[hIPAhX */
	private Text statisticsNodeIPAddressText;

	/* SNMPvOID */
	private Text statisticsOidText;

	/* ReadR~jeB */
	private Text statisticsCommunityText;

	/* SNMPvĎ */
	private Text statisticsPeriodText;

	/* SNMPv臒l */
	private Text statisticsThresholdText;

	/* SNMPv臒lĎ^CvIComboBox */
	private Combo statisticsTypeCombo;

	/* AgentXg[h{^ */
	private Button loadOidListButton;

	/* m[hǉ{^ */
	private Button addButton;

	/* m[hҏW{^ */
	private Button editButton;

	/* m[h폜{^ */
	private Button deleteButton;

	/**
	 * SNMPv̎ݒsViewNXCX^X𐶐܂B
	 * 
	 */
	public EditorNodeSnmpStatisricsSet() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * PartControl𐶐܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		logger = Logger.getLogger(this.getClass().getName());

		/* ͐ݒlm[hĎ擾 */
		EditorInputNodeView nodeViewEditorInput = (EditorInputNodeView) getEditorInput();
		targetNodeInfo = nodeViewEditorInput.getNodeInfo();
		isSocket = nodeViewEditorInput.isSocket();

		if (targetNodeInfo == null) {
			logger.warning("NodeInfo null");
		}

		ScrolledComposite scrollComposite = new ScrolledComposite(parent,
				SWT.H_SCROLL | SWT.V_SCROLL);

		GridLayout layout = new GridLayout(1, false);
		scrollComposite.setLayout(layout);

		GridData gridData = null;

		GridLayout gridLayout0 = new GridLayout(1, true);
		Composite composite0 = new Composite(scrollComposite, SWT.NONE);
		composite0.setLayout(gridLayout0);
		composite0.setLayoutData(new GridData());

		GridLayout gridLayout = new GridLayout(4, false);
		Composite composite1 = new Composite(composite0, SWT.LEFT);
		composite1.setLayout(gridLayout);
		composite1.setLayoutData(new GridData());

		gridData = new GridData();

		Label label = new Label(composite1, SWT.NONE);
		label.setText("Collect Statistics OID list");
		label.setLayoutData(new GridData());

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Select Statistics OID list");
		label.setLayoutData(new GridData());

		collectSnmpStatisticsList = new List(composite1, SWT.SINGLE
				| SWT.BORDER | SWT.V_SCROLL);

		GridData data = new GridData(GridData.FILL_BOTH);
		data.horizontalSpan = 1;
		data.verticalSpan = STATISTICS_MIB_COLLECT_LIST_VERTICALSPAN;
		data.widthHint = STATISTICS_MIB_COLLECT_LIST_WIDTH;
		data.heightHint = collectSnmpStatisticsList.getItemHeight() * 8;

		collectSnmpStatisticsList.select(0);
		collectSnmpStatisticsList.setLayoutData(data);

		/* Button */
		loadOidListButton = new Button(composite1, SWT.NONE);
		loadOidListButton.setText("OID list load");
		data = new GridData();
		data.horizontalSpan = 2;
		data.verticalSpan = 1;
		loadOidListButton.setLayoutData(data);

		baseSnmpStatisticsList = new List(composite1, SWT.SINGLE | SWT.BORDER
				| SWT.V_SCROLL);

		data = new GridData(GridData.FILL_BOTH);
		data.horizontalSpan = 1;
		data.verticalSpan = SNMP_STATISTICS_MIB_LIST_VERTICALSPAN;
		data.widthHint = SNMP_STATISTICS_MIB_LIST_WIDTH;
		data.heightHint = baseSnmpStatisticsList.getItemHeight() * 20;

		baseSnmpStatisticsList.select(0);
		baseSnmpStatisticsList.setLayoutData(data);

		/*
		 * SnmpvOIDXg\[X擾AIXg Zbg
		 */
		statisticsMibList = StatisticsMibFileLoad.getInstance().getFileParse()
				.getStatisticsMibSelectList();

		for (int i = 0; i < statisticsMibList.size(); i++) {
			String[] statisMib = (String[]) statisticsMibList.get(i);
			baseSnmpStatisticsList
					.add(statisMib[StatisticsMibFileParse.DESCRIP_POS]);
		}

		label = new Label(composite1, SWT.NONE);
		label.setText("Node Name");
		gridData = new GridData();
		label.setLayoutData(gridData);

		statisticsNodeNameText = new Text(composite1, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		statisticsNodeNameText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("IP Address");

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		statisticsNodeIPAddressText = new Text(composite1, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		statisticsNodeIPAddressText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Community");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		statisticsCommunityText = new Text(composite1, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		statisticsCommunityText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("OID");
		gridData = new GridData();
		label.setLayoutData(gridData);
		statisticsOidText = new Text(composite1, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		statisticsOidText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Period");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		statisticsPeriodText = new Text(composite1, SWT.BORDER);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		statisticsPeriodText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Threshold");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		statisticsThresholdText = new Text(composite1, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		statisticsThresholdText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Type");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		statisticsTypeCombo = new Combo(composite1, SWT.DROP_DOWN
				| SWT.READ_ONLY);

		statisticsTypeCombo.add(ExecuteStatisticsMibGet.THRESHOLD_TYPE_NONE);
		statisticsTypeCombo
				.add(ExecuteStatisticsMibGet.THRESHOLD_TYPE_DIFFERENCE);
		statisticsTypeCombo
				.add(ExecuteStatisticsMibGet.THRESHOLD_TYPE_INTEGRAL);
		statisticsTypeCombo.select(0);

		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH1;
		statisticsTypeCombo.setLayoutData(gridData);

		addButton = new Button(composite1, SWT.NONE);
		addButton.setText("Add");
		data = new GridData();
		data.horizontalSpan = 2;
		data.verticalSpan = 1;
		addButton.setLayoutData(data);

		editButton = new Button(composite1, SWT.NONE);
		editButton.setText("Edit");
		data = new GridData();
		data.horizontalSpan = 2;
		data.verticalSpan = 1;
		editButton.setLayoutData(data);

		deleteButton = new Button(composite1, SWT.NONE);
		deleteButton.setText("Delete");
		data = new GridData();
		data.horizontalSpan = 2;
		data.verticalSpan = 1;
		deleteButton.setLayoutData(data);

		GridLayout gridLayout2 = new GridLayout(1, false);
		Composite composite2 = new Composite(composite0, SWT.LEFT);
		composite2.setLayoutData(new GridData());
		composite2.setLayout(gridLayout2);

		scrollComposite.setContent(composite0);
		scrollComposite.setMinSize(SCROLL_COMPOSITE_SIZE[0],
				SCROLL_COMPOSITE_SIZE[1]);
		scrollComposite.setExpandHorizontal(true);
		scrollComposite.setExpandVertical(true);

		try {
			getStatisticsList(targetNodeInfo.getIpaddress());
		} catch (DatabaseConnectionException e2) {
			logger.warning(e2.getMessage());
		} catch (SQLException e2) {
			logger.warning(e2.getMessage());
		} catch (IOException e1) {
			logger.warning(e1.getMessage());
		} catch (EngineConnectException e1) {
			logger.warning(e1.getMessage());
		}

		setTextDefaultNodeInfo(targetNodeInfo);

		/*
		 * AgentAhX[hăXgɕ\{^ Listener
		 */
		loadOidListButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				loadOidListButton.setEnabled(false);
				addButton.setEnabled(false);
				editButton.setEnabled(false);
				deleteButton.setEnabled(false);

				try {

					getStatisticsList(targetNodeInfo.getIpaddress());
				} catch (SQLException e1) {
					logger.warning(e1.getMessage());

					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error", e1.getMessage());
					shell.dispose();
				} catch (DatabaseConnectionException e1) {
					logger.warning(e1.getMessage());

					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error", e1.getMessage());
					shell.dispose();
				} catch (IOException e1) {
					logger.warning(e1.getMessage());

					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error", e1.getMessage());
					shell.dispose();
				} catch (EngineConnectException e1) {
					logger.warning(e1.getMessage());

					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error", e1.getMessage());
					shell.dispose();
				} finally {
					addButton.setEnabled(true);
					editButton.setEnabled(true);
					deleteButton.setEnabled(true);
					loadOidListButton.setEnabled(true);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/* SnmpvListIListener */
		baseSnmpStatisticsList.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				int index = baseSnmpStatisticsList.getSelectionIndex();
				String[] oidInfo = (String[]) statisticsMibList.get(index);
				String oid = oidInfo[StatisticsMibFileParse.OID_POS];

				// SnmpvListIOIDTextɃZbg
				statisticsOidText.setText(oid);
			}
		});

		/* SnmpvWListOIDXgIListener */
		collectSnmpStatisticsList.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				int index = collectSnmpStatisticsList.getSelectionIndex();
				String oid = (String) oidList.get(index);
				statisticsOidText.setText(oid);

				try {
					/*
					 * IvWOIDɑΉvpeB TextɃZbg
					 */
					setPropertyText(targetNodeInfo.getIpaddress(), oid);
				} catch (DatabaseConnectionException e1) {
					logger.warning(e1.getMessage());

					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error", e1.getMessage());
					shell.dispose();
				} catch (SQLException e1) {
					logger.warning(e1.getMessage());

					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error", e1.getMessage());
					shell.dispose();
				} catch (IOException e1) {
					logger.warning(e1.getMessage());

					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error", e1.getMessage());
					shell.dispose();
				} catch (EngineConnectException e1) {
					logger.warning(e1.getMessage());

					Shell shell = new Shell();
					MessageDialog.openError(shell, "Error", e1.getMessage());
					shell.dispose();
				}
			}
		});

		/* vWOIDǉ{^ Listener */
		addButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				addButton.setEnabled(false);
				editButton.setEnabled(false);
				deleteButton.setEnabled(false);
				loadOidListButton.setEnabled(false);

				String setNodeName = statisticsNodeNameText.getText();
				String setIPaddress = statisticsNodeIPAddressText.getText();
				String setOid = statisticsOidText.getText();

				try {
					if (setOid.equals("")) {
						Shell shell = new Shell();
						MessageDialog.openError(shell, "Error", "Error OID = "
								+ setOid);
						shell.dispose();

						return;
					}

					for (int i = 0; i < oidList.size(); i++) {
						if (setOid.equals(oidList.get(i))) {
							Shell shell = new Shell();
							MessageDialog.openError(shell, "Error",
									"Already OID = " + setOid);
							shell.dispose();

							return;
						}
					}

					String setCommunity = statisticsCommunityText.getText();

					if (!checkTextData()) {
						return;
					}
					String setPeriod = statisticsPeriodText.getText();

					String setThreshold = statisticsThresholdText.getText();

					int selectType = statisticsTypeCombo.getSelectionIndex();

					String setThresholdType = statisticsTypeCombo
							.getItem(selectType);

					int snmpVersion = 0;

					/*
					 * if (snmpVersion.equals("SNMPV1")) {
					 * nodewatchinfo.setSnmpVersion(SnmpDefine.SNMP_VERSION_1); }
					 * else if (snmpVersion.equals("SNMPV2C")) {
					 * nodewatchinfo.setSnmpVersion(SnmpDefine.SNMPV2C); } else
					 * if (snmpVersion.equals("SNMPV3")) {
					 * nodewatchinfo.setSnmpVersion(SnmpDefine.SNMPV3); } else {
					 * logger.warning("Bad snmp version : " + snmpVersion); }
					 */

					// e[u쐬
					ThreadStatisticsMibGetControl ifoctet = new ThreadStatisticsMibGetControl();
					ifoctet.setStatistics(setIPaddress, snmpVersion,
							setCommunity, setPeriod, setOid, setThreshold,
							setThresholdType);

					// ThreadXgL[ɓo^
					StatisticsMibInfo mibInfo = StatisticsMibInfo
							.getInstance(setIPaddress);

					mibInfo.setNodeName(setNodeName);
					mibInfo.setCommunity(setCommunity);
					mibInfo.setVersion(snmpVersion);
					mibInfo.setOidList(setOid, setPeriod, setThreshold,
							setThresholdType);

					ListQueueStatisticsMibControl.getInstance()
							.setStatisticsMibGetNode(setIPaddress, mibInfo);
				} finally {
					try {
						getStatisticsList(setIPaddress);
					} catch (DatabaseConnectionException e1) {
						logger.warning(e1.getMessage());

						Shell shell = new Shell();
						MessageDialog
								.openError(shell, "Error", e1.getMessage());
						shell.dispose();
					} catch (SQLException e1) {
						logger.warning(e1.getMessage());

						Shell shell = new Shell();
						MessageDialog
								.openError(shell, "Error", e1.getMessage());
						shell.dispose();
					} catch (IOException e1) {
						logger.warning(e1.getMessage());

						Shell shell = new Shell();
						MessageDialog
								.openError(shell, "Error", e1.getMessage());
						shell.dispose();
					} catch (EngineConnectException e1) {
						logger.warning(e1.getMessage());

						Shell shell = new Shell();
						MessageDialog
								.openError(shell, "Error", e1.getMessage());
						shell.dispose();
					}

					addButton.setEnabled(true);
					editButton.setEnabled(true);
					deleteButton.setEnabled(true);
					loadOidListButton.setEnabled(true);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/* vWOIDҏW{^ Listener */
		editButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				addButton.setEnabled(false);
				editButton.setEnabled(false);
				deleteButton.setEnabled(false);
				loadOidListButton.setEnabled(false);

				String setNodeName = statisticsNodeNameText.getText();
				String setIPaddress = statisticsNodeIPAddressText.getText();
				String setOid = statisticsOidText.getText();

				try {
					if (setOid.equals("")) {
						Shell shell = new Shell();
						MessageDialog.openError(shell, "Error", "Error OID = "
								+ setOid);
						shell.dispose();

						return;
					}

					boolean isFoundOid = false;

					for (int i = 0; i < oidList.size(); i++) {
						if (setOid.equals(oidList.get(i))) {
							isFoundOid = true;
						}
					}

					if (!isFoundOid) {
						Shell shell = new Shell();
						MessageDialog.openError(shell, "Error",
								"NotFound OID = " + setOid);

						return;
					}

					String setCommunity = statisticsCommunityText.getText();

					if (!checkTextData()) {
						return;
					}
					String setPeriod = statisticsPeriodText.getText();
					String setThreshold = statisticsThresholdText.getText();
					int selectType = statisticsTypeCombo.getSelectionIndex();

					String setThresholdType = statisticsTypeCombo
							.getItem(selectType);

					int snmpVersion = 0;

					StatisticsMibInfo mibInfo = StatisticsMibInfo
							.getInstance(setIPaddress);

					StatisticsMibDBRegister mibStatisGet = new StatisticsMibDBRegister(
							setIPaddress, snmpVersion, setCommunity);
					mibStatisGet.updateMibStatisticsSetDatabase(setOid,
							setPeriod, setThreshold, setThresholdType);

					// ThreadXgL[̓o^U폜
					ListQueueStatisticsMibControl.getInstance()
							.removeStatisticsMibGetNode(setIPaddress);

					// ThreadXgL[ɍēo^
					mibInfo.setNodeName(setNodeName);
					mibInfo.setVersion(snmpVersion);
					mibInfo.setCommunity(setCommunity);
					mibInfo.updateOidList(setOid, setPeriod, setThreshold,
							setThresholdType);

					/*
					 * Iterator it; Map list = mibInfo.getOidList();
					 * 
					 * for (it = list.keySet().iterator(); it.hasNext();) {
					 * String key = (String) it.next(); System.out.println("key : " +
					 * key); }
					 */

					ListQueueStatisticsMibControl.getInstance()
							.setStatisticsMibGetNode(setIPaddress, mibInfo);
				} finally {
					try {
						getStatisticsList(setIPaddress);
					} catch (DatabaseConnectionException e1) {
						logger.warning(e1.getMessage());

						Shell shell = new Shell();
						MessageDialog
								.openError(shell, "Error", e1.getMessage());
						shell.dispose();
					} catch (SQLException e1) {
						logger.warning(e1.getMessage());

						Shell shell = new Shell();
						MessageDialog
								.openError(shell, "Error", e1.getMessage());
						shell.dispose();
					} catch (IOException e1) {
						logger.warning(e1.getMessage());

						Shell shell = new Shell();
						MessageDialog
								.openError(shell, "Error", e1.getMessage());
						shell.dispose();
					} catch (EngineConnectException e1) {
						logger.warning(e1.getMessage());

						Shell shell = new Shell();
						MessageDialog
								.openError(shell, "Error", e1.getMessage());
						shell.dispose();
					}

					addButton.setEnabled(true);
					editButton.setEnabled(true);
					deleteButton.setEnabled(true);
					loadOidListButton.setEnabled(true);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/* vWOID폜{^ Listener */
		deleteButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				addButton.setEnabled(false);
				editButton.setEnabled(false);
				deleteButton.setEnabled(false);
				loadOidListButton.setEnabled(false);

				String setIPaddress = statisticsNodeIPAddressText.getText();
				String setOid = statisticsOidText.getText();

				try {
					if (setOid.equals("")) {
						Shell shell = new Shell();
						MessageDialog.openError(shell, "Error", "Error OID = "
								+ setOid);
						shell.dispose();

						return;
					}

					boolean isFoundOid = false;

					for (int i = 0; i < oidList.size(); i++) {
						if (setOid.equals(oidList.get(i))) {
							isFoundOid = true;
						}
					}

					if (!isFoundOid) {
						Shell shell = new Shell();
						MessageDialog.openError(shell, "Error",
								"NotFound OID = " + setOid);
						shell.dispose();

						return;
					}

					String setCommunity = statisticsCommunityText.getText();

					int snmpVersion = 0;

					StatisticsMibInfo mibInfo = StatisticsMibInfo
							.getInstance(setIPaddress);

					StatisticsMibDBRegister mibStatisGet = new StatisticsMibDBRegister(
							setIPaddress, snmpVersion, setCommunity);
					mibStatisGet.updateMibStatisticsSetDatabase(setOid, "--",
							"--", "--");

					// ΏIP AddressThreadXgL[o^폜
					ListQueueStatisticsMibControl.getInstance()
							.removeStatisticsMibGetNode(setIPaddress);

					mibInfo.removeOid(setOid);

					Iterator it;
					Map list = mibInfo.getOidList();

					for (it = list.keySet().iterator(); it.hasNext();) {
						String key = (String) it.next();
						System.out.println("key : " + key);
					}

					// ThreadXgL[ɍēo^
					ListQueueStatisticsMibControl.getInstance()
							.setStatisticsMibGetNode(setIPaddress, mibInfo);
				} finally {
					try {
						getStatisticsList(setIPaddress);
					} catch (DatabaseConnectionException e1) {
						logger.warning(e1.getMessage());

						Shell shell = new Shell();
						MessageDialog
								.openError(shell, "Error", e1.getMessage());
						shell.dispose();
					} catch (SQLException e1) {
						logger.warning(e1.getMessage());

						Shell shell = new Shell();
						MessageDialog
								.openError(shell, "Error", e1.getMessage());
						shell.dispose();
					} catch (IOException e1) {
						logger.warning(e1.getMessage());

						Shell shell = new Shell();
						MessageDialog
								.openError(shell, "Error", e1.getMessage());
						shell.dispose();
					} catch (EngineConnectException e1) {
						logger.warning(e1.getMessage());

						Shell shell = new Shell();
						MessageDialog
								.openError(shell, "Error", e1.getMessage());
						shell.dispose();
					}

					addButton.setEnabled(true);
					editButton.setEnabled(true);
					deleteButton.setEnabled(true);
					loadOidListButton.setEnabled(true);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});
	}

	/*
	 * m[heLXgɕ\܂B
	 * 
	 * @param nodeInfo m[hĎ
	 */
	private void setTextDefaultNodeInfo(NodeInformation nodeInfo) {
		statisticsTypeCombo.select(0);
		statisticsNodeNameText.setText(nodeInfo.getNodename());
		statisticsNodeIPAddressText.setText(nodeInfo.getIpaddress());
		statisticsCommunityText.setText(nodeInfo.getRoCommunity());
	}

	private boolean checkTextData() {
		String setPeriod = statisticsPeriodText.getText();
		try {
			int work0 = Integer.parseInt(setPeriod);
		} catch (NumberFormatException e) {

			MessageDialog.openError(getSite().getShell(), "Error",
					"Format error");
			statisticsPeriodText.setFocus();
			return false;
		}
		String setThreshold = statisticsThresholdText.getText();
		try {
			int work1 = Integer.parseInt(setThreshold);
		} catch (NumberFormatException e) {
			MessageDialog.openError(getSite().getShell(), "Error",
					"Format error");
			statisticsThresholdText.setFocus();
			return false;
		}
		return true;
	}

	/*
	 * v̎撆OIDXg\܂B \ɂẮAOIDDescriptionƍ̎t \܂B
	 * 
	 * @param ipAddress m[hIPAhX @throws DatabaseConnectionException
	 * f[^x[XRlNV擾Ɏsꍇ @throws SQLException f[^x[XANZXɎsꍇ @throws
	 * IOException GWڑɎsꍇ @throws EngineConnectException GWڑɎsꍇ
	 */
	private void getStatisticsList(String ipAddress)
			throws DatabaseConnectionException, SQLException, IOException,
			EngineConnectException {
		ArrayList statisticsMibSetStatusList = null;

		if (!isSocket) {
			DBTableStatisticsMIBControl mibDBTable = DBTableStatisticsMIBControl
					.getInstance();

			statisticsMibSetStatusList = mibDBTable.getList(ipAddress);
		} else {
			String engineAddress = ClientEngineInfo
					.getClientEngineInfoInstance().getEngineAddress();

			StatisticsMibControl control = new StatisticsMibControl();
			control
					.setSubCommand(StatisticsMibControl.STATISTICS_SET_STATUS_GET);
			control.setIpaddress(ipAddress);

			ConnectionStatisticsMibGet statisticsMibGet = new ConnectionStatisticsMibGet(
					engineAddress);

			StatisticsMibProperty mibproperty = statisticsMibGet
					.getStatisticsMib(control);

			if (mibproperty != null) {
				statisticsMibSetStatusList = mibproperty
						.getStatisticsMibSetList();
			}
		}

		collectSnmpStatisticsList.removeAll();
		oidList.clear();

		for (int i = 0; i < statisticsMibSetStatusList.size(); i++) {
			StatisticsMibSetStatus test = (StatisticsMibSetStatus) statisticsMibSetStatusList
					.get(i);

			String oid = test.getReadOid();
			String oidDescription = "";
			oidList.add(oid);

			/* OIDɑΉDescription */
			if (ManagerMibTree.getInstance().getOidHashMap().containsKey(oid)) {
				MibInfo miboid = (MibInfo) ManagerMibTree.getInstance()
						.getOidHashMap().get(oid);
				oidDescription = miboid.getDescrip();
			}

			/* ̎OIDXg\Zbg */
			collectSnmpStatisticsList
					.add(test.getReadOid() + " : " + oidDescription
							+ " (period=" + test.getReadPeriod() + ")");
		}
	}

	/*
	 * SNMPvMIB̎ԊuA臒lA臒lĎ^Cv擾܂B
	 * 
	 * @param ipAddress m[hIPAhX @param oid OID @throws
	 * DatabaseConnectionException f[^x[XRlNV擾Ɏsꍇ @throws SQLException
	 * f[^x[XANZXɎsꍇ @throws IOException GWڑɎsꍇ @throws
	 * EngineConnectException GWڑɎsꍇ
	 */
	private void setPropertyText(String ipAddress, String oid)
			throws DatabaseConnectionException, SQLException, IOException,
			EngineConnectException {
		ArrayList statisticsMibSetStatusList = null;

		if (!isSocket) {
			/*  */
			DBTableStatisticsMIBControl mibDBTable = DBTableStatisticsMIBControl
					.getInstance();

			statisticsMibSetStatusList = mibDBTable.getList(ipAddress);
		} else {
			String engineAddress = ClientEngineInfo
					.getClientEngineInfoInstance().getEngineAddress();

			StatisticsMibControl control = new StatisticsMibControl();
			control
					.setSubCommand(StatisticsMibControl.STATISTICS_SET_STATUS_GET);
			control.setIpaddress(ipAddress);

			ConnectionStatisticsMibGet statisticsMibGet = new ConnectionStatisticsMibGet(
					engineAddress);

			StatisticsMibProperty mibproperty = statisticsMibGet
					.getStatisticsMib(control);

			if (mibproperty != null) {
				statisticsMibSetStatusList = mibproperty
						.getStatisticsMibSetList();
			}
		}

		for (int i = 0; i < statisticsMibSetStatusList.size(); i++) {
			StatisticsMibSetStatus statisMibSetStatus = (StatisticsMibSetStatus) statisticsMibSetStatusList
					.get(i);

			if (oid.equals(statisMibSetStatus.getReadOid())) {
				statisticsPeriodText
						.setText(statisMibSetStatus.getReadPeriod());
				statisticsThresholdText.setText(statisMibSetStatus
						.getReadThreshold());

				if (statisMibSetStatus.getReadThresholdType().equals(
						ExecuteStatisticsMibGet.THRESHOLD_TYPE_DIFFERENCE)) {
					statisticsTypeCombo.select(1);
				} else if (statisMibSetStatus.getReadThresholdType().equals(
						ExecuteStatisticsMibGet.THRESHOLD_TYPE_INTEGRAL)) {
					statisticsTypeCombo.select(2);
				} else {
					statisticsTypeCombo.select(0);
				}
			}
		}
	}

	/**
	 * Xe[^XC\Zbg܂B
	 * 
	 */
	protected void setStatusLine() {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getEditorSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);
	}

}
