/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpobject.integer;

import java.math.BigInteger;

import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.preference.SnmpBERCodec;



/**
 * ASN.1 Type(^O)ɂUINTEGER32(^Oԍ 0x47)ɑΉSNMPIuWFNg
 * 삷郁\bhNXłB
 *
 * @see netjfwatcher.snmp.snmpobject.integer.SNMPInteger
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpUInteger32 extends SnmpInteger {
    // maximum value is 2^32 - 1
    private static BigInteger maxValue = new BigInteger("4294967295");

    /**
     * l0SNMP UINTEGER32IuWFNg𐶐܂B
   @*/
    public SnmpUInteger32() {
        this(0); // initialize value to 0
    }

    /**
     * w̒lSNMP UINTEGER32IuWFNg𐶐܂B
     *
     * @param newValue JE^[l
     */
    public SnmpUInteger32(long newValue) {
        integerValue = new BigInteger(Long.toString(newValue));

        // value > maxValue ̏ꍇAmaxValueZbg
        integerValue = integerValue.mod(maxValue);
        tag = SnmpBERCodec.SNMPUINTEGER32_TAG;
        tagDescription = SnmpBERCodec.SNMPUINTEGER32;
    }

    /**
     * ASN.1 BER encodingf[^ɂSNMP UINTEGER32IuWFNg𐶐܂B
     *
     * @param enc ASN.1 BER encodingf[^
     * @throws SnmpBadValueException SNMP UINTEGER32IuWFNgɎsꍇ
   @*/
    public SnmpUInteger32(byte[] enc) throws SnmpBadValueException {
        extractValueFromBEREncoding(enc);

        // value > maxValue ̏ꍇAmaxValueZbg
        integerValue = integerValue.mod(maxValue);
        tag = SnmpBERCodec.SNMPUINTEGER32_TAG;
        tagDescription = SnmpBERCodec.SNMPUINTEGER32;
    }

    /**
     * SNMP UINTEGER32IuWFNgɃf[^Zbg܂B
     *
     * @param newValue ZbgIuWFNgl
     * @throws SnmpBadValueException f[^ZbgɎsꍇ
   @*/
    public void setValue(Object newValue) throws SnmpBadValueException {
        if (newValue instanceof BigInteger) {
            integerValue = (BigInteger) newValue;
            integerValue = integerValue.mod(maxValue); // wrap when value exceeds 2^32
        } else if (newValue instanceof Integer) {
            integerValue = new BigInteger(newValue.toString());
            integerValue = integerValue.mod(maxValue); // wrap when value exceeds 2^32
        } else if (newValue instanceof String) {
            try {
                integerValue = new BigInteger((String) newValue);
                integerValue = integerValue.mod(maxValue); // wrap when value exceeds 2^32
            } catch (NumberFormatException e) {
                throw new SnmpBadValueException(
                    " Unsigned Integer: bad object supplied to set value ");
            }
        } else {
            throw new SnmpBadValueException(
                " Unsigned Integer: bad object supplied to set value ");
        }
    }
}
