/*
 * Created on 2004/04/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmp.snmpobject.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import netjfwatcher.snmp.messageformat.SNMPTLV;
import netjfwatcher.snmp.messageformat.SnmpBadValueException;
import netjfwatcher.snmp.messageformat.SnmpTrapPDU;
import netjfwatcher.snmp.snmpobject.integer.SnmpInteger;
import netjfwatcher.snmp.snmpobject.octetstring.SnmpOctetString;



/**
 * SNMP MessagetH[}bg𑀍삷郁\bhNXłB
 * MessagetH[}bg͈ȉ̍\ɂȂ܂B
 * +----------+-----------+---------------+
 * | Version  | Community |   SNMP PDU    |
 * +----------+-----------+---------------+
 * ̃bZ[W̓ɃV[PXTAGt̂AUDP\Pbgf[^
 * ƂđM܂B
 *
 * SNMP MessageIuWFNǵAȉ̏ō\AeTLVIuWFNg
 * ƂVectorXgɕێ܂B
 *
 * EVersion
 * ECommunity
 * EPDU
 *
 * SNMPbZ[WRFC 1157yRFC 1901ɂĒ`܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpMessage extends SnmpSequence {
    /** SNMPbZ[Wɂo[Ẅʒu */
    public static final int MESSAGE_SEQUENCE_VERSION_POS = 0;

    /** SNMPbZ[WɂR~jeB̈ʒu */
    public static final int MESSAGE_SEQUENCE_COMMUNITY_POS = 1;

    /** SNMPbZ[WɂPDÜʒu */
    public static final int MESSAGE_SEQUENCE_PDU_POS = 2;

    /** ێf[^Xgł̃o[Ẅʒu */
    public static final int VERSION_POS = 0;

    /** ێf[^Xgł̃R~jeB̈ʒu */
    public static final int COMMUNITY_POS = 1;

    /** ێf[^XgłPDÜʒu */
    public static final int PDU_POS = 2;

    /* ێSNMPIuWFNg Contents */
    private List contentsList;

    /**
     * SNMP MessageIuWFNg𐶐܂B
     *
     */
    public SnmpMessage() {
        contentsList = Collections.synchronizedList(new ArrayList());
    }

    /**
     * SNMP MessageIuWFNgȉ̏񂩂琶܂B
     * ESNMPo[Wԍ
     * ESNMPR~jeB
     * ESNMP PDU
     * e񂩂TLVIuWFNg𐶐ăXgƂĕێ܂B
     *
     * @param version SNMPo[W
     * @param community R~jeB
     * @param pdu PDU
   @*/
    public SnmpMessage(int version, String community, SnmpPDU pdu) {
        super();
        contentsList = Collections.synchronizedList(new ArrayList());
        contentsList.add(VERSION_POS, new SnmpInteger(version));
        contentsList.add(COMMUNITY_POS, new SnmpOctetString(community));
        contentsList.add(PDU_POS, pdu);

        try {
            this.setValue(contentsList);
        } catch (SnmpBadValueException e) {
            // can't happen! all supplied Vector elements are SNMP Object subclasses
        }
    }

    /**
     * SNMP Trap MessageIuWFNgSNMPo[WԍASNMPR~jeBy
     * Trap PDU琶܂B
     *
     * @param version SNMPo[W
     * @param community R~jeB
     * @param trapPdu Trap PDU
     */
    public SnmpMessage(int version, String community, SnmpTrapPDU trapPdu) {
        super();
        contentsList = Collections.synchronizedList(new ArrayList());
        contentsList.add(VERSION_POS, new SnmpInteger(version));
        contentsList.add(COMMUNITY_POS, new SnmpOctetString(community));
        contentsList.add(PDU_POS, trapPdu);

        try {
            this.setValue(contentsList);
        } catch (SnmpBadValueException e) {
            // can't happen! all supplied Vector elements are SNMP Object subclasses
        }
    }

    /**
     * ASN.1 BERGR[fBOoCgf[^͂SNMP Message
     * IuWFNg𐶐܂B
     *
     * @param enc ASN.1 BERGR[fBOoCgf[^
     * @throws SnmpBadValueException SNMPIuWFNgɎsꍇ
     */
    public SnmpMessage(byte[] enc) throws SnmpBadValueException {
        super(enc);
    }

    /**
     * SNMP MessageIuWFNgɃf[^Zbg܂B
     *
     * @param version SNMPo[W
     * @param community R~jeB
     * @param pdu PDU
     */
    public void setSNMPMessage(int version, String community, SnmpPDU pdu) {
        contentsList.clear();
        contentsList.add(VERSION_POS, new SnmpInteger(version));
        contentsList.add(COMMUNITY_POS, new SnmpOctetString(community));
        contentsList.add(PDU_POS, pdu);

        try {
            this.setValue(contentsList);
        } catch (SnmpBadValueException e) {
            // can't happen! all supplied Vector elements are SNMP Object subclasses
        }
    }

    /**
     * w肳ꂽASN.1 BER SNMP TLVCX^X̒ltB[h͂ASN.1 BER
     * ɂVTLVNXCX^XƂContentsXgɕێ܂B
     *
     * @param nextTLV  ASN.1 BER TLVNXCX^X
     * @throws SnmpBadValueException
     */
    public void setTLV(SNMPTLV nextTLV) throws SnmpBadValueException {
        this.extractFromBEREncoding(nextTLV.getValue());
    }

    /**
     * SNMP PDUԂ܂B
     *
     * @return PDU SNMP PDU
     * @throws SnmpBadValueException ێĂPDUPDU^Cvُȏꍇ
     */
    public SnmpPDU getPDU() throws SnmpBadValueException {
        List contents = (List) (this.getValue());
        Object pdu = contents.get(PDU_POS);

        if (!(pdu instanceof SnmpPDU)) {
            throw new SnmpBadValueException(
                "Wrong PDU type in message: expected SNMPPDU, have "
                + pdu.getClass().toString());
        }

        return (SnmpPDU) pdu;
    }

    /**
     * SNMP Trap PDUԂ܂B
     *
     * @return SNMP Trap PDU
     * @throws SnmpBadValueException PDU^Cvُȏꍇ
     */
    public SnmpTrapPDU getTrapPDU() throws SnmpBadValueException {
        List contents = (List) (this.getValue());
        Object pdu = contents.get(PDU_POS);

        if (!(pdu instanceof SnmpTrapPDU)) {
            throw new SnmpBadValueException(
                "Wrong PDU type in message: expected SNMPTrapPDU, have "
                + pdu.getClass().toString());
        }

        return (SnmpTrapPDU) pdu;
    }

    /**
     * SNMP TAGR[hԂ܂B
     *
     * @return SNMP TAGR[h
     */
    public byte getCommand() {
        List sequenceContentsList = this.getSequenceContentsList();

        return ((SNMPTLV) sequenceContentsList.get(MESSAGE_SEQUENCE_PDU_POS)).getTag();
    }

    /**
     * SNMPR~jeBԂ܂B
     *
     * @return SNMPR~jeB
     */
    public byte[] getCommunity() {
        List sequenceContentsList = this.getSequenceContentsList();

        return ((SNMPTLV) sequenceContentsList.get(
            MESSAGE_SEQUENCE_COMMUNITY_POS)).getValue();
    }

    /**
     * SNMP VersionԍԂ܂B
     *
     * @return SNMP Versionԍ
     */
    public byte[] getVersion() {
        List sequenceContentsList = this.getSequenceContentsList();

        return ((SNMPTLV) sequenceContentsList.get(
            MESSAGE_SEQUENCE_VERSION_POS)).getValue();
    }
}
