/*
 * Created on 2004/10/11
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent;

import netjfwatcher.snmpagent.process.ThreadAgent;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;


/**
 * SNMP Agent ViewŎ郁\bh`钊ۃNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public abstract class AbstractAgentView extends ViewPart {
	/** zFColor` */
    protected static Color whiteColor = new Color(null, 255, 255, 255);
    
    /**
     * PartControl𐶐܂B
     *
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.
     * eclipse.swt.widgets.Composite)
     */
    public abstract void createPartControl(Composite parent);

    /**
     * tH[JXZbgꂽ̏łB
     * Xe[^XC\Zbg܂B
     */
    public void setFocus() {
        setStatusLine();
    }

    /**
     * Xe[^XCZbg܂B
     *
     */
    protected void setStatusLine() {
        /* Xe[^XC}l[W */
        SubStatusLineManager statusLineManager;

        /* Xe[^XC\L */
        statusLineManager =
            (SubStatusLineManager) (getViewSite().getActionBars()
                                        .getStatusLineManager());
        statusLineManager.setVisible(true);

        if (ThreadAgent.getInstance().checkThread()) {
            statusLineManager.setMessage(
                AgentTableView.AGENT_THREAD_ALIVE_MESSAGE);
        } else {
            statusLineManager.setMessage(
                AgentTableView.AGENT_THREAD_DEAD_MESSAGE);
        }
    }
}
