/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpagent.model;

import java.util.HashMap;
import java.util.List;

import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.snmp.mibtree.AgentMibTree;
import netjfwatcher.snmp.mibtree.ManagerMibTree;
import netjfwatcher.snmp.mibtree.MibInfo;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.snmpobject.message.AbstractSnmpObject;
import netjfwatcher.snmpagent.AgentDataEditorView;
import netjfwatcher.snmpagent.AgentInstanceControlOperationView;
import netjfwatcher.snmpagent.AgentTableViewLabelProvider;
import netjfwatcher.snmpagent.AgentTrapSendView;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;




/**
 * AgentCX^Xe[uIXi[NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class AgentTableListener extends SelectionAdapter {
    /* AgentCX^Xe[u */
    private Table table;
    /* Agent CX^Xe[ȗIԍ */
    private String selectNo;

    /*  Agent CX^Xe[ȗIOID Description */
    private String selectOidDescription;

    /* Agent CX^Xe[ȗIOID */
    private String selectOid;

    /* Agent CX^Xe[ȗIOID̒l */
    private String selectValue;

    /* Agent CX^Xe[ȗIOIDType */
    private String selectType;

    /* Agent CX^Xe[ȗIOIDAccess */
    private String selectAccess;

    /**
     * AgentCX^Xe[uIXi[NX
     * CX^X𐶐܂B
     *
     * @param table AgentCX^Xe[u
     */
    public AgentTableListener(Table table) {
        this.table = table;
    }

    /**
     * AgentCX^Xe[uIłB
     *
     * @param event SelectionEvent
     */
    public void widgetSelected(SelectionEvent event) {
        /* e[uIs(Row)o */
        int index = table.getSelectionIndex();

        if (index == -1) {
            return;
        }

        // TablȇI͈͂
        table.setSelection(new int[0]);

        // Iꂽs(Row)TableItem擾
        TableItem item = table.getItem(index);
        selectNo =
            item.getText(AgentTableViewLabelProvider.AGENT_MIB_INSTANCE_NO);
        selectOidDescription =
            item.getText(AgentTableViewLabelProvider.OID_DESC);
        selectOid = item.getText(AgentTableViewLabelProvider.OID);
        selectValue = item.getText(AgentTableViewLabelProvider.VALUE);
        selectType = item.getText(AgentTableViewLabelProvider.TYPE);
        selectAccess = item.getText(AgentTableViewLabelProvider.ACCESS);

        /* AgentCX^Xf[^ҏWViewZbg */
        setEditorView();

        /*
         * Iꂽe[uSnmpG[WFg
         * Iy[VViewɃZbg
         */
        AgentInstanceControlOperationView view =
            NetJFWatcherApplication.getAgentInstanceControlOperationView();

        if (view != null) {

            view.getDescriptionText().setText(selectOidDescription);
            view.getOidText().setText(selectOid);
            view.getValueText().setText(selectValue);
            view.getTypeText().setText(selectType);
            view.getAccessText().setText(selectAccess);
        }

        /* TrapMViewZbg */
        setTrapSendView();
    }

    /*
     * AgentCX^Xf[^ҏWViewZbg܂B
     *
     */
    private void setEditorView() {
        AgentDataEditorView editorView =
            NetJFWatcherApplication.getAgentDataEditorView();

        if (editorView != null) {
            editorView.getNoText().setText(selectNo);
            editorView.getOidDescriptionText().setText(selectOidDescription);
            editorView.getOidText().setText(selectOid);

            editorView.getTypeText().setText(selectType);
            editorView.getAccessText().setText(selectAccess);

            if (selectType.equals(ManagerMibTree.TIMETICKS)) {
                AgentMibTree mibtable = AgentMibTree.getInstance();
                HashMap oidMap = mibtable.getOidHashMap();

                if (oidMap.containsKey(selectOid)) {
                    MibInfo miboid = (MibInfo) oidMap.get(selectOid);

                    if (miboid != null) {
                        AbstractSnmpObject timeTicksObject =
                            ((MibInfo) oidMap.get(selectOid)).getAgentMibValue();
                        editorView.getValueText().setText(
                            timeTicksObject.getValue().toString());
                    }
                }
            } else {
                editorView.getValueText().setText(selectValue);
            }
        }
    }

    /*
     * TrapMViewZbg܂B
     *
     */
    private void setTrapSendView() {
        /*
         * TrapMViewSNMP AgentCX^XZbg
         */
        AgentTrapSendView trapView = NetJFWatcherApplication.getAgentTrapSendView();
        trapView.getAdditionalVariableOIDText().setText(selectOid);
        trapView.getAdditionalVariableOIDDiscriprionText().setText(
            selectOidDescription);
        trapView.getValueAdditionalVariableText().setText(selectValue);

        /*
         * snmpTrapOIDpair(Value)ƂȂOIDIComboBoxZbg
         */
        trapView.getSnmpTrapOIDValueComboBox().remove(0);
        trapView.getSnmpTrapOIDValueComboBox().add(
            selectOidDescription + "(" + selectOid + ")", 0);
        trapView.getSnmpTrapOIDValueComboBox().select(0);

        List snmpTrapOidValueOidList = trapView.getSnmpTrapOidValueList();
        snmpTrapOidValueOidList.remove(0);
        snmpTrapOidValueOidList.add(0, selectOid);
        trapView.setSnmpTrapOidValueList(snmpTrapOidValueOidList);

        /*
         * Typeɂ킹Text\Zbg
         */
        if (selectType.equals(ManagerMibTree.INTEGER)) {
            trapView.getSnmpValueTypeCombo().setText(SnmpBERCodec.SNMPINTEGER);
        } else if (selectType.equals(ManagerMibTree.COUNTER32)) {
            trapView.getSnmpValueTypeCombo().setText(
                SnmpBERCodec.SNMPCOUNTER32);
        } else if (selectType.equals(ManagerMibTree.COUNTER64)) {
            trapView.getSnmpValueTypeCombo().setText(
                SnmpBERCodec.SNMPCOUNTER64);
        } else if (selectType.equals(ManagerMibTree.GAUGE32)) {
            trapView.getSnmpValueTypeCombo().setText(SnmpBERCodec.SNMPGAUGE32);
        } else if (selectType.equals(ManagerMibTree.OCTETSTRING)) {
            trapView.getSnmpValueTypeCombo().setText(
                SnmpBERCodec.SNMPOCTETSTRING);
        } else if (selectType.equals(ManagerMibTree.IPADDRESS)) {
            trapView.getSnmpValueTypeCombo().setText(
                SnmpBERCodec.SNMPIPADDRESS);
        } else if (selectType.equals(ManagerMibTree.OBJECTID)) {
            trapView.getSnmpValueTypeCombo().setText(
                SnmpBERCodec.SNMPOBJECTIDENTIFIER);
        } else if (selectType.equals(ManagerMibTree.TIMETICKS)) {
            trapView.getSnmpValueTypeCombo().setText(
                SnmpBERCodec.SNMPTIMETICKS);
        } else if (selectType.equals(ManagerMibTree.UINTEGER32)) {
            trapView.getSnmpValueTypeCombo().setText(
                SnmpBERCodec.SNMPUINTEGER32);
        } else if (selectType.equals(ManagerMibTree.BITS)) {
            trapView.getSnmpValueTypeCombo().setText(
                SnmpBERCodec.SNMPBITSTRING);
        } else if (selectType.equals(ManagerMibTree.OPAQUE)) {
            trapView.getSnmpValueTypeCombo().setText(SnmpBERCodec.SNMPOPAQUE);
        } else if (selectType.equals(ManagerMibTree.DISPLAYSTRING)) {
            trapView.getSnmpValueTypeCombo().setText(
                SnmpBERCodec.SNMPOCTETSTRING);
        }
    }
}
