/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Logger;

import netjfwatcher.engine.resource.SnmpV3ManagerConfig;
import netjfwatcher.engine.resource.SnmpV3ManagerConfigInfo;
import netjfwatcher.engine.resource.SnmpV3ManagerUserConfigInfo;
import netjfwatcher.engine.resource.SystemResourceConfig;
import netjfwatcher.engine.snmpmanager.process.SnmpOperationDataHolder;
import netjfwatcher.snmp.preference.SnmpBERCodec;
import netjfwatcher.snmp.preference.SnmpPreference;
import netjfwatcher.snmp.snmpv3.UsmUserManager;
import netjfwatcher.snmptest.SnmpErrorTest;

import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;



/**
 * SNMP}l[WɂSnmp V3p̃Iy[VView\
 * NXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpV3OperationView extends AbstractSnmpOperationView {
    /* Scroll Composite Size */
    private static final int[] SCROLL_COMPOSITE_SIZE = { 1000, 500 };

    /* Discovery Text */
    private static final int DISCOVERY_TEXT_WIDTH = 100;

    /* ComboBox */
    private static final int COMBO_WIDTH = 120;

    /* ComboBox */
    private static final int ERROR_TEST_COMBO_WIDTH = 180;

    /* Agent List Vertical Span */
    private static final int AGENT_LIST_VERTICAL_SPAN = 7;

    /* Agent List WidthHint */
    private static final int AGENT_LIST_WIDTH_HINT = 200;

    /* Agent List HeightHint */
    private static final int AGENT_LIST_HEIGHTHINT = 5;

    /* MO */
    private static Logger logger;

    /* Engine SysUpTimetH[}bg */
    private final DateFormat dateformat =
        new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /* Xe[^XC}l[W */
    private SubStatusLineManager statusLineManager;

    /* SNMP V3 Agenti[Xg */
    private ArrayList snmpV3InfoList;

    /* SNMP V3 Agent\Xg */
    private List snmpV3AgentList = null;

    /* SNMP V3 AgentAhXI\Text */
    private Text selectV3AgentAddressText;

    /* EngineID\Text */
    private Text engineIDText;

    /* EngineBoots\Text */
    private Text engineBootText;

    /* Engine SysupTime\Text */
    private Text engineSysUpTimeText;

    /* [U\Text */
    private Text userNameText;

    /* Auth/PrivIComboBox */
    private Combo authPrivCombo;

    /* AuthProtocolIComboBox */
    private Combo authProtocolCombo;

    /* AuthPassPhrasa\Text */
    private Text authPassPhrasaText;

    /* PrivProtocol\Text */
    private Text privProtocolText;

    /* PrivPassPhrasa\Text */
    private Text privPassPhrasaText;

    /* Agent Discovery(Learned)ԕ\Text */
    private Text agentLearnedText;

    /* Agent Discovery(Learned)ԃZbg{^ */
    private Button discoveryResetButton;

    /* ^G[IComboBox */
    private Combo snmpErrorTestCombo;

    /**
     * PartControl𐶐܂B
     *
     * @param parent Composite
     */
    public void createPartControl(Composite parent) {
        /* Xe[^XC\Zbg */
        setStatusLine();

        /* TextwiFZbg */
        textBackColor = Display.getCurrent().getSystemColor(SWT.COLOR_WHITE);

        /*
         * {^ActionŎsR}h֓nf[^z_[
         */
        dataHolder = new SnmpOperationDataHolder();
        dataHolder.setSnmpVersion(SnmpPreference.SNMPV3);

        ScrolledComposite scrollComposite =
            new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);

        GridLayout layout0 = new GridLayout(1, false);
        scrollComposite.setLayout(layout0);

        GridLayout gridLayout0 = new GridLayout(1, true);
        Composite baseComposite = new Composite(scrollComposite, SWT.NONE);
        baseComposite.setLayout(gridLayout0);
        baseComposite.setLayoutData(new GridData());

        /*
         * eCompositezueLayout
         * ieCompositec1ɔzuj
         */
        GridData gridData = null;

        /*
         * Snmp V3 AgentAhXAOIDȂǂzuComposite
         */
        GridLayout gridLayout = new GridLayout(6, false);
        Composite composite = new Composite(baseComposite, SWT.NULL);

        composite.setLayout(gridLayout);
        composite.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        gridData = new GridData();

        Label label = new Label(composite, SWT.NONE);
        label.setText("Agent Address");
        label.setLayoutData(new GridData());
        targetIPText = new Text(composite, SWT.BORDER);
        targetIPText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        targetIPText.setLayoutData(gridData);

        /* Dummy column */
        Label label2 = new Label(composite, SWT.NONE);
        label2.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 1;
        label2.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Request OID");
        label.setLayoutData(new GridData());
        oidText = new Text(composite, SWT.BORDER);
        oidText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        oidText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Set Value");
        gridData = new GridData();
        label.setLayoutData(gridData);

        setValueText = new Text(composite, SWT.BORDER);
        setValueText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = SET_VALUE_TEXT_WIDTH;
        setValueText.setLayoutData(gridData);

        /* Dummy column */
        label2 = new Label(composite, SWT.NONE);
        label2.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label2.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Access Type");
        gridData = new GridData();
        label.setLayoutData(gridData);

        accessTypeText = new Text(composite, SWT.BORDER | SWT.READ_ONLY);
        accessTypeText.setEnabled(false);
        accessTypeText.setBackground(textBackColor);
        setValueText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        accessTypeText.setLayoutData(gridData);

        label = new Label(composite, SWT.NONE);
        label.setText("Value Type");
        gridData = new GridData();
        label.setLayoutData(gridData);

        snmpValueTypeCombo =
            new Combo(composite, SWT.DROP_DOWN | SWT.READ_ONLY);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPINTEGER);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPCOUNTER32);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPCOUNTER64);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPGAUGE32);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPOCTETSTRING);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPIPADDRESS);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPNSAPADDRESS);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPOBJECTIDENTIFIER);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPTIMETICKS);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPUINTEGER32);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPBITSTRING);
        snmpValueTypeCombo.add(SnmpBERCodec.SNMPOPAQUE);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = COMBO_WIDTH;
        snmpValueTypeCombo.setLayoutData(gridData);

        /*
         * ^G[eXgpR{BoxZbg
         */
        label = new Label(composite, SWT.NONE);
        label.setText("Error test");
        gridData = new GridData();
        label.setLayoutData(gridData);

        snmpErrorTestCombo =
            new Combo(composite, SWT.DROP_DOWN | SWT.READ_ONLY);
        snmpErrorTestCombo.add(SnmpPreference.CORRECT_DESCRIPTION);
        snmpErrorTestCombo.add(
            SnmpPreference.UNSUPPORTED_SECURITY_LEVEL_DESCRIPTION);
        snmpErrorTestCombo.add(SnmpPreference.NOT_IN_TIME_PACKET_DESCRIPTION);
        snmpErrorTestCombo.add(SnmpPreference.UNKNOWN_USER_NAME_DESCRIPTION);
        snmpErrorTestCombo.add(SnmpPreference.UNKNOWN_ENGINE_ID_DESCRIPTION);
        snmpErrorTestCombo.add(SnmpPreference.WRONG_DIGEST_DESCRIPTION);
        snmpErrorTestCombo.add(SnmpPreference.DECRYPTION_ERROR_DESCRIPTION);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = ERROR_TEST_COMBO_WIDTH;
        snmpErrorTestCombo.setLayoutData(gridData);
        snmpErrorTestCombo.select(0);

        /*
         * Read/Write communityƃ{^zuComposite
         */
        GridLayout gridLayout2 = new GridLayout(6, false);
        Composite compositeBottonAndCommunity =
            new Composite(baseComposite, SWT.NONE);
        compositeBottonAndCommunity.setLayoutData(
            new GridData(GridData.HORIZONTAL_ALIGN_FILL));
        compositeBottonAndCommunity.setLayout(gridLayout2);

        label = new Label(compositeBottonAndCommunity, SWT.NONE);
        label.setText("Read Community");
        gridData = new GridData();
        label.setLayoutData(gridData);

        roCommunityText = new Text(compositeBottonAndCommunity, SWT.BORDER);
        roCommunityText.setText(READ_COMMUNITY);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        roCommunityText.setLayoutData(gridData);

        getNextButton = new Button(compositeBottonAndCommunity, SWT.NONE);
        getNextButton.setText(GETNEXTREQUEST_BUTTON);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;

        // gridData.widthHint = TEXT_WIDTH;
        getNextButton.setLayoutData(gridData);

        label = new Label(compositeBottonAndCommunity, SWT.NONE);
        label.setText("Write Community");
        gridData = new GridData();
        label.setLayoutData(gridData);

        rwCommunityText = new Text(compositeBottonAndCommunity, SWT.BORDER);
        rwCommunityText.setText(READ_WRITE_COMMUNITY);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        rwCommunityText.setLayoutData(gridData);

        snmpSetButton = new Button(compositeBottonAndCommunity, SWT.NONE);
        snmpSetButton.setText("Set");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        snmpSetButton.setLayoutData(gridData);

        
        /* Dummy column */
        label = new Label(compositeBottonAndCommunity, SWT.NONE);
        label.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label.setLayoutData(gridData);
        
        getRequestButton = new Button(compositeBottonAndCommunity, SWT.NONE);
        getRequestButton.setText(GETREQUEST_BUTTON);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        getRequestButton.setLayoutData(gridData);
        
        
        /* SNMP V3 Agnet\Composite𐶐 */
        createSnmpV3AgnetInfoComposite(baseComposite);

        /*
         *
         */
        scrollComposite.setContent(baseComposite);

        scrollComposite.setMinSize(
            SCROLL_COMPOSITE_SIZE[0], SCROLL_COMPOSITE_SIZE[1]);
        scrollComposite.setExpandHorizontal(true);
        scrollComposite.setExpandVertical(true);

        /*  */
        setInitText();

        /*
         * Snmp V3 Agent Address List SelectionListener
         */
        snmpV3AgentList.addSelectionListener(
            new SelectionAdapter() {
                public void widgetSelected(SelectionEvent e) {
                    int index = snmpV3AgentList.getSelectionIndex();

                    /* AgentI */
                    selectAgent(index);
                }
            });

        /*
         * GetNext Request{^Xi[Zbg
         */
        getRequestButton.addSelectionListener(
            new SelectionListener() {
                /**
                 * GetRequestłB
                 *
                 * @param event SelectionEvent
                 */
                public void widgetSelected(SelectionEvent event) {
                    getRequestButtonListener();
                }

                /*
                 *  (non-Javadoc)
                 * @see org.eclipse.swt.events.
                 * SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
                 */
                public void widgetDefaultSelected(SelectionEvent event) {
                }
            });
        
        /*
         * GetNextRequest{^Xi[
         */
        getNextButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent e) {
                    SnmpErrorTest.getInstance().setManagerErrorControlCode(
                        snmpErrorTestCombo.getText());

                    dataHolder.setEngineIDText(engineIDText);
                    dataHolder.setEngineBootText(engineBootText);
                    dataHolder.setEngineSysUpTimeText(engineSysUpTimeText);
                    dataHolder.setAgentLearnedText(agentLearnedText);

                    getNextRequestButtonListener();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });

        /*
         * Snmp VersionIXi[
         */
        snmpValueTypeCombo.addSelectionListener(
            SnmpV3ValueTypeSelection.getInstance());

        /*
         * Set Request{^Xi[
         */
        snmpSetButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent e) {
                    setRequestButtonListener();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });

        /*
         * Agent Discovery Reset{^Xi[Zbg
         */
        discoveryResetButton.addSelectionListener(
            new SelectionListener() {
                public void widgetSelected(SelectionEvent e) {
                    /* Agent Discovery reset */
                    resetAgentDiscovery();
                }

                /**
                 *
                 */
                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
    }

    /**
     * SNMP V3 Agnet\Composite𐶐܂B
     *
     * @param baseComposite SNMP V3 Agnet\eComposite
     */
    private void createSnmpV3AgnetInfoComposite(Composite baseComposite) {
        logger = Logger.getLogger(this.getClass().getName());

        /*
         * Snmp V3 AgentAhXXgAgentAhXɑΉ
         * vpeB\
         *
         */
        final Composite compositeSnmpV3AgentProperty =
            new Composite(baseComposite, SWT.NONE);

        GridLayout gridLayoutV3AgentProp = new GridLayout(1, false);
        compositeSnmpV3AgentProperty.setLayout(gridLayoutV3AgentProp);
        compositeSnmpV3AgentProperty.setLayoutData(
            new GridData(GridData.HORIZONTAL_ALIGN_FILL));

        Group snmpV3AgentInfoGroup =
            new Group(compositeSnmpV3AgentProperty, SWT.NONE);
        snmpV3AgentInfoGroup.setText("SNMP V3 Agent Information");
        snmpV3AgentInfoGroup.setLayout(new GridLayout(5, false));

        GridData gridData = new GridData(GridData.FILL_HORIZONTAL);

        // gridData.horizontalSpan = 2;
        snmpV3AgentInfoGroup.setLayoutData(gridData);

        snmpV3AgentList =
            new List(snmpV3AgentInfoGroup, SWT.SINGLE | SWT.BORDER);

        GridData data = new GridData(GridData.FILL_BOTH);
        data.horizontalSpan = 1;
        data.verticalSpan = AGENT_LIST_VERTICAL_SPAN;
        data.widthHint = AGENT_LIST_WIDTH_HINT;
        data.heightHint =
            snmpV3AgentList.getItemHeight() * AGENT_LIST_HEIGHTHINT;
        snmpV3AgentList.setLayoutData(data);

        snmpV3InfoList =
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .getResourceSnmpV3ConfigList();

        String[] snmpV3TargetAddress = new String[snmpV3InfoList.size()];

        /*
         * Snmp V3 AgentvpeB擾
         */
        for (int i = 0; i < snmpV3InfoList.size(); i++) {
            SnmpV3ManagerConfigInfo info =
                (SnmpV3ManagerConfigInfo) snmpV3InfoList.get(i);
            System.out.println("Address : " + info.getIpAddress());
            snmpV3TargetAddress[i] = info.getIpAddress();

            snmpV3AgentList.add(info.getIpAddress());
        }

        snmpV3AgentList.select(0);
        snmpV3AgentList.setLayoutData(data);

        Label label2 = new Label(snmpV3AgentInfoGroup, SWT.NONE);
        label2.setText("Select Agent Address");
        label2.setLayoutData(new GridData());
        selectV3AgentAddressText = new Text(snmpV3AgentInfoGroup, SWT.BORDER);
        selectV3AgentAddressText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        selectV3AgentAddressText.setLayoutData(gridData);

        label2 = new Label(snmpV3AgentInfoGroup, SWT.NONE);
        label2.setText("User Name");
        label2.setLayoutData(new GridData());
        userNameText = new Text(snmpV3AgentInfoGroup, SWT.BORDER);
        userNameText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        userNameText.setLayoutData(gridData);

        label2 = new Label(snmpV3AgentInfoGroup, SWT.NONE);
        label2.setText("EngineID");
        label2.setLayoutData(new GridData());
        engineIDText = new Text(snmpV3AgentInfoGroup, SWT.BORDER);
        engineIDText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        engineIDText.setLayoutData(gridData);
        engineIDText.setEditable(false);

        label2 = new Label(snmpV3AgentInfoGroup, SWT.NONE);
        label2.setText("AuthPriv");
        label2.setLayoutData(new GridData());
        authPrivCombo =
            new Combo(snmpV3AgentInfoGroup, SWT.DROP_DOWN | SWT.READ_ONLY);
        authPrivCombo.add(UsmUserManager.AUTHPRIV_NOAUTH);
        authPrivCombo.add(UsmUserManager.AUTHPRIV_AUTH);
        authPrivCombo.add(UsmUserManager.AUTHPRIV_PRIV);
        authPrivCombo.select(0);

        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = COMBO_WIDTH;
        authPrivCombo.setLayoutData(gridData);

        label2 = new Label(snmpV3AgentInfoGroup, SWT.NONE);
        label2.setText("EngineBoots");
        label2.setLayoutData(new GridData());
        engineBootText = new Text(snmpV3AgentInfoGroup, SWT.BORDER);
        engineBootText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        engineBootText.setLayoutData(gridData);
        engineBootText.setEditable(false);

        label2 = new Label(snmpV3AgentInfoGroup, SWT.NONE);
        label2.setText("AuthProtocol");
        label2.setLayoutData(new GridData());
        authProtocolCombo =
            new Combo(snmpV3AgentInfoGroup, SWT.DROP_DOWN | SWT.READ_ONLY);
        authProtocolCombo.add(UsmUserManager.AUTH_PROTOCOL_MD5);
        authProtocolCombo.add(UsmUserManager.AUTH_PROTOCOL_SHA);
        authProtocolCombo.select(0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = COMBO_WIDTH;
        authProtocolCombo.setLayoutData(gridData);

        label2 = new Label(snmpV3AgentInfoGroup, SWT.NONE);
        label2.setText("EngineSysUpTime");
        label2.setLayoutData(new GridData());
        engineSysUpTimeText = new Text(snmpV3AgentInfoGroup, SWT.BORDER);
        engineSysUpTimeText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        engineSysUpTimeText.setLayoutData(gridData);
        engineSysUpTimeText.setEditable(false);

        label2 = new Label(snmpV3AgentInfoGroup, SWT.NONE);
        label2.setText("AuthPassPhrase");
        label2.setLayoutData(new GridData());
        authPassPhrasaText = new Text(snmpV3AgentInfoGroup, SWT.BORDER);
        authPassPhrasaText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        authPassPhrasaText.setLayoutData(gridData);

        agentLearnedText =
            new Text(snmpV3AgentInfoGroup, SWT.BORDER | SWT.READ_ONLY);
        agentLearnedText.setText("Undiscovery");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = DISCOVERY_TEXT_WIDTH;
        agentLearnedText.setLayoutData(gridData);
        agentLearnedText.setEnabled(false);
        agentLearnedText.setBackground(textBackColor);

        discoveryResetButton = new Button(snmpV3AgentInfoGroup, SWT.NONE);
        discoveryResetButton.setText("Discovery Reset");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;

        // gridData.widthHint = 120;
        discoveryResetButton.setLayoutData(gridData);

        label2 = new Label(snmpV3AgentInfoGroup, SWT.NONE);
        label2.setText("PrivProtocol");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label2.setLayoutData(gridData);

        privProtocolText = new Text(snmpV3AgentInfoGroup, SWT.BORDER);
        privProtocolText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        privProtocolText.setLayoutData(gridData);

        /* Dummy column */
        label2 = new Label(snmpV3AgentInfoGroup, SWT.NONE);
        label2.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        label2.setLayoutData(gridData);

        label2 = new Label(snmpV3AgentInfoGroup, SWT.NONE);
        label2.setText("PrivPassPhrase");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        label2.setLayoutData(gridData);
        privPassPhrasaText = new Text(snmpV3AgentInfoGroup, SWT.BORDER);
        privPassPhrasaText.setText("");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.verticalSpan = 1;
        gridData.widthHint = TEXT_WIDTH;
        privPassPhrasaText.setLayoutData(gridData);
    }

    /*
     * AgentXgIłB
     *
     * @param index AgentIIndex
     */
    private void selectAgent(int index) {
        SnmpV3ManagerConfigInfo info =
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .getSnmpV3AgentInfo(
                snmpV3AgentList.getItem(index));

        if (info != null) {
            selectV3AgentAddressText.setText(info.getIpAddress());
            targetIPText.setText(info.getIpAddress());

            if (
                !(info.getSnmpEngineID() == null)
                    && !(info.getSnmpEngineID().equals(""))) {
                engineIDText.setText("0x" + info.getSnmpEngineID());
            } else {
                engineIDText.setText("");
            }

            if (info.getSnmpEngineBoots() != null) {
                engineBootText.setText(info.getSnmpEngineBoots());
            } else {
                engineBootText.setText("");
            }

            if (info.isLearned()) {
                agentLearnedText.setText("Dicovery");
            } else {
                agentLearnedText.setText("Undiscovery");
            }

            long agentSnmpEngineTime = 0;

            if (info.getSnmpEngineTime() != null) {
                try {
                    agentSnmpEngineTime =
                        Long.parseLong(info.getSnmpEngineTime());
                } catch (NumberFormatException e1) {
                    logger.warning(
                        "NumberFormatException " + "Agent snmp EngineTime "
                        + info.getSnmpEngineTime());
                }
            }

            if (agentSnmpEngineTime != 0) {
                Date agentDate = Calendar.getInstance().getTime();
                agentDate.setTime(agentSnmpEngineTime);

                engineSysUpTimeText.setText(dateformat.format(agentDate));
            } else {
                engineSysUpTimeText.setText("");
            }

            SnmpV3ManagerUserConfigInfo userInfo =
                (SnmpV3ManagerUserConfigInfo) info.getUserList().get(0);

            if (userInfo != null) {
                userNameText.setText(userInfo.getUsername());
                authPrivCombo.setText(userInfo.getAuthPriv());
                authProtocolCombo.setText(userInfo.getAuthProtocol());

                authPassPhrasaText.setText(userInfo.getAuthPassPhrase());
                privProtocolText.setText(userInfo.getPrivProtocol());
                privPassPhrasaText.setText(userInfo.getPrivPassPhrase());
            }
        }
    }

    /*
     * Agent discovery resetłB
     *
     */
    private void resetAgentDiscovery() {
        int index = snmpV3AgentList.getSelectionIndex();
        String selectAgentAddress = snmpV3AgentList.getItem(index);

        SnmpV3ManagerConfigInfo info =
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .getSnmpV3AgentInfo(
                snmpV3AgentList.getItem(index));

        if (selectAgentAddress.equals("")) {
            return;
        }

        engineIDText.setText("");
        engineBootText.setText("");
        engineSysUpTimeText.setText("");
        agentLearnedText.setText("Undiscovery");

        info.setLearned(false);
        info.setSnmpEngineID("");
        info.setSnmpEngineBoots("");
        info.setSnmpEngineTime("");
        SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                           .updateSnmpV3ManagerConfigInfo(
            selectAgentAddress, info);

        HashMap<String, SnmpV3ManagerConfigInfo> snmpV3ManagerMap =
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .getSnmpV3ConfigAddresssMapList();
        snmpV3ManagerMap.put(selectAgentAddress, info);

        logger.info("Discovery reset Agent=" + selectAgentAddress);
    }

    /**
     * Snmp V3G[WFgXgXV܂B
     * Snmp V3G[WFgvtFXݒEXVꂽ
     * Ă΂܂B
     *
     */
    public void updateSnmpV3AgentList() {
        /* UASnmp V3G[WFgXg폜 */
        snmpV3AgentList.removeAll();

        /*
         * Snmp V3G[WFgēǂݍ݂ăG[WFg
             * Xg\XV
             */
        snmpV3InfoList =
            SnmpV3ManagerConfig.getInstance().getResourceFileParse()
                               .getResourceSnmpV3ConfigList();

        String[] snmpV3TargetAddress = new String[snmpV3InfoList.size()];

        /*
         * Snmp V3 AgentvpeB擾
         */
        for (int i = 0; i < snmpV3InfoList.size(); i++) {
            SnmpV3ManagerConfigInfo info =
                (SnmpV3ManagerConfigInfo) snmpV3InfoList.get(i);
            System.out.println("Address : " + info.getIpAddress());
            snmpV3TargetAddress[i] = info.getIpAddress();

            snmpV3AgentList.add(info.getIpAddress());
        }

        snmpV3AgentList.select(0);
    }

    /**
     * Xe[^XC\Zbg܂B
     *
     */
    protected void setStatusLine() {
        /* Xe[^XC\L */
        statusLineManager =
            (SubStatusLineManager) (getViewSite().getActionBars()
                                        .getStatusLineManager());
        statusLineManager.setVisible(true);

        int snmpPort =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpPort();
        String snmpV3Timeout =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpV3Timeout();
        String snmpV3Retry =
            SystemResourceConfig.getInstance().getResourceFileParse()
                                .getResourceInfo().getSnmpV3Retry();

        statusLineManager.setMessage(
            "Snmp Port=" + snmpPort + " timeout=" + snmpV3Timeout + " retry="
            + snmpV3Retry);
    }
}
