/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager.model;

import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherApplication;
import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.snmpmanager.TrapReceiveTableView;
import netjfwatcher.snmpmanager.trap.ThreadTrapReceive;
import netjfwatcher.snmpmanager.trap.TrapListenerImpl;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.osgi.framework.Bundle;



/**
 * TrapMɊւANVNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderTrapReceiveTable {
    /** Timer~R[h  */
    public static final int TIMER_STOP = -1;

    /* MO */
    private static Logger logger;

    /* TrapMe[uView Display */
    private Display display;

    /* TrapMe[u */
    private final Table trapTable;

    /* Xe[^XC}l[W */
    private final SubStatusLineManager statusLineManager;

    /* 摜肷邽߂PluginResource bundle */
    private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

    /* TrapMJnANVNXCX^X𐶐 */
    private final IAction startTrap = new ActionStartTrapReceiveThread();

    /* TrapM~ANVNXCX^X𐶐 */
    private final IAction stopTrap = new ActionStopTrapReceiveThread();

    /* TrapMċNANVNXCX^X𐶐 */
    private final IAction restartTrap = new ActionRestartTrapReceiveThread();

    /* TrapMe[uNAANVNXCX^X𐶐 */
    private final IAction resetTrapTable = new ActionRemoveNode();

    /**
     * TrapMe[uViewActionNXCX^X
     * 𐶐܂B
     *
     * @param display TrapMe[uView Display
     * @param table TrapMe[u
     * @param statusLineManager Xe[^XC}l[W
     */
    public ActionBuilderTrapReceiveTable(
        final Display display, final Table table,
        final SubStatusLineManager statusLineManager) {
        logger = Logger.getLogger(this.getClass().getName());
        this.display = display;
        this.trapTable = table;
        this.statusLineManager = statusLineManager;
    }

    /**
     * TrapMJnANVNXCX^XԂ܂B
     *
     * @return startTrap TrapMJnANV
     */
    public IAction getActionStartTrap() {
        return startTrap;
    }

    /**
     * TrapM~ANVNXCX^XԂ܂B
     *
     * @return stopTrap TrapM~ANV
     */
    public IAction getActionStopTrap() {
        return stopTrap;
    }

    /**
     * TrapMX^[gANVԂ܂B
     *
     * @return restartTrap TrapMX^[gANV
     */
    public IAction getActionRestartTrap() {
        return restartTrap;
    }

    /**
     * TrapMZbgANVԂ܂B
     *
     * @return resetTrapTable TrapMZbgANV
     */
    public IAction getActionResetTrapTable() {
        return resetTrapTable;
    }

    /**
     * TrapMɊւANVNXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private abstract class AbstractTrapAction extends Action {
        /**
         * TrapMANVThread
         */
        public final void run() {
            doTask();
        }

        /**
         * TrapMANV^XN
         *
         */
        protected abstract void doTask();
    }

    /**
     * TrapMThreadNsANVNXłBB
     */
    private final class ActionStartTrapReceiveThread extends AbstractTrapAction {
        /**
         * TrapMThreadNANṼACRImageDescriptorԂ܂B
         *
         * @return TrapMThreadNANṼACRImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/trap.gif"));
        }

        /**
         * TrapMJnANVtextԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return "TrapMJn";
        }

        /**
         * TrapMJnANVToolTipTextԂ܂B
         *
         * @return ToolTipText
         *
         */
        public String getToolTipText() {
            return "TrapMJn܂";
        }

        /**
         * TrapMJns܂B
         *
         */
        protected void doTask() {
            // TrapMThread
            ThreadTrapReceive trapthread;

            TrapListenerImpl listener = TrapListenerImpl.getInstance();
            trapthread = ThreadTrapReceive.getInstance();

            Shell shell = display.getActiveShell();
            MessageBox alertMessageBox =
                new MessageBox(shell, SWT.YES | SWT.ICON_WARNING);

            /* TrapMXbhN̏ꍇɂ́AAlert\Ƀ^[ */
            if (trapthread.checkThread()) {
                alertMessageBox.setMessage("Already Trap thraed alive");
                alertMessageBox.open();
                statusLineManager.setMessage(
                    TrapReceiveTableView.TRAP_ALIVE_MESSAGE);

                return;
            }

            // TrapMXi[iTrapM̎s\bhjo^
            if (trapthread.startReceiving()) {
                trapthread.addTrapListener(listener);
            } else {
                // TrapMXbhNsɂAlert\
                logger.warning("Abort Trap start");
                alertMessageBox.setMessage("Abort Trap start");
                alertMessageBox.open();

                return;
            }

            statusLineManager.setMessage(
                TrapReceiveTableView.TRAP_ALIVE_MESSAGE);
        }
    }

    /**
     * TrapMThread~ANVNXłB
     */
    private final class ActionStopTrapReceiveThread extends AbstractTrapAction {
        /**
             * ImageDescriptorԂ܂B
             *
             * @return ImageDescriptor
             */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/trapstop.gif"));
        }

        /**
         * TrapM~ANṼj[LqԂ܂B
         *
         * @return text
         */
        public String getText() {
            return "TrapM~";
        }

        /**
         * TrapM~ANVToolTipText̕Ԃ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return "TrapM~܂";
        }

        /**
         * TrapM~ANVł
         *
         */
        protected void doTask() {
            // ^C}[~
            // display.timerExec(TIMER_STOP, timerProcessor);
            // TrapMThread
            ThreadTrapReceive trapthread;

            trapthread = ThreadTrapReceive.getInstance();

            // TrapMXi[iTrapM̎s\bhjo^
            trapthread.stopReceiving();

            statusLineManager.setMessage(
                TrapReceiveTableView.TRAP_DEAD_MESSAGE);
        }
    }

    /**
     * TrapMThreadċNANVłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     *
     */
    private final class ActionRestartTrapReceiveThread
        extends AbstractTrapAction {
        /**
         * TrapMX^[gANVpImageDescriptorԂ܂B
         *
         * @return TrapMX^[gANVpImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/traprestart.gif"));
        }

        /**
         * TextԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return "TrapMċN";
        }

        /**
         * ToolTipTextԂ܂B
         *
         * @return ToolTipText
         */
        public String getToolTipText() {
            return "TrapMċN܂";
        }

        /**
         * TrapMThreadċN܂B
         *
         */
        protected void doTask() {
            /*
             * Xe[^XCTrapMThread stopԕ\
             */
            statusLineManager.setMessage(
                TrapReceiveTableView.TRAP_DEAD_MESSAGE);

            ThreadTrapReceive trapthread;
            TrapListenerImpl listener = TrapListenerImpl.getInstance();
            trapthread = ThreadTrapReceive.getInstance();

            Shell shell = display.getActiveShell();
            MessageBox alertMessageBox =
                new MessageBox(shell, SWT.YES | SWT.ICON_WARNING);

            /*
             * TrapMXbhNłȂꍇɂ́AAlert\
             * Ƀ^[
             */
            if (!trapthread.checkThread()) {
                alertMessageBox.setMessage("Not Trap thraed alive");
                alertMessageBox.open();
                statusLineManager.setMessage(
                    TrapReceiveTableView.TRAP_ALIVE_MESSAGE);

                return;
            }

            /*
             * TrapMXi[iTrapM̎s\bhj~
             */
            trapthread.stopReceiving();

            /*
             * TrapMXi[iTrapM̎s\bhjo^
             */
            if (trapthread.startReceiving()) {
                trapthread.addTrapListener(listener);
            } else {
                // TrapMXbhNsɂAlert\
                logger.warning("Abort Trap start");
                alertMessageBox.setMessage("Abort Trap start");
                alertMessageBox.open();

                return;
            }

            /* Xe[^XCTrapMThread alive\ */
            statusLineManager.setMessage(
                TrapReceiveTableView.TRAP_ALIVE_MESSAGE);
        }
    }

    /**
     * TrapMe[uNAANV`NXłB
     *
     * @author Yoshimasa Matsumoto
     * @version 1.0
     */
    private final class ActionRemoveNode extends AbstractTrapAction {
        /**
         * TrapMe[uNAImageDescriptorԂ܂B
         *
         * @return ImageDescriptor
         */
        public ImageDescriptor getImageDescriptor() {
            return ImageDescriptor.createFromURL(
                bundle.getEntry("icons/clear.gif"));
        }

        /**
         * TextԂ܂B
         *
         * @return Text
         */
        public String getText() {
            return "Clear Trap Table";
        }

        /**
         * ToolTipTexԂ܂A
         *
         * @return ToolTipTex
         */
        public String getToolTipText() {
            return "TrapMe[uNA܂";
        }

        /**
         * TrapMe[uNA܂B
         *
         */
        protected void doTask() {
            trapTable.removeAll(); // TrapMe[uNA

            // TrapMe[utbV
            TableViewer view = NetJFWatcherApplication.getTrapTableView().getViewer();
            view.refresh();
        }
    }
}
