/*
 * Created on 2004/10/16
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager.trap;

import netjfwatcher.snmp.messageformat.SnmpTrap2PDU;
import netjfwatcher.snmp.messageformat.SnmpTrapPDU;


/**
 * TrapMXi[ƂāA
 * Snmp}l[WłTrapMs߂̃\bh`܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public interface ITrapListener {
    /**
     * SNMPV1 TrapM\bhłB
     *
     * @param trapPDU Trap PDU
     * @param sourceAddress Trap\[XAddress
     */
    void processTrap(String community, SnmpTrapPDU trapPDU, String sourceAddress);

    /**
     * SNMPV2cySNMPV3 TrapM\bhłB
     *
     * @param trap2PDU Trap2 PDU
     * @param snmpVersion SNMPo[W
     * @param sourceAddress Trap\[XAddress
     */
    void processTrapV2(
    		SnmpTrap2PDU trap2PDU, String snmpVersion, String sourceAddress);
}
