/*
 * Created on 2004/10/11
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.snmpmanager.trap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/**
 * TrapMThreadEclipseThreadԂTrapMf[^𒆌p L[ƂȂNXłB
 * 
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class TrapReceiveMessageQueue {
	/* L[郊Xg */
	private static List<ArrayList> trapQueueList;

	private static final int LIMIT = 100;

	/**
	 * TrapML[CX^X𐶐܂B
	 * 
	 */
	private TrapReceiveMessageQueue() {
		trapQueueList = Collections.synchronizedList(new LinkedList<ArrayList>());
	}

	/**
	 * TrapML[Push܂B
	 * 
	 * @param obj
	 *            TrapMi[ArrayList
	 */
	public synchronized void pushTrapData(final ArrayList obj) {

		if (trapQueueList.size() > LIMIT) {
			trapQueueList.remove(0);
			trapQueueList.add(obj);
		} else {
			trapQueueList.add(obj);
		}
	}

	/**
	 * L[TrapMPop܂B
	 * 
	 * @return obj TrapM
	 * @throws IndexOutOfBoundsException
	 */
	public synchronized ArrayList popTrapData() {
		ArrayList trapDataObj = null;

		if (trapQueueList.size() > 0) {
			trapDataObj = (ArrayList)trapQueueList.get(0);
			trapQueueList.remove(0);
		}

		return trapDataObj;
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static TrapReceiveMessageQueue getInstance() {
		return SingletonResource.TRAP_MESSAGE_QUEUE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final TrapReceiveMessageQueue TRAP_MESSAGE_QUEUE = new TrapReceiveMessageQueue();
	}
}
