/*
 * Created on 2005/02/16
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.snmptest;

import netjfwatcher.snmp.preference.SnmpPreference;


/**
 * SNMP^G[eXgp̃R[hێNXłB
 * SNMP}l[WpyуG[WFgpꂼ̋^G[R[hێ܂B
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class SnmpErrorTest {
    /* Snmp}l[Wp^G[R[h [] */
    private String managerErrorControlCode = SnmpPreference.CORRECT_DESCRIPTION;

    /* SnmpG[WFg^G[R[h [] */
    private String agentErrorControlCode = SnmpPreference.CORRECT_DESCRIPTION;

    /* SnmpG[WFg^G[|[gpR[h [] */
    private String agentErrorReportCode = SnmpPreference.CORRECT_DESCRIPTION;

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static SnmpErrorTest getInstance() {
        return SingletonResource.TEST_ERROR_INSTANCE;
    }

    /**
     * SnmpG[WFgɂ^G[R[hԂ܂B
     *
     * @return agentErrorControlCode SnmpG[WFgɂ^G[R[h
     */
    public String getAgentErrorControlCode() {
        return agentErrorControlCode;
    }

    /**
     * Snmp}l[Wɂ^G[R[hԂ܂B
     *
     * @return managerErrorControlCode Snmp}l[Wɂ^G[R[h
     */
    public String getManagerErrorControlCode() {
        return managerErrorControlCode;
    }

    /**
     * SNMPG[WFg^G[R[hZbg܂B
     * ^G[ƂẮAȉ܂B
     * EWRONG_DIGEST_DESCRIPTION
     * EDECRYPTION_ERROR_DESCRIPTION
     *
     * @param string SnmpG[WFg^G[R[h
     */
    public void setAgentErrorControlCode(String string) {
        agentErrorControlCode = string;
    }

    /**
     * SNMP}l[Wɂ^G[R[hZbg܂B
     * SNMP}l[WɂāA{R[h""łȂꍇɂ́A
     * w̃G[ԂŃG[WFgɃANZX܂B
     *
     * @param string Snmp}l[W^G[R[h
     */
    public void setManagerErrorControlCode(String string) {
        managerErrorControlCode = string;
    }

    /**
     * SnmpG[WFgɂ^G[|[gR[hԂ܂B
     *
     * @return agentErrorReportCode SnmpG[WFg^G[|[gR[h
     */
    public String getAgentErrorReportCode() {
        return agentErrorReportCode;
    }

    /**
     * SnmpG[WFgɂ^G[|[gR[hZbg܂B
     * G[|[gR[hɂ͈ȉ܂B
    * EUNSUPPORTED_SECURITY_LEVEL_DESCRIPTION
    * ENOT_IN_TIME_PACKET_DESCRIPTION
    * EUNKNOWN_USER_NAME_DESCRIPTION
    * EUNKNOWN_ENGINE_ID_DESCRIPTION
    * EWRONG_DIGEST_DESCRIPTION
    * EDECRYPTION_ERROR_DESCRIPTION
    * SNMPG[WFgŉf[^쐬ɖ{R[h""ȊȌꍇɂ́A
    * w̃G[|[g}l[WɕԂ܂B
    *
     * @param string ^G[|[gR[h
     */
    public void setAgentErrorReportCode(String string) {
        agentErrorReportCode = string;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final SnmpErrorTest TEST_ERROR_INSTANCE = new SnmpErrorTest();
    }
}
