/*
 * Created on 2005/01/25
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.socketclient;

import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.engine.view.editorpart.common.EditorInputNodeView;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/**
 * NCAg[hɂXML SocketڑɊւANVNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class ActionBuilderXMLSocket extends Action {

	/* MO */
	private static Logger logger;

	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

	private IAction xmlSocketView = new ActionXMLSocketEditorView();

	/**
	 * m[hɊւANVNXCX^X𐶐܂B
	 * 
	 */
	public ActionBuilderXMLSocket() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	/**
	 * m[h̍\`\ANVԂ܂B
	 * 
	 * @return xmlSocketView m[h̍\`\ANV
	 */
	public IAction getActionXMLSocketView() {
		return xmlSocketView;
	}

	/**
	 * m[hɊւANV`钊ۃNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	private abstract class AbstractXMLSocketAction extends Action {
		/**
		 * ANVs܂B
		 */
		public final void run() {
			doTask();
		}

		/**
		 * ANVs^XNłB
		 * 
		 */
		protected abstract void doTask();

		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/engine.gif"));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return "XML Socket connect";
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return "XML Socket connect";
		}
	}

	/**
	 * m[h̍\`\ANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	public final class ActionXMLSocketEditorView extends
			AbstractXMLSocketAction {

		/**
		 * m[h̍\`\^XNłB
		 * 
		 */
		protected void doTask() {
			IWorkbenchPage activePage = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();

			try {
				/*
				 * IꂽGg̃m[hURLEditorɃuEU I[v EditorID̓uEŨNX
				 */
				activePage.openEditor(new EditorInputNodeView(
						XMLSocketEditorView.TITLE_SUFFIX, null, false),
						XMLSocketEditorView.class.getName());
			} catch (PartInitException e) {
				logger.warning(e.getMessage());
				e.printStackTrace();
			}
		}

	}

}
