/*
 * Created on 2004/12/01
 *
 *
 * Copyright(c) 2004 Yoshimasa Matsumoto
 */
package netjfwatcher.socketclient;

import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.webbrowser.menutree.IMenuNode;
import netjfwatcher.webbrowser.menutree.NetMenuTree;
import netjfwatcher.webbrowser.menutree.NetMenuTreeGroup;
import netjfwatcher.webbrowser.menutree.NetMenuTreeViewContentProvider;
import netjfwatcher.webbrowser.menutree.NetMenuTreeViewLabelProvider;
import netjfwatcher.webbrowser.menutree.NetMenuTreeViewSorter;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.part.ViewPart;
import org.w3c.dom.Node;



/**
 * lbg[NoRNCAgm[hj[ViewNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NetworkClientNodeMenuView extends ViewPart {
    /** GarbageCollection Table\j[R[h */
    public static final int GARBAGECOLLECTION_TABLE = 0;

    /** GarbageCollection Ot\j[R[h */
    public static final int GARBAGECOLLECTION_CHART = 1;

    /* EditorsPartANVBuilder */
    private static ActionBuilderEditorsPartClose actionBuilder =
        new ActionBuilderEditorsPartClose();

    private static ActionBuilderXMLSocket xmlSocketAction = new ActionBuilderXMLSocket();
    
    /* TreeViewer */
    private static TreeViewer menuTreeViewer;

    /**
     * lbg[NĎj[View̃CX^X𐶐܂B
     *
     */
    public NetworkClientNodeMenuView() {
        // nothing
    }

    /**
     * ActionBuilderԂ܂B
     *
     * @return actionBuilder ActionBuilder
     */
    public ActionBuilderEditorsPartClose getActionBuilder() {
        return actionBuilder;
    }

    /**
     * tH[JXZbgꂽꍇ̏łB
     */
    public void setFocus() {
    }

    /**
     * TreeViewerԂ܂B
     *
     * @return menuTreeViewer TreeViewer
     */
    public TreeViewer getViewer() {
        return menuTreeViewer;
    }

    /**
     * r[ꂽƂɂ܂sꃁ\bhłB
     *
     * @param parent@Composite
     */
    public void createPartControl(Composite parent) {
        /* TreeViewerEZbg */
        menuTreeViewer = new TreeViewer(parent);
        menuTreeViewer.setUseHashlookup(true);
        menuTreeViewer.setContentProvider(new NetMenuTreeViewContentProvider());
        menuTreeViewer.setLabelProvider(new NetMenuTreeViewLabelProvider());

        /* \[^[Zbg */
        menuTreeViewer.setSorter(new NetMenuTreeViewSorter());

        /* Viewerɓ̓f[^ݒ  */
        menuTreeViewer.setInput(createInitialInput());
        menuTreeViewer.expandAll();

        /* Contextj[Zbg */
        createContextMenu();

        /* ANVZbg */
        initActions();

        createNetworkMenuTree();

        /* Nodej[ View̃Xi[ݒ */
        setupNodeMenuViewListener();
    }

    /**
     * Nodej[View̃Xi[o^s܂B
     * Xi[Tree\j[Click̏łB
     *
     */
    private void setupNodeMenuViewListener() {
        /*
         * j[Tree ViewɃXi[o^
         * iTree\j[Click̏j
         */
        menuTreeViewer.addSelectionChangedListener(
            new NetworkClientMenuTreeListener());
    }

    /**
     * ViewerݒpIuWFNg𐶐ĕԂ܂B
     *
     *  @return rootOfRoot Object
     */
    private Object createInitialInput() {
        NetMenuTreeGroup rootOfRoot = new RootOfRootMenuGroup();

        return rootOfRoot;
    }

    /**
     * ContextMenuZbg܂B
     * preWindowOpenɌĂ΂܂B
     *
     * @param manager IMenuManager
     */
    protected void fillContextMenu(IMenuManager manager) {
        manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
        manager.add(getActionBuilder().actionCloseAllEditors());
        manager.add(xmlSocketAction.getActionXMLSocketView());
    }

    /**
     * ContextMenu𐶐܂B
     *
     */
    private void createContextMenu() {
        /* j[}l[W */
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);

        /* j[Xi[Zbg */
        menuManager.addMenuListener(
            new IMenuListener() {
                /**
                 * j[Xi[łB
                 *
                 * @param manager IMenuManager
                 */
                public void menuAboutToShow(IMenuManager manager) {
                    fillContextMenu(manager);
                }
            });

        /* j[Zbg */
        Menu menu = menuManager.createContextMenu(menuTreeViewer.getControl());
        menuTreeViewer.getControl().setMenu(menu);
        getSite().registerContextMenu(menuManager, menuTreeViewer);
    }

    /**
     * ANV̏s܂B
     *
     */
    private void initActions() {
        /* ToolBarManagerZbg */
        IToolBarManager toolBarManager =
            getViewSite().getActionBars().getToolBarManager();

        toolBarManager.add(xmlSocketAction.getActionXMLSocketView());
        // Editor Pats closeANV
        toolBarManager.add(getActionBuilder().actionCloseAllEditors());
    }

    /**
     * lbg[NĎj[𐶐܂B
     *
     */
    public void createNetworkMenuTree() {
        /* ViewerݒŐݒ肳ꂽViewer̓f[^擾  */
        IMenuNode menuNode = (IMenuNode) getViewer().getInput();
        NetMenuTreeGroup baseMenuGroup = menuNode.getParent();

        if (menuNode instanceof NetMenuTreeGroup) {
            baseMenuGroup = (NetMenuTreeGroup) menuNode;
        }

        NetMenuTreeGroup garbageCollectionGroup =
            baseMenuGroup.addGroup(new NetMenuTreeGroup("GarbageCollection"));

        garbageCollectionGroup.addChild(
            new NetMenuTree("GarbageCollection Table", GARBAGECOLLECTION_TABLE));

        menuTreeViewer.expandAll();
        menuTreeViewer.refresh();
    }

    /**
    * u{́vŏʃO[vBgetParentnullԂAr[ɂ͌ȂỹO[vB
    * <p>
    */
    private static final class RootOfRootMenuGroup extends NetMenuTreeGroup {
        RootOfRootMenuGroup() {
            super("RootOfRoot");
        }

        /**
         * em[hԂ܂B
         *
         * @return em[h
         */
        public NetMenuTreeGroup getParent() {
            return null;
        }

        /**
         * qm[h폜܂B
         *
         * @param toRemove Node
         */
        public void removeChild(Node toRemove) {
            // ROOT O[vƍB
        }
    }
}
