/*
 * Created on 2005/04/15
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.webbrowser.menutree;

import java.util.logging.Logger;

import netjfwatcher.webbrowser.model.UrlEditorInput;
import netjfwatcher.webbrowser.view.BrowserEditors;
import netjfwatcher.webbrowser.view.BrowserEditorsManager;

import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;



/**
 * j[Tree Clickł̃Xi[NXłB
 *
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class NetMenuTreeListener extends AbstractMenuTreeListener {
    /* IWorkbenchPage */
    private static IWorkbenchPage activePage;

    /* MO */
    private static Logger logger = null;

    /**
     * e[uViewɃtB[hꗗőIGg͒l
     * Đݒ肵ÃCxg_@ƂWebɃANZX܂B
     *
     * @param event SelectionChangedEvent
     */
    public void selectionChanged(SelectionChangedEvent event) {
        logger = Logger.getLogger(this.getClass().getName());

        // Iꂽ񒊏o
        StructuredSelection ss = (StructuredSelection) event.getSelection();

        /* Iꂽm[hGg擾
         * Ggɂ́Aȉ̂Q̏񂪃ZbgĂ
         * Em[h
         * EURL
         */
        final NetMenuTree entry = (NetMenuTree) ss.getFirstElement();
        logger.info("Name : " + entry.getName());
        logger.info("Url : " + entry.getUrl());

        /*
         * UAActivePage擾AuEUOpenɌpageN[Y
         */
        activePage =
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();

        IEditorPart editorPart =
            BrowserEditorsManager.getInstance().getBrowserEditors(
                entry.getUrl());

        if (editorPart != null) {
            BrowserEditorsManager.getInstance().removetBrowserEditors(
                entry.getUrl());
            activePage.closeEditor(editorPart, false);
        }

        /*
         * IꂽGg̃m[hURLEditorɃuEU
         * I[v
         * EditorID̓uEŨNX
         */
        BusyIndicator.showWhile(
            PlatformUI.getWorkbench().getDisplay(),
            new Runnable() {
                public void run() {
                    try {
                        IEditorPart editorPart =
                            activePage.openEditor(
                                new UrlEditorInput(
                                    entry.getName(), entry.getUrl()),
                                BrowserEditors.class.getName());

                        BrowserEditorsManager.getInstance().setBrowserEditors(
                            entry.getUrl(), editorPart);
                    } catch (PartInitException e) {
                        logger.warning("Menu open error : " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            });
    }
}
