/*
 * Created on 2005/04/14
 *
 *
 * Copyright(c) 2005 Yoshimasa Matsumoto
 */
package netjfwatcher.webbrowser.nodetree;

import java.util.ArrayList;
import java.util.logging.Logger;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import netjfwatcher.engine.common.model.NodeInformationXMLTag;
import netjfwatcher.webbrowser.model.DocumentParseErrorHandler;
import netjfwatcher.webbrowser.preferences.HttpAccessPreference;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;


/**
 * HttpT[om[hXML[hAm[hm[hTree
 * r[ɔf郁\bhNXłB
 *
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public final class NodeListXmlParse {
    /*
     * m[hĎzɊi[邽߂̔z̃|WV
     */

    /** m[hʒu */
    public static final int NODENAME_NUMBER = 0;

    /** m[hIPAhXʒu */
    public static final int IPADDRESS_NUMBER = 1;

    /** m[hO[vʒu */
    public static final int GROUP_NUMBER = 2;

    /** GWAhXʒu */
    public static final int ENGINE_ADDRESS_NUMBER = 3;

    /** m[hIcon XWʒu */
    public static final int NODE_X_NUMBER = 4;

    /** m[hIcon YWʒu */
    public static final int NODE_Y_NUMBER = 5;

    /** m[hʈʒu */
    public static final int NODEKIND_NUMBER = 6;

    /** PingĎʒu */
    public static final int PING_PERIOD_NUMBER = 7;

    /** PingĎ臒lʒu */
    public static final int PING_THRESHHOLD_NUMBER = 8;

    /** SNMPo[Wʒu */
    public static final int SNMP_VERSION_NUMBER = 9;

    /** SNMPĎxʒu */
    public static final int SNMP_LEVEL_NUMBER = 10;

    /** SNMPĎʒu */
    public static final int SNMP_PERIOD_NUMBER = 11;

    /** SNMP ReadR~jeBʒu */
    public static final int SNMP_ROCOMMUNITY_NUMBER = 12;

    /** SNMP WriteR~jeBʒu */
    public static final int SNMP_RWCOMMUNITY_NUMBER = 13;

    /** SNMP^CAEglʒu */
    public static final int SNMP_TIMEOUT_NUMBER = 14;

    /** m[hĎ^OiXMLt@CGNX|[g/C|[gpjLqz */
    public static final String[] NODE_INFO_DESCRIBE_ARRAY =
        {
            NodeInformationXMLTag.NODENAME, NodeInformationXMLTag.IPADDRESS,
            NodeInformationXMLTag.GROUP, NodeInformationXMLTag.ENGINE_ADDRESS,
            NodeInformationXMLTag.NODE_X, NodeInformationXMLTag.NODE_Y,
            NodeInformationXMLTag.NODEKIND, NodeInformationXMLTag.PING_PERIOD,
            NodeInformationXMLTag.PING_THRESHHOLD,
            NodeInformationXMLTag.SNMP_VERSION, NodeInformationXMLTag.SNMP_LEVEL,
            NodeInformationXMLTag.SNMP_PERIOD,
            NodeInformationXMLTag.SNMP_ROCOMMUNITY,
            NodeInformationXMLTag.SNMP_RWCOMMUNITY,
            NodeInformationXMLTag.SNMP_TIMEOUT
        };

    /**  */
    public static final int BUFF_SIZE = 512 * 1000;

    /**  */
    public static final int NODE_MAX = 500;

    /**  */
    public static final int NODE_LINK_MAX = 500;

    /* MO */
    private static Logger logger = null;

    /*
     *
     */
    private NodeListXmlParse() {
        logger = Logger.getLogger(this.getClass().getName());
    }

    /**
     * WebXMLm[hC|[g͌ʂm[hTree
     * r[ɔf܂B
     *
     * @return nodeInfoList m[hĎ񃊃Xg
     */
    public ArrayList loadAndParseNodeList() {
        ArrayList nodeInfoList = null;

        /* XMLt@C͗p */
        Document dom = null;
        DocumentBuilderFactory dbfactory = null;
        DocumentBuilder builder = null;

        /* XMLt@Ć@*/
        try {
            /* DOMp[Tpt@Ng̐ */
            dbfactory = DocumentBuilderFactory.newInstance();

            /* Ó؂s */
            dbfactory.setValidating(true);

            /* DOM DocumentCX^Xpt@Ng̐ */
            builder = dbfactory.newDocumentBuilder();

            /* G[nh̓o^ */
            builder.setErrorHandler(new DocumentParseErrorHandler());

            /* vtFXANZXURL擾 */
            // HttpAccessPreference pref = new HttpAccessPreference();
            /* XMLt@C */
            dom = builder.parse(
                    HttpAccessPreference.getInstance().getNodeListImportUrl());
        } catch (Exception e) {
            /* ȉ̗Ocatch
             * EDocumentBuilderŗO
             * iParserConfigurationExceptionj
             * EXMLt@C͂ō\̓G[iSAXExceptionj
             * EXMLt@C͂œo̓G[iIOExceptionj
             */
            logger.warning(e.getMessage());
        }

        if (dom != null) {
            /* m[hDocument */
            Element root = dom.getDocumentElement();
            Node firstChildNode = root.getFirstChild();

            /* XMLt@C͂ăm[h擾
             */
            nodeInfoList = this.parseNode(firstChildNode);

            /*
             * XMLt@C͂ăN擾
             */

            // this.parseLink(firstChildNode);
        }

        return nodeInfoList;
    }

    /**
     * m[hXML͂āAm[h񃊃XgԂ܂B
     * m[hXMLɂ́Am[hIPAhXAm[hAm[hĎȂǂ܂܂A
     * m[hNODE_INFO_DESCRIBE_ARRAY`̕zɊi[AXg\ĕԂ܂B
     *
     *
     * @param firstChildNode rootNode
     * @return m[hi[ArrayList
     */
    private ArrayList parseNode(final Node firstChildNode) {
        Node childNode = firstChildNode;

        // XMLNODE_INFO_ROOT_TAG = "Node"Fm[hĎ^O܂Ō
        while (childNode != null) {
            try {
                if (
                    (childNode != null)
                        && (childNode.getNodeType() == Node.ELEMENT_NODE)) {
                    if (
                        childNode.getNodeName().equals(
                                NodeInformationXMLTag.NODE_INFO_ROOT_TAG)) {
                        // XMLNODE_INFO_ROOT_TAG = "Node"Fm[hĎ^Obreak
                        childNode = childNode.getFirstChild();

                        break;
                    }
                }

                childNode = childNode.getNextSibling();
            } catch (Exception e) {
                logger.info(e.getMessage());
                e.printStackTrace();
            }
        }

        // m[hi[郊Xg
        ArrayList nodeList = new ArrayList();

        while (childNode != null) {
            try {
                /* X̃m[hĎ^ONODE_INFO_TAG = "Node_Property"o
                 * m[hĎ𒊏oĔzɊi[AzXgɒǉ
                 *
                 */
                if (
                    (childNode != null)
                        && (childNode.getNodeType() == Node.ELEMENT_NODE)) {
                    if (
                        childNode.getNodeName().equals(
                                NodeInformationXMLTag.NODE_INFO_TAG)) {
                        Node nodeInfoChildNodeLeaf = childNode.getFirstChild();

                        // Lȃm[hĎ񌟍tO
                        boolean hit = false;
                        String[] nodeInfo =
                            new String[NODE_INFO_DESCRIBE_ARRAY.length];

                        while (nodeInfoChildNodeLeaf != null) {
                            if (
                                nodeInfoChildNodeLeaf.getNodeType() == Node.ELEMENT_NODE) {
                                // Node TypeElementł΁ANodeĎ񑮐ƈv邩`FbN
                                for (
                                    int i = 0;
                                        i < NODE_INFO_DESCRIBE_ARRAY.length;
                                        i++) {
                                    // NodeĎ񑮐ƈvAElement TypełΒlzɊi[
                                    if (
                                        nodeInfoChildNodeLeaf.getNodeName()
                                                                 .equals(
                                                NODE_INFO_DESCRIBE_ARRAY[i])) {
                                        Node firstNodeText = null;
                                        String leafItemValue = null;

                                        if (nodeInfoChildNodeLeaf != null) {
                                            firstNodeText =
                                                nodeInfoChildNodeLeaf
                                                .getFirstChild();

                                            if (firstNodeText != null) {
                                                leafItemValue =
                                                    firstNodeText.getNodeValue();
                                            }
                                        }

                                        // id=m[h̘AԁAi=m[hĎԍ
                                        nodeInfo[i] = leafItemValue;
                                        hit = true;

                                        break;
                                    }
                                }
                            }

                            nodeInfoChildNodeLeaf =
                                nodeInfoChildNodeLeaf.getNextSibling();
                        }

                        if (hit) {
                            nodeList.add(nodeInfo);
                        }
                    }

                    childNode = childNode.getNextSibling();
                }

                childNode = childNode.getNextSibling();
            } catch (DOMException e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            } catch (Exception e) {
                logger.warning(e.getMessage());
                e.printStackTrace();
            }
        }

        // o^m[hIPAhXo

        /* for (int j = 0; j < nodeList.size(); j++) {
            for (int l = 0; l < NODE_INFO_DESCRIBE_ARRAY.length; l++) {
                System.out.println(
                    j + " : " + NODE_INFO_DESCRIBE_ARRAY[l] + " : "
                    + ((String[]) nodeList.get(j))[l]);

            }
        } */
        return nodeList;
    }

    /**
     * NXML͂ăXgƂĕԂ܂B
     *
     * @param firstChildNode rootNode
     * @return Ni[ArrayList
     */
    private ArrayList parseLink(final Node firstChildNode) {
        ArrayList linkList = new ArrayList();

        String[] nodeLinkInfo = null;
        Node childNode = firstChildNode;

        while (childNode != null) {
            if (
                (childNode != null)
                    && (childNode.getNodeType() == Node.ELEMENT_NODE)) {
                // m[hN^O
                if (
                    childNode.getNodeName().equals(
                            NodeInformationXMLTag.LIN_INFO_ROOT_TAG)) {
                    childNode = childNode.getFirstChild();

                    break;
                }
            }

            childNode = childNode.getNextSibling();
        }

        while (childNode != null) {
            // Node Info TAG
            if (
                (childNode != null)
                    && (childNode.getNodeType() == Node.ELEMENT_NODE)) {
                if (
                    childNode.getNodeName().equals(
                            NodeInformationXMLTag.LIN_INFO_TAG)) {
                    Node nodeInfoChildNodeLeaf = childNode.getFirstChild();

                    boolean hit = false;
                    nodeLinkInfo = new String[2];

                    while (nodeInfoChildNodeLeaf != null) {
                        if (
                            nodeInfoChildNodeLeaf.getNodeType() == Node.ELEMENT_NODE) {
                            // Node TypeElementł΁ANodeNLqƈv邩`FbN
                            if (
                                nodeInfoChildNodeLeaf.getNodeName().equals(
                                        NodeInformationXMLTag.LINK_X)) {
                                // NodeNLqƈvAElement TypełΒlzɊi[
                                Node firstNodeText =
                                    nodeInfoChildNodeLeaf.getFirstChild();
                                String leafItemValue =
                                    firstNodeText.getNodeValue();
                                nodeLinkInfo[0] = leafItemValue;
                                hit = true;

                                // System.out.println(
                                //    "Link Node X : " + leafItemValue);
                            }

                            if (
                                nodeInfoChildNodeLeaf.getNodeName().equals(
                                        NodeInformationXMLTag.LINK_Y)) {
                                // NodeNLqƈvAElement TypełΒlzɊi[
                                Node firstNodeText =
                                    nodeInfoChildNodeLeaf.getFirstChild();
                                String leafItemValue =
                                    firstNodeText.getNodeValue();
                                nodeLinkInfo[1] = leafItemValue;
                                hit = true;

                                // System.out.println(
                                //    "Link Node Y : " + leafItemValue);
                            }
                        }

                        nodeInfoChildNodeLeaf =
                            nodeInfoChildNodeLeaf.getNextSibling();
                    }

                    if (hit) {
                        linkList.add(nodeLinkInfo);
                    }
                }

                childNode = childNode.getNextSibling();
            }

            childNode = childNode.getNextSibling();
        }

        return linkList;
    }

    /**
     * ̃NX̃CX^XԂ܂B<BR>
     * iNXێĂVOgEIuWFNg
     * Ԃ܂j<BR>
     *
     * @return VOgEIuWFNgƂĂ̂̃NX
     * CX^X
     */
    public static NodeListXmlParse getInstance() {
        return SingletonResource.RESOURCE;
    }

    /**
     * VOgEIuWFNgێNXłB<BR>
     *
     */
    private static class SingletonResource {
        static final NodeListXmlParse RESOURCE = new NodeListXmlParse();
    }
}
