/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.gui.action;

import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.webalizer.model.AccessLogFileParse;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Table;
import org.osgi.framework.Bundle;

public class ActionBuilderAccessLogTable {
	/* MO */
	private static Logger logger;

	private final Table instanceTable;

	private final IAction clearTableAction = new ActionTableClear();

	private final IAction analysisAction = new ActionAnalysisTable();

	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

	public ActionBuilderAccessLogTable(Table table) {
		this.instanceTable = table;
		logger = Logger.getLogger(this.getClass().getName());
	}

	public IAction actionClearTable() {
		return clearTableAction;
	}

	public IAction actionAnalysis() {
		return analysisAction;
	}

	/**
	 * OIDe[u(G[WFg̎f[^)ANV` ۃNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	private abstract class AbstractNodeAction extends Action {
		/*
		 * (non-Javadoc)
		 * 
		 * @see org.eclipse.jface.action.IAction#run()
		 */
		public final void run() {
			doTask();
		}

		/**
		 * ANVŎׂ\bhŃANVŌĂ΂܂B
		 * 
		 */
		protected abstract void doTask();
	}

	private final class ActionTableClear extends AbstractNodeAction {
		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/clear.gif"));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return "Table Clear";
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return "Table Clear";
		}

		/**
		 * TableNA܂B
		 * 
		 */
		protected void doTask() {
			/* e[ȗSč폜ătbV */
			instanceTable.removeAll();

		}

	}

	private final class ActionAnalysisTable extends AbstractNodeAction {
		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/configs.gif"));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return "Analysys";
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return "Analysys";
		}

		/**
		 * TableNA܂B
		 * 
		 */
		protected void doTask() {
			/* e[ȗSč폜ătbV */
			instanceTable.removeAll();
			AccessLogFileParse.getInstance().parseDirFile();
		}

	}
}
