/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.gui.action;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import netjfwatcher.application.NetJFWatcherPlugin;
import netjfwatcher.common.view.MenuPreference;
import netjfwatcher.webalizer.gui.treenode.ILogTreeNode;
import netjfwatcher.webalizer.gui.treenode.LogNodeTree;
import netjfwatcher.webalizer.gui.treenode.LogNodeTreeGroup;
import netjfwatcher.webalizer.gui.treeview.AbstractLogTreeView;
import netjfwatcher.webalizer.gui.treeview.LogTreeViewSorter;
import netjfwatcher.webalizer.model.AccessLogFileParse;
import netjfwatcher.webalizer.preference.WebalizerPreference;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class ActionBuilderLogNodeTree extends Action {
	/* MO */
	private static Logger logger = null;

	/*
	 * m[hIcon ImageIcon image filekeyƂĕێ (Icon imageQdɐ邱Ɩh~ƂƂɁA
	 * finalize()ImagejꍇɎgp)
	 */
	private HashMap nodeIconImageMap = new HashMap();

	/* TreeViewer */
	private TreeViewer nodeListTreeViewer;

	/* Xe[^XC}l[W擾pView */
	private AbstractLogTreeView nodeTreeView;

	/* Xe[^XC}l[W */
	private SubStatusLineManager statusLineManager;

	/* Composite */
	private Composite parentComposite;

	/* NodeTreeGroup */
	private LogNodeTreeGroup nodeTreeGroupRoot;

	private Image fileObjImage;

	/*
	 * GroupǗMapGroupɑ݂Ă邩AVK Group쐬邩̔fɎgp
	 */
	private HashMap groupMap = new HashMap();

	/* 摜肷邽߂PluginResource bundle */
	private final Bundle bundle = NetJFWatcherPlugin.getInstance().getBundle();

	private IAction reloadLogNodeTree = new ActionReloadLogNodeTree();

	private IAction sortLogNodeTree = new ActionSortLogNodeTree();

	private IAction logFileView = new ActionLogFileView();

	private IAction logFileRemove = new ActionLogFileRemove();

	/**
	 * m[hTree ViewɂANVNXCX^X 𐶐܂B
	 * 
	 */
	public ActionBuilderLogNodeTree() {
		logger = Logger.getLogger(this.getClass().getName());
		createNodeIconImage();
	}

	public ActionBuilderLogNodeTree(AbstractLogTreeView nodeTreeView,
			TreeViewer nodeListTreeViewer, Composite parentComposite,
			LogNodeTreeGroup nodeTreeGroupRoot) {
		logger = Logger.getLogger(this.getClass().getName());
		this.nodeTreeView = nodeTreeView;
		this.nodeListTreeViewer = nodeListTreeViewer;
		this.parentComposite = parentComposite;
		this.nodeTreeGroupRoot = nodeTreeGroupRoot;
		createNodeIconImage();
	}

	/**
	 * TreeViewerԂ܂B
	 * 
	 * @return nodeListTreeViewer TreeViewer
	 */
	public TreeViewer getViewer() {
		return nodeListTreeViewer;
	}

	/**
	 * m[hTreeǂݍ݃ANVԂ܂B
	 * 
	 * @return reloadNodeTree m[hTreeǂݍ݃ANV
	 */
	public IAction actionReloadLogNodeTree() {
		return reloadLogNodeTree;
	}

	/**
	 * m[hTree\[gANVԂ܂B
	 * 
	 * @return sortNodeTreeDatabase m[hTree\[gANV
	 */
	public IAction actionSortLogNodeTree() {
		return sortLogNodeTree;
	}

	public IAction actionLogFileView() {
		return logFileView;
	}

	public IAction actionLogFileRemove() {
		return logFileRemove;
	}

	public void createLogNodeTree(final boolean isSortDirectionTreeView) {

		File fleDir = new File(WebalizerPreference.WEBALIZER_LOG_DIR);
		File[] fileList = fleDir.listFiles();
		if (fileList != null) {
			/* 擾GroupVȖȌꍇGroupVK쐬 */
			LogNodeTreeGroup nodetreeGroup = null;
			String group = WebalizerPreference.WEBALIZER_LOG_DIR;

			/* 擾GroupVȖȌꍇGroupVK쐬 */
			nodetreeGroup = new LogNodeTreeGroup(group);
			/* m[hTree RootGroupǉ */
			nodeTreeGroupRoot.addChild(nodetreeGroup);

			for (int fileCount = 0; fileCount < fileList.length; fileCount++) {

				if (fileList[fileCount].isFile()) {

					nodetreeGroup.addChild(new LogNodeTree(fileList[fileCount]
							.getName(), fileList[fileCount].getName(),
							fileList[fileCount], fileObjImage));
				}

			}
			setStatusLine(fileList.length);
		}

		/* TreeView\[g */
		nodeListTreeViewer.setSorter(new LogTreeViewSorter() {

			public int compare(Viewer viewer, Object e1, Object e2) {

				int cat1 = category(e1);
				int cat2 = category(e2);
				if (cat1 != cat2) {
					return cat1 - cat2;
				}

				// cat1 == cat2
				String name1;
				String name2;

				if ((viewer == null) || !(viewer instanceof ContentViewer)) {
					name1 = e1.toString();
					name2 = e2.toString();
				} else {
					IBaseLabelProvider prov = ((ContentViewer) viewer)
							.getLabelProvider();

					if (prov instanceof ILabelProvider) {
						ILabelProvider lprov = (ILabelProvider) prov;
						name1 = lprov.getText(e1);
						name2 = lprov.getText(e2);
					} else {
						name1 = e1.toString();
						name2 = e2.toString();
					}
				}

				if (name1 == null) {
					name1 = ""; //$NON-NLS-1$
				}

				if (name2 == null) {
					name2 = ""; //$NON-NLS-1$
				}

				if (isSortDirectionTreeView) {
					// \[g
					return collator.compare(name1, name2);
				}

				// ~\[g
				return collator.compare(name2, name1);
			}
		});

		nodeListTreeViewer.expandAll();
		nodeListTreeViewer.refresh();
	}

	private void setStatusLine(int nodeCount) {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (nodeTreeView.getViewSite()
				.getActionBars().getStatusLineManager());

		statusLineManager.setVisible(true);
		statusLineManager.setMessage("Log Tree Count=" + nodeCount);
	}

	/**
	 * m[hTreȇIm[hԂ܂B
	 * 
	 * @return node m[h
	 */
	public ILogTreeNode getNodeBase() {
		// TreeIm[ho
		IStructuredSelection selectElement = (IStructuredSelection) getViewer()
				.getSelection();
		ILogTreeNode node = (ILogTreeNode) selectElement.getFirstElement();

		if (node == null) {
			node = (ILogTreeNode) getViewer().getInput();
		}

		return node;
	}

	/**
	 * m[hO[vԂ܂B
	 * 
	 * @param node
	 *            m[h
	 * @return baseNodeGroup m[hO[v
	 */
	public LogNodeTreeGroup setNodeGroupBase(ILogTreeNode node) {
		LogNodeTreeGroup baseNodeGroup = null;

		if (node != null) {
			baseNodeGroup = node.getParent();
		}

		if (node instanceof LogNodeTreeGroup) {
			baseNodeGroup = (LogNodeTreeGroup) node;
		}

		return baseNodeGroup;
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		/* m[hIcon imagej */
		Map list = nodeIconImageMap;
		Iterator it = null;

		for (it = list.keySet().iterator(); it.hasNext();) {
			String key = (String) it.next();
			Image nodeIconImage = (Image) list.get(key);

			if (nodeIconImage != null) {
				nodeIconImage.dispose();
			}
		}
	}

	/**
	 * ANV`钊ۃNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected abstract class AbstractLogNodeAction extends Action {
		/**
		 * ANVs܂B
		 */
		public final void run() {
			LogNodeTreeGroup baseNodeGroup = null;

			ILogTreeNode node = getNodeBase();
			baseNodeGroup = setNodeGroupBase(node);

			doTask(baseNodeGroup, node);
		}

		/**
		 * ANVs^XNłB
		 * 
		 * @param group
		 *            m[hO[v
		 * @param node
		 *            m[h
		 */
		protected abstract void doTask(LogNodeTreeGroup group, ILogTreeNode node);

		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/reload.gif"));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return "Node Tree reload";
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return "Node Tree reload";
		}
	}

	public final class ActionReloadLogNodeTree extends AbstractLogNodeAction {

		protected void doTask(LogNodeTreeGroup group, ILogTreeNode node) {
			nodeTreeGroupRoot.removeChildAll();
			groupMap.clear();
			setNodeTree();
		}

		public void setNodeTree() {
			createLogNodeTree(true);
		}
	}

	/**
	 * m[h\[gANV`钊ۃNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected abstract class AbstractLogNodeSortAction extends
			AbstractLogNodeAction {
		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry(MenuPreference.NODE_TREE_SORT_IMAGE_FILE));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return MenuPreference.NODE_TREE_SORT;
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return MenuPreference.NODE_TREE_SORT_TOOL_TIP;
		}
	}

	/**
	 * m[hTree\[gANVNXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected final class ActionSortLogNodeTree extends
			AbstractLogNodeSortAction {

		private boolean isSortToggle = true;

		/**
		 * Node TreeSort^XNłB
		 * 
		 * @param group
		 *            m[hO[v
		 * @param node
		 *            m[h
		 */
		protected void doTask(LogNodeTreeGroup group, ILogTreeNode node) {
			if (isSortToggle) {

				isSortToggle = false;
			} else {

				isSortToggle = true;
			}

			/*
			 * ێĂm[hTreeO[vXgUNA 邽߂ɃO[vǂݏoAz̎q
			 * m[h폜Ƀm[hTreeO[vXgN A
			 * 
			 */
			Iterator it = null;

			for (it = groupMap.keySet().iterator(); it.hasNext();) {
				String groupName = (String) it.next();
				LogNodeTreeGroup nodeTreeGroup = (LogNodeTreeGroup) groupMap
						.get(groupName);

				if (nodeTreeGroup != null) {
					LogNodeTreeGroup parentNodeTreeGroup = nodeTreeGroup
							.getParent();

					if (node instanceof LogNodeTreeGroup) {
						parentNodeTreeGroup = (LogNodeTreeGroup) node;
					}

					/* O[vz̃m[h폜 */
					parentNodeTreeGroup.removeChildAll();
				}
			}

			nodeTreeGroupRoot.removeChildAll();
			groupMap.clear();
			setNodeTree();
		}

		/**
		 * Node TreeZbg܂B
		 * 
		 */
		protected void setNodeTree() {

			createLogNodeTree(isSortToggle);

		}
	}

	private void createNodeIconImage() {

		String sshNodeFileImageName = "icons/file_obj.gif";
		fileObjImage = null;

		Display display = parentComposite.getDisplay();

		URL url = null;
		url = bundle.getEntry(sshNodeFileImageName);
		if (url == null) {
			/* Icon\[Xt@CȂꍇMO̎ */
			logger.severe("Not found icon file : " + sshNodeFileImageName);
		} else {
			try {
				/* m[hIconC[W */
				fileObjImage = new Image(display, url.openStream());

			} catch (IOException e) {
				logger.warning("Abort create image " + e.getMessage() + " for "
						+ sshNodeFileImageName);
				e.printStackTrace();
			}
		}

	}

	public final class ActionLogFileView extends AbstractLogNodeAction {
		private ILogTreeNode logNodeTree;

		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/file_obj.gif"));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return "No Filter/Plain Log View";
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return "No Filter/Plain Log View";
		}

		protected void doTask(LogNodeTreeGroup group, ILogTreeNode node) {

			showLogFile();
		}

		public void showLogFile() {

			if (logNodeTree instanceof LogNodeTree) {
				AccessLogFileParse.getInstance().resetLogControlData();
				try {
					AccessLogFileParse.getInstance().parseLogFilr(false,
							logNodeTree.getFile(), logNodeTree.getName());
					AccessLogFileParse.getInstance().setAccesslogInfo();
				} catch (Exception e) {
					e.printStackTrace();
					logger.warning("Abort log file view "
							+ logNodeTree.getName() + " : " + e.getMessage());
				}
			}

		}

		public void setLogNodeTree(ILogTreeNode sshNodeTree) {
			this.logNodeTree = sshNodeTree;
		}
	}

	public final class ActionLogFileRemove extends AbstractLogNodeAction {

		private ILogTreeNode logNodeTree;

		/**
		 * ImageDescriptorԂ܂B
		 * 
		 * @return ImageDescriptor
		 */
		public ImageDescriptor getImageDescriptor() {
			return ImageDescriptor.createFromURL(bundle
					.getEntry("icons/remove_exc.gif"));
		}

		/**
		 * TextԂ܂B
		 * 
		 * @return Text
		 */
		public String getText() {
			return "Log File Remove";
		}

		/**
		 * ToolTipTextԂ܂B
		 * 
		 * @return ToolTipText
		 */
		public String getToolTipText() {
			return "Log File Remove";
		}

		protected void doTask(LogNodeTreeGroup group, ILogTreeNode node) {

			if (logNodeTree instanceof LogNodeTree) {
				Shell shell = new Shell();
				if (MessageDialog.openQuestion(shell, "Confirm", "Remove "
						+ logNodeTree.getName() + " ?")) {

					if (logNodeTree.getFile().delete()) {
						logger.info("Success Remove " + logNodeTree.getName());
					} else {
						logger.info("Abort Remove " + logNodeTree.getName());
					}
					reloadLogNodeTree.run();

				}
				if (shell != null) {
					shell.dispose();
				}
			}
		}

		public void setLogNodeTree(ILogTreeNode logNodeTree) {
			this.logNodeTree = logNodeTree;
		}
	}
}
