/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.gui.filtersearch;

import java.util.Calendar;
import java.util.Date;

import netjfwatcher.common.view.CalendarComposite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

/**
 * J_[ViewNXłB
 * 
 * @author Yoshimasa Matsumoto
 * @version 1.0
 */
public class CalendarView extends ViewPart {

	/* eLXg */
	private static final int TEXT_WIDTH = 80;

	private static final int HORIZONTALSPAN6 = 6;

	private static final int HORIZONTALSPAN3 = 3;

	private String startDateString;

	private String fileNameStartDateString;

	private String endDateString;

	private String fileNameEndDateString;

	private int limit;

	private Button setButton;

	private Button resetButton;

	private Button domainButton;

	/* Filter limitl */
	private Text limitText;

	/* Filter JnN */
	private Text logStartYearText;

	/* Filter Jn */
	private Text logStartMonthText;

	/* Filter Jn */
	private Text logStartDateText;

	/* Filter IN */
	private Text logEndYearText;

	/* Filter I */
	private Text logEndMonthText;

	/* Filter I */
	private Text logEndDateText;

	private Combo startHourCombo;

	private Combo startMinuteCombo;

	private Combo endHourCombo;

	private Combo endMinuteCombo;

	private CalendarComposite calendarComposite;

	public CalendarView() {

	}

	/**
	 * tH[JXZbgꂽ̏łB
	 */
	public void setFocus() {
	}

	/**
	 * Calendar Composite𐶐ViewɃZbg܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {

		GridData gridData = null;

		GridLayout gridLayout0 = new GridLayout(1, false);
		Composite composite0 = new Composite(parent, SWT.LEFT);
		composite0.setLayout(gridLayout0);
		composite0.setLayoutData(new GridData());

		GridLayout gridLayout = new GridLayout(4, false);
		Composite composite1 = new Composite(composite0, SWT.LEFT);
		composite1.setLayout(gridLayout);
		composite1.setLayoutData(new GridData());

		setButton = new Button(composite1, SWT.NONE);
		setButton.setText(" Set ");
		setButton.setLayoutData(new GridData());

		resetButton = new Button(composite1, SWT.NONE);
		resetButton.setText("Reset");
		resetButton.setLayoutData(new GridData());
		Label label;

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 4;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		gridData = new GridData();

		label = new Label(composite1, SWT.NONE);
		label.setText("Table Row Limit");
		label.setLayoutData(new GridData());

		limitText = new Text(composite1, SWT.BORDER | SWT.RIGHT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		limitText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		domainButton = new Button(composite1, SWT.CHECK);
		domainButton.setText("Search Domain at Table Click");
		domainButton.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		GridLayout gridLayout2 = new GridLayout(1, false);
		Composite composite2 = new Composite(composite0, SWT.NONE);
		composite2.setLayoutData(new GridData(
				GridData.HORIZONTAL_ALIGN_BEGINNING));
		composite2.setLayout(gridLayout2);

		calendarComposite = new CalendarComposite();
		calendarComposite.setYearText(logStartYearText);
		calendarComposite.setMonthText(logStartMonthText);
		calendarComposite.setDateText(logStartDateText);

		calendarComposite.createCalendarView(composite2);

		GridLayout gridLayout3 = new GridLayout(9, false);
		Composite composite3 = new Composite(composite0, SWT.NONE);
		composite3.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL));
		composite3.setLayout(gridLayout3);

		Button startDateRadio = new Button(composite3, SWT.RADIO);
		startDateRadio.setText("Start date");

		startDateRadio.setSelection(true);
		GridData startGridData = new GridData();
		startGridData.horizontalSpan = HORIZONTALSPAN3;
		startGridData.verticalSpan = 1;
		startDateRadio.setLayoutData(startGridData);

		label = new Label(composite3, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTALSPAN6;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		logStartYearText = new Text(composite3, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 40;
		logStartYearText.setLayoutData(gridData);

		label = new Label(composite3, SWT.NONE);
		label.setText(" ");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		logStartMonthText = new Text(composite3, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 20;
		logStartMonthText.setLayoutData(gridData);

		label = new Label(composite3, SWT.NONE);
		label.setText("/");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		logStartDateText = new Text(composite3, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 20;
		logStartDateText.setLayoutData(gridData);

		label = new Label(composite3, SWT.NONE);
		label.setText(" ");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		startHourCombo = new Combo(composite3, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		// gridData.widthHint = 20;
		startHourCombo.setLayoutData(gridData);
		setHourCombo(startHourCombo);
		startHourCombo.select(0);

		label = new Label(composite3, SWT.NONE);
		label.setText(":");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		startMinuteCombo = new Combo(composite3, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		// gridData.widthHint = 20;
		startMinuteCombo.setLayoutData(gridData);
		setMinuteCombo(startMinuteCombo);
		startMinuteCombo.select(0);

		Button endDateRadio = new Button(composite3, SWT.RADIO);
		endDateRadio.setText("End date");

		endDateRadio.setSelection(false);
		GridData endGridData = new GridData();
		endGridData.horizontalSpan = HORIZONTALSPAN3;
		endGridData.verticalSpan = 1;
		endDateRadio.setLayoutData(endGridData);

		label = new Label(composite3, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTALSPAN6;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		logEndYearText = new Text(composite3, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 40;
		logEndYearText.setLayoutData(gridData);

		label = new Label(composite3, SWT.NONE);
		label.setText(" ");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		logEndMonthText = new Text(composite3, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 20;
		logEndMonthText.setLayoutData(gridData);

		label = new Label(composite3, SWT.NONE);
		label.setText("/");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		logEndDateText = new Text(composite3, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = 20;
		logEndDateText.setLayoutData(gridData);

		label = new Label(composite3, SWT.NONE);
		label.setText(" ");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		endHourCombo = new Combo(composite3, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		// gridData.widthHint = 20;
		endHourCombo.setLayoutData(gridData);
		setHourCombo(endHourCombo);
		endHourCombo.select(0);

		label = new Label(composite3, SWT.NONE);
		label.setText(":");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		endMinuteCombo = new Combo(composite3, SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		// gridData.widthHint = 20;
		endMinuteCombo.setLayoutData(gridData);
		setMinuteCombo(endMinuteCombo);
		endMinuteCombo.select(0);

		calendarComposite.setYearText(logStartYearText);
		calendarComposite.setMonthText(logStartMonthText);
		calendarComposite.setDateText(logStartDateText);

		/*
		 * FilterLԓ̊JnRdio{^IXi[
		 */
		startDateRadio.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				calendarComposite.setYearText(logStartYearText);
				calendarComposite.setMonthText(logStartMonthText);
				calendarComposite.setDateText(logStartDateText);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		/*
		 * FilterLԓ̏IRdio{^IXi[
		 */
		endDateRadio.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				calendarComposite.setYearText(logEndYearText);
				calendarComposite.setMonthText(logEndMonthText);
				calendarComposite.setDateText(logEndDateText);
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		setButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				setButton.setEnabled(false);

				try {

					setFilter();

				} catch (NumberFormatException e) {

				} finally {
					setButton.setEnabled(true);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		resetButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				resetButton.setEnabled(false);

				try {
					setInitialFilter();
					setFilter();
				} finally {
					resetButton.setEnabled(true);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		setInitialFilter();

		setFilter();
	}

	private void setFilter() {
		String limitString = limitText.getText();
		limit = Integer.parseInt(limitString);

		LogDataFilterInfo.getInstance().setSearchDomain(
				domainButton.getSelection());

		createDataInfo();
		LogDataFilterInfo.getInstance().setStartDateValue(startDateString);
		LogDataFilterInfo.getInstance().setEndDateValue(endDateString);
		LogDataFilterInfo.getInstance().setLimit(limit);

		Date workDate = Calendar.getInstance().getTime();
		if (startDateString != null && !startDateString.equals("")) {
			workDate.setTime(Long.parseLong(startDateString));
			LogDataFilterInfo.getInstance().setStartDate(workDate);
			Date workDate1 = Calendar.getInstance().getTime();
			workDate1.setTime(Long.parseLong(fileNameStartDateString));
			LogDataFilterInfo.getInstance().setFileNameStartDate(workDate1);

		}
		Date workDate2 = Calendar.getInstance().getTime();
		if (endDateString != null && !endDateString.equals("")) {
			workDate2.setTime(Long.parseLong(endDateString));
			LogDataFilterInfo.getInstance().setEndDate(workDate2);
			Date workDate3 = Calendar.getInstance().getTime();
			workDate3.setTime(Long.parseLong(fileNameEndDateString));
			LogDataFilterInfo.getInstance().setFileNameEndDate(workDate3);

		}
	}

	/*
	 * Hour Combo Boxݒ肵܂B
	 * 
	 * @param combo Hour Combo Box
	 */
	private void setHourCombo(Combo combo) {
		for (int i = 0; i < 24; i++) {
			String work = Integer.toString(i);

			if (work.length() == 1) {
				work = "0" + work;
			}

			combo.add(work);
		}
	}

	/*
	 * Minute Combo Boxݒ肵܂B
	 * 
	 * @param combo Minute Combo Box
	 */
	private void setMinuteCombo(Combo combo) {
		for (int i = 0; i < 60; i++) {
			String work = Integer.toString(i);

			if (work.length() == 1) {
				work = "0" + work;
			}

			combo.add(work);
		}
	}

	private void setInitialFilter() {

		limitText.setText(Integer.toString(LogDataFilterInfo.TABLE_LIMIT));
		domainButton.setSelection(false);
		/*
		 * LԃZbg
		 */
		String startDateWorkString = "";
		String endDateWorkString = "";
		if (LogDataFilterInfo.getInstance().getStartDateValue() != null) {
			startDateWorkString = LogDataFilterInfo.getInstance()
					.getStartDateValue();
		} else {
			Calendar cal = Calendar.getInstance();

			startDateWorkString = Long.toString(cal.getTimeInMillis());

		}
		if (LogDataFilterInfo.getInstance().getEndDateValue() != null) {
			endDateWorkString = LogDataFilterInfo.getInstance()
					.getEndDateValue();
		} else {
			Calendar cal = Calendar.getInstance();

			endDateWorkString = Long.toString(cal.getTimeInMillis());
		}

		try {
			long startDateLong = Long.parseLong(startDateWorkString);

			Date startDate = new Date(startDateLong);

			Calendar cal = Calendar.getInstance();
			cal.setTime(startDate);

			logStartYearText.setText(Integer.toString(cal.get(Calendar.YEAR)));
			logStartMonthText.setText(Integer
					.toString((cal.get(Calendar.MONTH) + 1)));
			logStartDateText.setText(Integer.toString(cal
					.getActualMinimum(Calendar.DATE)));

			// String work = Integer.toString(cal.get(Calendar.HOUR_OF_DAY));
			String work = "00";
			if (work.length() == 1) {
				work = "0" + work;
			}

			startHourCombo.setText(work);
			// work = Integer.toString(cal.get(Calendar.MINUTE));
			work = "00";
			if (work.length() == 1) {
				work = "0" + work;
			}

			startMinuteCombo.setText(work);
		} catch (NumberFormatException e) {
			// nothing
		}

		try {
			Date endDate = new Date(Long.parseLong(endDateWorkString));

			Calendar cal = Calendar.getInstance();
			cal.setTime(endDate);

			logEndYearText.setText(Integer.toString(cal.get(Calendar.YEAR)));
			logEndMonthText.setText(Integer
					.toString((cal.get(Calendar.MONTH) + 1)));
			logEndDateText.setText(Integer.toString(cal
					.getActualMaximum(Calendar.DATE)));

			// String work = Integer.toString(cal.get(Calendar.HOUR_OF_DAY));
			String work = "23";
			if (work.length() == 1) {
				work = "0" + work;
			}

			endHourCombo.setText(work);
			// work = Integer.toString(cal.get(Calendar.MINUTE));
			work = "59";
			if (work.length() == 1) {
				work = "0" + work;
			}

			endMinuteCombo.setText(work);
		} catch (NumberFormatException e) {
			// nothing
		}

	}

	private void createDataInfo() {
		int year = 0;
		int month = 0;
		int date = 0;
		int hour = 0;
		int minute = 0;
		long dayMillSec = 24 * 60 * 60 * 1000;
		if ((logStartYearText.getText() != null)
				&& !logStartYearText.getText().equals("")) {
			String startYearString = logStartYearText.getText();
			String startMonthString = logStartMonthText.getText();
			String startDateWorkString = logStartDateText.getText();

			String startHourString = startHourCombo.getText();
			String startMinuteString = startMinuteCombo.getText();

			try {
				year = Integer.parseInt(startYearString);
				month = Integer.parseInt(startMonthString);
				date = Integer.parseInt(startDateWorkString);
				hour = Integer.parseInt(startHourString);
				minute = Integer.parseInt(startMinuteString);

				Calendar cal = Calendar.getInstance();
				cal.set(year, month - 1, date, hour, minute, 0);

				startDateString = Long.toString(cal.getTimeInMillis());

				cal = Calendar.getInstance();
				cal.set(year, month - 1, date, 0, 0, 0);

				fileNameStartDateString = Long.toString(cal.getTimeInMillis()
						- (dayMillSec * 2));

			} catch (NumberFormatException e) {
				e.printStackTrace();
			}
		}

		if ((logEndYearText.getText() != null)
				&& !logEndYearText.getText().equals("")) {
			String endYearString = logEndYearText.getText();
			String endMonthString = logEndMonthText.getText();
			String endDateWorkString = logEndDateText.getText();

			String endHourString = endHourCombo.getText();
			String endMinuteString = endMinuteCombo.getText();

			try {
				year = Integer.parseInt(endYearString);
				month = Integer.parseInt(endMonthString);
				date = Integer.parseInt(endDateWorkString);
				hour = Integer.parseInt(endHourString);
				minute = Integer.parseInt(endMinuteString);

				Calendar cal = Calendar.getInstance();
				cal.set(year, month - 1, date, hour, minute, 0);
				endDateString = Long.toString(cal.getTimeInMillis());
				cal = Calendar.getInstance();
				cal.set(year, month - 1, date, 0, 0, 0);
				fileNameEndDateString = Long.toString(cal.getTimeInMillis()
						+ (dayMillSec * 2));

			} catch (NumberFormatException e) {
				e.printStackTrace();
			}
		}

	}
}
