/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.gui.filtersearch;

import java.util.ArrayList;

import netjfwatcher.webalizer.preference.ResourceConfigFileParse;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.part.ViewPart;

public class FilterView extends ViewPart {

	private static final int LIS_WIDTH = 200;

	private static final int FILTER_LIST_VERTICAL_SPAN = 11;

	private static final int FILTER_LIST_HEIGHT_HINT = 5;

	private static final int HORIZONTALSPAN4 = 4;

	private static final int HORIZONTALSPAN2 = 2;

	private List searchEngineBotViewList;

	private List hideURLViewList;

	private List pageTypeViewList;

	public FilterView() {

	}

	/**
	 * Calendar Composite𐶐ViewɃZbg܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {

		GridData gridData = null;

		GridLayout gridLayout0 = new GridLayout(1, false);
		Composite composite0 = new Composite(parent, SWT.LEFT);
		composite0.setLayout(gridLayout0);
		composite0.setLayoutData(new GridData());

		GridLayout gridLayout = new GridLayout(HORIZONTALSPAN4, false);
		Composite composite1 = new Composite(composite0, SWT.LEFT);
		composite1.setLayout(gridLayout);
		composite1.setLayoutData(new GridData());

		Label label;

		label = new Label(composite1, SWT.NONE);
		label.setText("Hide Search Engine Bot");
		gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = FILTER_LIST_VERTICAL_SPAN;
		label.setLayoutData(gridData);

		searchEngineBotViewList = new List(composite1, SWT.SINGLE | SWT.BORDER
				| SWT.V_SCROLL);

		GridData data = new GridData();
		data.horizontalSpan = HORIZONTALSPAN2;
		data.verticalSpan = FILTER_LIST_VERTICAL_SPAN; // XgXpZbg
		data.widthHint = LIS_WIDTH;
		data.heightHint = searchEngineBotViewList.getItemHeight()
				* FILTER_LIST_HEIGHT_HINT;
		searchEngineBotViewList.setLayoutData(data);

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = FILTER_LIST_VERTICAL_SPAN;
		label.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Hide URL File Type");
		gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = FILTER_LIST_VERTICAL_SPAN;
		label.setLayoutData(gridData);

		hideURLViewList = new List(composite1, SWT.SINGLE | SWT.BORDER
				| SWT.V_SCROLL);

		data = new GridData();
		data.horizontalSpan = HORIZONTALSPAN2;
		data.verticalSpan = FILTER_LIST_VERTICAL_SPAN; // XgXpZbg
		data.widthHint = LIS_WIDTH;
		data.heightHint = hideURLViewList.getItemHeight()
				* FILTER_LIST_HEIGHT_HINT;
		hideURLViewList.setLayoutData(data);

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = FILTER_LIST_VERTICAL_SPAN;
		label.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("Page Count Type");
		gridData = new GridData(GridData.VERTICAL_ALIGN_BEGINNING);
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = FILTER_LIST_VERTICAL_SPAN;
		label.setLayoutData(gridData);

		pageTypeViewList = new List(composite1, SWT.SINGLE | SWT.BORDER
				| SWT.V_SCROLL);

		data = new GridData();
		data.horizontalSpan = HORIZONTALSPAN2;
		data.verticalSpan = FILTER_LIST_VERTICAL_SPAN; // XgXpZbg
		data.widthHint = LIS_WIDTH;
		data.heightHint = pageTypeViewList.getItemHeight()
				* FILTER_LIST_HEIGHT_HINT;
		pageTypeViewList.setLayoutData(data);

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = FILTER_LIST_VERTICAL_SPAN;
		label.setLayoutData(gridData);

		setListInfo();

	}

	private void setListInfo() {

		searchEngineBotViewList.removeAll();
		ArrayList<String> searchEngineList = ResourceConfigFileParse
				.getInstance().getSearchEngineBotList();
		if (searchEngineList != null) {
			for (int i = 0; i < searchEngineList.size(); i++) {
				searchEngineBotViewList.add((String) searchEngineList.get(i));
			}
		}

		hideURLViewList.removeAll();
		ArrayList<String> hideURLList = ResourceConfigFileParse.getInstance()
				.getHideURLList();
		if (hideURLList != null) {
			for (int i = 0; i < hideURLList.size(); i++) {
				hideURLViewList.add((String) hideURLList.get(i));
			}
		}

		pageTypeViewList.removeAll();
		ArrayList<String> pageTypeList = ResourceConfigFileParse.getInstance()
				.getPageTypeList();
		if (pageTypeList != null) {
			for (int i = 0; i < pageTypeList.size(); i++) {
				pageTypeViewList.add((String) pageTypeList.get(i));
			}
		}
	}

	/**
	 * tH[JXZbgꂽ̏łB
	 */
	public void setFocus() {
		setListInfo();
	}

}
