/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.gui.filtersearch;

import netjfwatcher.webalizer.gui.table.plainlog.AccessLogInfoReceiveMessageQueue;
import netjfwatcher.webalizer.gui.table.plainlog.AccessLogTableTimerProcessor;
import netjfwatcher.webalizer.gui.table.sitelog.LogAlizerInfoReceiveMessageQueue;
import netjfwatcher.webalizer.gui.table.sitelog.LogAlizerTableTimerProcessor;
import netjfwatcher.webalizer.model.info.AccessPlainLogInfo;
import netjfwatcher.webalizer.model.info.AccessSiteLogInfo;
import netjfwatcher.webalizer.model.info.LogInfoControl;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;

public class SearchView extends ViewPart {

	private static final int TEXT_WIDTH = 120;

	private static final int HORIZONTALSPAN4 = 4;

	private Button ipAddressSearchButton;

	private Button requestSearchButton;

	private Text ipAddressSearchText;

	private Text requestSearchText;

	public SearchView() {

	}

	/**
	 * Calendar Composite𐶐ViewɃZbg܂B
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {

		GridData gridData = null;

		GridLayout gridLayout0 = new GridLayout(1, false);
		Composite composite0 = new Composite(parent, SWT.LEFT);
		composite0.setLayout(gridLayout0);
		composite0.setLayoutData(new GridData());

		GridLayout gridLayout = new GridLayout(HORIZONTALSPAN4, false);
		Composite composite1 = new Composite(composite0, SWT.LEFT);
		composite1.setLayout(gridLayout);
		composite1.setLayoutData(new GridData());

		ipAddressSearchButton = new Button(composite1, SWT.NONE);
		ipAddressSearchButton.setText("IP Address Search");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		ipAddressSearchButton.setLayoutData(gridData);

		Label label;

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		gridData = new GridData();

		label = new Label(composite1, SWT.NONE);
		label.setText("IP Address");
		label.setLayoutData(new GridData());

		ipAddressSearchText = new Text(composite1, SWT.BORDER | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		ipAddressSearchText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = HORIZONTALSPAN4;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		requestSearchButton = new Button(composite1, SWT.NONE);
		requestSearchButton.setText("Request Search");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		requestSearchButton.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		gridData = new GridData();

		label = new Label(composite1, SWT.NONE);
		label.setText("Request");
		label.setLayoutData(new GridData());

		requestSearchText = new Text(composite1, SWT.BORDER | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 1;
		gridData.widthHint = TEXT_WIDTH;
		requestSearchText.setLayoutData(gridData);

		label = new Label(composite1, SWT.NONE);
		label.setText("");
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.verticalSpan = 1;
		label.setLayoutData(gridData);

		ipAddressSearchButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				ipAddressSearchButton.setEnabled(false);

				try {
					setIPSearchTable();

				} finally {
					ipAddressSearchButton.setEnabled(true);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

		requestSearchButton.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent event) {
				requestSearchButton.setEnabled(false);

				try {
					setRequestSearchTable();

				} finally {
					requestSearchButton.setEnabled(true);
				}
			}

			public void widgetDefaultSelected(SelectionEvent event) {
			}
		});

	}

	private void setIPSearchTable() {
		AccessLogInfoReceiveMessageQueue.getInstance().clearMessageQueue();
		LogAlizerInfoReceiveMessageQueue.getInstance().clearMessageQueue();
		if (AccessLogTableTimerProcessor.getInstance().getAccessLogTable() != null) {
			AccessLogTableTimerProcessor.getInstance().getAccessLogTable()
					.removeAll();
		}
		if (LogAlizerTableTimerProcessor.getInstance().getAccessLogTable() != null) {
			LogAlizerTableTimerProcessor.getInstance().getAccessLogTable()
					.removeAll();
		}
		java.util.List accessLogDataList = LogInfoControl.getInstance()
				.getAccessPlainLogData();
		if (accessLogDataList == null) {
			return;
		}
		int tableCount = 0;
		for (int i = 0; i < accessLogDataList.size(); i++) {
			AccessPlainLogInfo accessLogInfo = (AccessPlainLogInfo) accessLogDataList
					.get(i);
			if (accessLogInfo.getAccessIPAddress().indexOf(
					ipAddressSearchText.getText()) >= 0) {
				if (tableCount < LogDataFilterInfo.getInstance().getLimit()) {
					AccessLogInfoReceiveMessageQueue.getInstance()
							.pushAccessLogInfo(accessLogInfo);
					tableCount++;
				}
			}
		}

		java.util.List accessSiteLogDataList = LogInfoControl.getInstance()
				.getAccessSiteLogData();
		if (accessSiteLogDataList == null) {
			return;
		}
		tableCount = 0;
		for (int i = 0; i < accessSiteLogDataList.size(); i++) {
			AccessSiteLogInfo accessSiteLogInfo = (AccessSiteLogInfo) accessSiteLogDataList
					.get(i);
			if (accessSiteLogInfo.getAccessIPAddress().indexOf(
					ipAddressSearchText.getText()) >= 0) {
				if (tableCount <= LogDataFilterInfo.getInstance().getLimit()) {
					LogAlizerInfoReceiveMessageQueue.getInstance()
							.pushAccessLogInfo(accessSiteLogInfo);
					tableCount++;
				}
			}
		}
	}

	private void setRequestSearchTable() {
		AccessLogInfoReceiveMessageQueue.getInstance().clearMessageQueue();
		if (AccessLogTableTimerProcessor.getInstance().getAccessLogTable() != null) {
			AccessLogTableTimerProcessor.getInstance().getAccessLogTable()
					.removeAll();
		}

		java.util.List accessLogDataList = LogInfoControl.getInstance()
				.getAccessPlainLogData();
		if (accessLogDataList == null) {
			return;
		}
		int tableCount = 0;
		for (int i = 0; i < accessLogDataList.size(); i++) {
			AccessPlainLogInfo accessLogInfo = (AccessPlainLogInfo) accessLogDataList
					.get(i);
			if (accessLogInfo.getRequest().indexOf(requestSearchText.getText()) >= 0) {
				if (tableCount < LogDataFilterInfo.getInstance().getLimit()) {
					AccessLogInfoReceiveMessageQueue.getInstance()
							.pushAccessLogInfo(accessLogInfo);
					tableCount++;
				}
			}
		}
	}

	/**
	 * tH[JXZbgꂽ̏łB
	 */
	public void setFocus() {

	}

}