/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.gui.table.sitelog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import netjfwatcher.webalizer.model.info.AccessSiteLogInfo;

public final class LogAlizerInfoReceiveMessageQueue {
	/* L[郊Xg */
	private static List<AccessSiteLogInfo> accessLogInfoQueueList;

	private static final int LIMIT = 100000;

	private LogAlizerInfoReceiveMessageQueue() {
		accessLogInfoQueueList = Collections
				.synchronizedList(new ArrayList<AccessSiteLogInfo>());
	}

	public synchronized void clearMessageQueue() {
		accessLogInfoQueueList.clear();
	}

	public synchronized void pushAccessLogInfo(
			final AccessSiteLogInfo accessLogInfo) {

		if (accessLogInfoQueueList.size() > LIMIT) {
			accessLogInfoQueueList.remove(0);
			accessLogInfoQueueList.add(accessLogInfo);
		} else {
			accessLogInfoQueueList.add(accessLogInfo);
		}
	}

	public synchronized AccessSiteLogInfo popAccessLogInfo() {
		AccessSiteLogInfo accessLogInfo = null;

		if (accessLogInfoQueueList.size() > 0) {
			accessLogInfo = (AccessSiteLogInfo) accessLogInfoQueueList.get(0);
			accessLogInfoQueueList.remove(0);
		}

		return accessLogInfo;
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static LogAlizerInfoReceiveMessageQueue getInstance() {
		return SingletonResource.BEAN_MESSAGE_QUEUE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final LogAlizerInfoReceiveMessageQueue BEAN_MESSAGE_QUEUE = new LogAlizerInfoReceiveMessageQueue();
	}

}
