/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.gui.table.sitelog;

import netjfwatcher.common.view.AbstractTableView;
import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.webalizer.gui.action.ActionBuilderAccessLogTable;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.PlatformUI;

public class LogAlizerTableView extends AbstractTableView {

	private static boolean isCol0Direction = false;

	private static boolean isCol1Direction = true;

	private static boolean isCol2Direction = true;

	private static boolean isCol3Direction = true;

	private static boolean isCol4Direction = true;

	private static boolean isCol5Direction = true;

	private static boolean isCol6Direction = true;

	private static boolean isCol7Direction = true;

	private TableColumn col0;

	private TableColumn col1;

	private TableColumn col2;

	private TableColumn col3;

	private TableColumn col4;

	private TableColumn col5;

	private TableColumn col6;

	private TableColumn col7;

	/* J */
	private static final float COLUMN0_NO = 0.04f;

	private static final float COLUMN1_HOST_NAME = 0.3f;

	private static final float COLUMN2_DOMAIN = 0.2f;

	private static final float COLUMN3_HITS = 0.04f;

	private static final float COLUMN4_FILES = 0.04f;

	private static final float COLUMN5_PAGES = 0.04f;

	private static final float COLUMN6_VISITS = 0.04f;

	private static final float COLUMN7_BYTES = 0.15f;

	/* Table */
	private Table table;

	/* TableViewer */
	private TableViewer viewer;

	private LogAlizerTableTimerProcessor timerProcessor;

	private ActionBuilderAccessLogTable actionAccessLogTableBuilder;

	private ActionBuilderEditorsPartClose actionEditorsPartClose;

	/* Xe[^XC}l[W */
	private SubStatusLineManager statusLineManager;

	public LogAlizerTableView() {
		// nothing
	}

	/**
	 * ActionBuilderԂ܂B
	 * 
	 * @return actionBuilder actionOidTableBuilder
	 */
	private ActionBuilderAccessLogTable getActionBuilder() {
		return actionAccessLogTableBuilder;
	}

	/**
	 * tH[JXZbgꂽƂ̏łB
	 */
	public void setFocus() {
	}

	/**
	 * e[uViewi\`̌ځjԂ܂B
	 * 
	 * @return viewer TableViewer
	 */
	public TableViewer getViewer() {
		return viewer;
	}

	/**
	 * r[ꂽƂɂ܂sꃁ\bhłB
	 * 
	 * @param parent
	 *            Composite
	 */
	public void createPartControl(Composite parent) {
		display = parent.getDisplay();
		createTable(parent);
		viewer = new TableViewer(table);
		viewer.setUseHashlookup(true);

		viewer.setContentProvider(new LogAlizerTableViewContentProvider());

		/* xEtHgȂǂݒ */
		viewer.setLabelProvider(new LogAlizerTableViewLabelProvider());

		actionAccessLogTableBuilder = new ActionBuilderAccessLogTable(table);
		actionEditorsPartClose = new ActionBuilderEditorsPartClose();
		createContextMenu();
		initActions();
		LogAlizerTableTimerProcessor.getInstance().setTable(viewer, table);
		startTimer();
	}

	private void startTimer() {

		LogAlizerTableTimerProcessor.getInstance().setDisplay(display,
				statusLineManager);
		timerProcessor = LogAlizerTableTimerProcessor.getInstance();
		display.timerExec(LogAlizerTableTimerProcessor.TIMER, timerProcessor);

	}

	private int computeCol0Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN0_NO);
	}

	private int computeCol1Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN1_HOST_NAME);
	}

	private int computeCol2Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN2_DOMAIN);
	}

	private int computeCol3Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN3_HITS);
	}

	private int computeCol4Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN4_FILES);
	}

	private int computeCol5Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN5_PAGES);
	}

	private int computeCol6Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN6_VISITS);
	}

	private int computeCol7Width() {
		return (int) (getSite().getShell().getSize().x * COLUMN7_BYTES);
	}

	private void createTable(Composite parent) {
		/* Xe[^XC\L */
		statusLineManager = (SubStatusLineManager) (getViewSite()
				.getActionBars().getStatusLineManager());
		statusLineManager.setVisible(true);

		table = new Table(parent, SWT.H_SCROLL | SWT.V_SCROLL
				| SWT.FULL_SELECTION);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);

		col0 = new TableColumn(table, SWT.LEFT);
		col0
				.setText(LogAlizerTableViewLabelProvider.HEADER_COLUMNS[LogAlizerTableViewLabelProvider.NO_COLUMN_NO]);
		col0.setWidth(computeCol0Width());

		col1 = new TableColumn(table, SWT.LEFT);
		col1
				.setText(LogAlizerTableViewLabelProvider.HEADER_COLUMNS[LogAlizerTableViewLabelProvider.HOST_NAME_COLUMN_NO]);
		col1.setWidth(computeCol1Width());

		col2 = new TableColumn(table, SWT.LEFT);
		col2
				.setText(LogAlizerTableViewLabelProvider.HEADER_COLUMNS[LogAlizerTableViewLabelProvider.DOMAIN_COLUMN_NO]);
		col2.setWidth(computeCol2Width());

		col3 = new TableColumn(table, SWT.LEFT);
		col3
				.setText(LogAlizerTableViewLabelProvider.HEADER_COLUMNS[LogAlizerTableViewLabelProvider.HITS_COLUMN_NO]);
		col3.setWidth(computeCol3Width());

		col4 = new TableColumn(table, SWT.LEFT);
		col4
				.setText(LogAlizerTableViewLabelProvider.HEADER_COLUMNS[LogAlizerTableViewLabelProvider.FILES_COLUMN_NO]);
		col4.setWidth(computeCol4Width());

		col5 = new TableColumn(table, SWT.LEFT);
		col5
				.setText(LogAlizerTableViewLabelProvider.HEADER_COLUMNS[LogAlizerTableViewLabelProvider.PAGES_COLUMN_NO]);
		col5.setWidth(computeCol5Width());

		col6 = new TableColumn(table, SWT.LEFT);
		col6
				.setText(LogAlizerTableViewLabelProvider.HEADER_COLUMNS[LogAlizerTableViewLabelProvider.VISITS_COLUMN_NO]);
		col6.setWidth(computeCol6Width());

		col7 = new TableColumn(table, SWT.LEFT);
		col7
				.setText(LogAlizerTableViewLabelProvider.HEADER_COLUMNS[LogAlizerTableViewLabelProvider.BYTES_COLUMN_NO]);
		col7.setWidth(computeCol7Width());

		/*
		 * TableōsNbNꂽꍇ̏
		 */
		table.addSelectionListener(new LogAlizerTableListener(table));

		/**
		 * e[uړꍇ͂TCYꍇ̃Xi[łB
		 * 
		 */
		PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()
				.addControlListener(new ControlListener() {
					public void controlMoved(ControlEvent event) {
					}

					/*
					 * e[uTCYɃe[uJZbg܂B
					 */
					public void controlResized(ControlEvent event) {

						setResizedTableColumnWidth();
					}
				});

		col0.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol0Direction = sortIntegerTable(table,
						LogAlizerTableViewLabelProvider.NO_COLUMN_NO,
						isCol0Direction);
			}
		});

		col1.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol1Direction = sortTable(table,
						LogAlizerTableViewLabelProvider.HOST_NAME_COLUMN_NO,
						isCol1Direction);
			}
		});

		col2.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol2Direction = sortTable(table,
						LogAlizerTableViewLabelProvider.DOMAIN_COLUMN_NO,
						isCol2Direction);
			}
		});

		col3.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol3Direction = sortIntegerTable(table,
						LogAlizerTableViewLabelProvider.HITS_COLUMN_NO,
						isCol3Direction);
			}
		});

		col4.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol4Direction = sortIntegerTable(table,
						LogAlizerTableViewLabelProvider.FILES_COLUMN_NO,
						isCol4Direction);
			}
		});

		col5.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol5Direction = sortIntegerTable(table,
						LogAlizerTableViewLabelProvider.PAGES_COLUMN_NO,
						isCol5Direction);
			}
		});

		col6.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol6Direction = sortIntegerTable(table,
						LogAlizerTableViewLabelProvider.VISITS_COLUMN_NO,
						isCol6Direction);
			}
		});

		col7.addListener(SWT.Selection, new Listener() {
			public void handleEvent(Event event) {
				/* J\[gA\[gێ */
				isCol7Direction = sortIntegerTable(table,
						LogAlizerTableViewLabelProvider.BYTES_COLUMN_NO,
						isCol7Direction);
			}
		});

	}

	protected void setResizedTableColumnWidth() {
		/*
		 * e[u\Ԃł΃e[uJZbg
		 */
		if (getSite().getPage().isPartVisible(getSite().getPart())
				&& getSite().getShell() != null) {
			if (getSite().getShell().getSize() != null) {
				col0.setWidth(computeCol0Width());
				col1.setWidth(computeCol1Width());
				col2.setWidth(computeCol2Width());
				col3.setWidth(computeCol3Width());
				col4.setWidth(computeCol4Width());
				col5.setWidth(computeCol5Width());
				col6.setWidth(computeCol6Width());
				col7.setWidth(computeCol7Width());

			}
		}

	}

	/**
	 * j[o[ preWindowOpenɌĂ΂܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		/* j[}l[WɃANVZbg */
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
		manager.add(getActionBuilder().actionAnalysis());
		manager.add(getActionBuilder().actionClearTable());
		manager.add(actionEditorsPartClose.actionCloseAllEditors());
	}

	/**
	 * ContextMenu𐶐܂B
	 * 
	 */
	private void createContextMenu() {
		/* j[}l[W */
		MenuManager mm = new MenuManager();
		mm.setRemoveAllWhenShown(true);

		/* j[}l[WXi[Zbg */
		mm.addMenuListener(new IMenuListener() {
			/**
			 * j[}l[WXi[łB
			 */
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		/*
		 * ReLXgj[𐶐Zbg
		 */
		Menu menu = mm.createContextMenu(viewer.getControl());
		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(mm, viewer);
	}

	private void initActions() {
		IToolBarManager toolBarManager = getViewSite().getActionBars()
				.getToolBarManager();

		toolBarManager.add(getActionBuilder().actionAnalysis());
		toolBarManager.add(getActionBuilder().actionClearTable());
		toolBarManager.add(actionEditorsPartClose.actionCloseAllEditors());

	}
}
