/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.gui.table.sitelog;

import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class LogAlizerTableViewLabelProvider implements ITableLabelProvider,
		IFontProvider {

	public static final String[] HEADER_COLUMNS = new String[] { "No.",
			"Host Name", "Domain Name", "Hits", "Files", "Pages", "Visits",
			"Bytes" };

	public static final int MANAGER_TABLE_ARRAY_COUNT = 8;

	public static final int NO_COLUMN_NO = 0;

	public static final int HOST_NAME_COLUMN_NO = 1;

	public static final int DOMAIN_COLUMN_NO = 2;

	public static final int HITS_COLUMN_NO = 3;

	public static final int FILES_COLUMN_NO = 4;

	public static final int PAGES_COLUMN_NO = 5;

	public static final int VISITS_COLUMN_NO = 6;

	public static final int BYTES_COLUMN_NO = 7;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.
	 *      ITableLabelProvider#getColumnImage(java.lang.Object, int)
	 */
	public Image getColumnImage(Object element, int columnIndex) {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.
	 *      ITableLabelProvider#getColumnText(java.lang.Object, int)
	 */
	public String getColumnText(Object element, int columnIndex) {
		String[] test = (String[]) element;

		return test[columnIndex];
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IFontProvider#getFont(java.lang.Object)
	 */
	public Font getFont(Object element) {
		// assert element instanceof SyndEntryI;
		FontRegistry fr = JFaceResources.getFontRegistry();

		/*
		 * SyndEntryI entry = (SyndEntryI) element;
		 * 
		 * if (! HistoryManager.getInstance().isRead(entry.getLink())) { return
		 * fr.getBold(JFaceResources.DEFAULT_FONT); }
		 */
		return fr.get(JFaceResources.DEFAULT_FONT);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.
	 *      IBaseLabelProvider#isLabelProperty(java.lang.Object,
	 *      java.lang.String)
	 */
	public boolean isLabelProperty(Object element, String property) {
		return true;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.
	 *      IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void addListener(ILabelProviderListener listener) {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	public void dispose() {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void removeListener(ILabelProviderListener listener) {
	}
}
