/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.gui.treeview;

import netjfwatcher.engine.model.action.ActionBuilderEditorsPartClose;
import netjfwatcher.webalizer.gui.action.ActionBuilderLogNodeTree;
import netjfwatcher.webalizer.gui.treenode.ILogTreeNode;
import netjfwatcher.webalizer.gui.treenode.LogNodeTreeGroup;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public abstract class AbstractLogTreeView extends ViewPart {
	/** Node TreeANV */
	protected ActionBuilderLogNodeTree actionLogNodeTree;

	/** Editor PartɊւANV */
	protected ActionBuilderEditorsPartClose actionBuilderEditorPart = new ActionBuilderEditorsPartClose();

	/** TreeViewer */
	protected TreeViewer nodeTreeViewer;

	/**
	 * Node Tree Viewɂ郁o[yу\bh钊ۃNX CX^X𐶐܂B
	 * 
	 */
	public AbstractLogTreeView() {
		// nothing
	}

	/**
	 * m[hTreeɊւANVԂ܂B
	 * 
	 * @return actionNodeTree m[hTreeɊւANV
	 */
	public ActionBuilderLogNodeTree getActionNodeTreeBuilder() {
		return actionLogNodeTree;
	}

	/**
	 * tH[JXZbgꂽ̏łB
	 * 
	 */
	public void setFocus() {
	}

	/**
	 * TreeViewerԂ܂B
	 * 
	 * @return nodeTreeViewer TreeViewer
	 */
	public TreeViewer getViewer() {
		return nodeTreeViewer;
	}

	/**
	 * r[ꂽƂɂ܂sꃁ\bhłB
	 * 
	 * @param parentComposite
	 *            Composite
	 */
	public void createPartControl(Composite parentComposite) {
		/* Tree Viewer𐶐 */
		nodeTreeViewer = new TreeViewer(parentComposite);
		nodeTreeViewer.setUseHashlookup(true);
		nodeTreeViewer.setContentProvider(new LogTreeViewContentProvider());
		nodeTreeViewer.setLabelProvider(new LogTreeViewLabelProvider());

		/* SorterZbg */
		nodeTreeViewer.setSorter(new LogTreeViewSorter());

		/* m[hTree Group̓f[^ƂăZbg */
		nodeTreeViewer.setInput(createInitialInput());
		nodeTreeViewer.expandAll();

		/* m[hTreeRoot擾 */
		ILogTreeNode nodeTreeNode = (ILogTreeNode) getViewer().getInput();
		LogNodeTreeGroup nodeTreeGroupRoot = nodeTreeNode.getParent();

		if (nodeTreeNode instanceof LogNodeTreeGroup) {
			nodeTreeGroupRoot = (LogNodeTreeGroup) nodeTreeNode;
		}

		/* m[hTreeANVZbg */
		actionLogNodeTree = new ActionBuilderLogNodeTree(this, nodeTreeViewer,
				parentComposite, nodeTreeGroupRoot);

		/* m[hTree View̑IXi[ݒ */
		setupNodeTreeViewListener();

		/* Contextj[ */
		createContextMenu();

		/* ANV̏ƂToolBarݒ */
		setToolBarActions();

		/* \ݒ */
		initShow();
	}

	/**
	 * ̃m[hTreer[̏͐ݒl𐶐܂B
	 * 
	 * @return topInputDataObject
	 */
	protected Object createInitialInput() {
		/* m[hTreełtopm[h𐶐 */
		LogNodeTreeGroup topInputDataObject = new RootOfRootNodeTreeGroup();

		return topInputDataObject;
	}

	/**
	 * m[hTree View̏\̂߂Ƀf[^擾A\ \bhłB
	 * 
	 */
	abstract protected void initShow();

	/**
	 * m[hTree View̑IXi[ݒ肵܂B
	 * 
	 */
	protected void setupNodeTreeViewListener() {
		/*
		 * Node Tree ViewɃXi[o^ Xi[̏ƂẮA e[uViewɃtB[hꗗőIGg͒lƂĐݒ
		 * 
		 */
		nodeTreeViewer.addSelectionChangedListener(new LogTreeListener());
	}

	/**
	 * m[hTree View̃j[ݒ肷郁\bhłB
	 * 
	 */
	abstract protected void setToolBarActions();

	/**
	 * m[hTree ViewContextj[ݒ肷郁\bhłB
	 * 
	 */
	abstract protected void createContextMenu();

	/**
	 * m[hTreeɂTopm[ĥ߂̃NXłB
	 * 
	 * @author Yoshimasa Matsumoto
	 * @version 1.0
	 */
	protected static final class RootOfRootNodeTreeGroup extends
			LogNodeTreeGroup {
		/**
		 * em[hԂ܂B
		 * 
		 * @return em[h
		 */
		public LogNodeTreeGroup getParent() {
			return null;
		}

		/**
		 * qm[h폜܂B
		 * 
		 * @param toRemove
		 *            m[h
		 */
		public void removeChild(ILogTreeNode toRemove) {
			// ROOT O[vȂ悤ɃI[o[Ch
		}
	}
}
