/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.gui.treeview;

import java.util.logging.Logger;

import netjfwatcher.webalizer.gui.treenode.LogNodeTree;
import netjfwatcher.webalizer.gui.treenode.LogNodeTreeGroup;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class LogTreeListener implements ISelectionChangedListener {
	/* IWorkbenchPage */
	private static IWorkbenchPage activePage;

	private IEditorPart editorPart;

	/* MO */
	private static Logger logger = null;

	public LogTreeListener() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	public void selectionChanged(SelectionChangedEvent event) {

		StructuredSelection ss = (StructuredSelection) event.getSelection();

		if (!(ss.getFirstElement() instanceof LogNodeTreeGroup)
				&& !(ss.getFirstElement() instanceof LogNodeTree)) {

			return;
		}

		IWorkbenchPage activePage = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage();

		if (editorPart != null) {

			activePage.closeEditor(editorPart, false);
			editorPart = null;
		}

	}
}
