/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.gui.treeview;

import java.util.logging.Logger;

import netjfwatcher.webalizer.gui.action.ActionBuilderLogNodeTree.ActionLogFileRemove;
import netjfwatcher.webalizer.gui.action.ActionBuilderLogNodeTree.ActionLogFileView;
import netjfwatcher.webalizer.gui.action.ActionBuilderLogNodeTree.ActionReloadLogNodeTree;
import netjfwatcher.webalizer.gui.treenode.ILogTreeNode;
import netjfwatcher.webalizer.gui.treenode.LogNodeTree;
import netjfwatcher.webalizer.gui.treenode.LogNodeTreeGroup;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchActionConstants;

public class LogTreeView extends AbstractLogTreeView {

	private static Logger logger = null;

	public LogTreeView() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	protected void initShow() {
		((ActionReloadLogNodeTree) actionLogNodeTree.actionReloadLogNodeTree())
				.setNodeTree();

	}

	/**
	 * ReLXgj[𐶐܂B
	 * 
	 */
	public void createContextMenu() {
		/* j[}l[W */
		MenuManager mm = new MenuManager();
		mm.setRemoveAllWhenShown(true);

		/* j[Xi[Zbg */
		mm.addMenuListener(new IMenuListener() {
			public void menuAboutToShow(IMenuManager manager) {
				fillContextMenu(manager);
			}
		});

		Menu menu = mm.createContextMenu(nodeTreeViewer.getControl());
		nodeTreeViewer.getControl().setMenu(menu);
		getSite().registerContextMenu(mm, nodeTreeViewer);
	}

	/**
	 * ANV̏ƂToolBarݒ肵܂B
	 * 
	 */
	protected void setToolBarActions() {
		/* ToolBarݒ */
		IToolBarManager toolBarManager = getViewSite().getActionBars()
				.getToolBarManager();

		/* m[hTreeēǍANV */
		toolBarManager
				.add(getActionNodeTreeBuilder().actionReloadLogNodeTree());
		toolBarManager.add(getActionNodeTreeBuilder().actionSortLogNodeTree());
		toolBarManager.add(actionBuilderEditorPart.actionCloseAllEditors());
	}

	/**
	 * j[o[ݒ肵܂B preWindowOpenɌĂ΂܂B m[hTreẽm[hIĂꍇƑIĂȂꍇ
	 * j[ς܂B
	 * 
	 * @param manager
	 *            IMenuManager
	 */
	protected void fillContextMenu(IMenuManager manager) {
		/* m[hTreeǂݍ݃ANVZbg */
		manager.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));

		/* m[hTreeēǂݍ */
		manager.add(getActionNodeTreeBuilder().actionReloadLogNodeTree());

		/* m[hTree\[g */
		manager.add(getActionNodeTreeBuilder().actionSortLogNodeTree());

		/*
		 * Treẽm[hIĂ邩`FbN
		 */
		if (nodeTreeViewer.getTree().getSelection() != null) {
			TreeItem[] treeItem = nodeTreeViewer.getTree().getSelection();

			if ((treeItem != null) && (treeItem.length > 0)) {
				for (int nodeTreeSelectNo = 0; nodeTreeSelectNo < treeItem.length; nodeTreeSelectNo++) {
					if (treeItem[nodeTreeSelectNo].getData() instanceof LogNodeTreeGroup) {
						/* GroupI */
						if (!((LogNodeTreeGroup) treeItem[nodeTreeSelectNo]
								.getData()).getName().equals("")) {

						} else {
							nodeTreeViewer.getTree().deselectAll();
						}
					} else if (treeItem[nodeTreeSelectNo].getData() instanceof LogNodeTree) {
						((ActionLogFileView) actionLogNodeTree
								.actionLogFileView())
								.setLogNodeTree((ILogTreeNode) treeItem[nodeTreeSelectNo]
										.getData());
						((ActionLogFileRemove) actionLogNodeTree
								.actionLogFileRemove())
								.setLogNodeTree((ILogTreeNode) treeItem[nodeTreeSelectNo]
										.getData());
						manager.add(actionLogNodeTree.actionLogFileView());
						manager.add(actionLogNodeTree.actionLogFileRemove());
					} else {
						/* Groupłm[hłȂ */
						nodeTreeViewer.getTree().deselectAll();
					}
				}
			} else {
				/* TreeI */

			}
		}

	}

	/**
	 * m[hTree View̑IXi[ݒ肵܂B
	 * 
	 */
	protected void setupNodeTreeViewListener() {
		/*
		 * Node Tree ViewɃXi[o^ Xi[̏ƂẮA e[uViewɃtB[hꗗőIGg͒lƂĐݒ
		 * 
		 */
		nodeTreeViewer.addSelectionChangedListener(new LogTreeListener());
	}
}
