/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

import netjfwatcher.webalizer.gui.filtersearch.LogDataFilterInfo;
import netjfwatcher.webalizer.gui.table.plainlog.AccessLogInfoReceiveMessageQueue;
import netjfwatcher.webalizer.gui.table.plainlog.AccessLogTableTimerProcessor;
import netjfwatcher.webalizer.gui.table.sitelog.LogAlizerInfoReceiveMessageQueue;
import netjfwatcher.webalizer.gui.table.sitelog.LogAlizerTableTimerProcessor;
import netjfwatcher.webalizer.model.info.AccessAgentIPAddress;
import netjfwatcher.webalizer.model.info.AccessPlainLogInfo;
import netjfwatcher.webalizer.model.info.AccessSiteLogInfo;
import netjfwatcher.webalizer.model.info.AccessSiteLogInfoCounterAlizer;
import netjfwatcher.webalizer.model.info.LogInfoControl;
import netjfwatcher.webalizer.preference.WebalizerPreference;

import org.eclipse.swt.widgets.Table;

public class AccessLogFileParse {

	private static final int REMOTE_IP_ADDRESS_POS = 0;;

	private static final int REMOTE_USER_POS = 1;

	private static final int REMOTE_AUTH_USER = 2;

	private static final int DATE_AND_TIME_POS = 3;

	private static final int REQUEST_METHOD_POS = 5;

	private static final int HTTP_STATUS_POS = 1;

	private static final int BYTES_SENT_POS = 2;

	private static final int REFERER_POS = 3;

	private static final int AGENT_POS = 4;

	private int tableCount = 0;

	private static Logger logger;

	private AccessLogFileParse() {
		logger = Logger.getLogger(this.getClass().getName());
	}

	public void parseDirFile() {

		resetLogControlData();

		File fleDir = new File(WebalizerPreference.WEBALIZER_LOG_DIR);
		File[] fileList = fleDir.listFiles();
		if (fileList != null) {

			for (int fileCount = 0; fileCount < fileList.length; fileCount++) {

				if (fileList[fileCount].isFile()) {

					try {
						Date fileNameDate = parseFileNameDate(fileList[fileCount]);
						if (CalendarControl.getInstance()
								.isCheckCalendarFilter2(fileNameDate)) {

							parseLogFilr(true, fileList[fileCount],
									fileList[fileCount].getName());

						}

					} catch (Exception e) {
						e.printStackTrace();
						logger.warning(e.getMessage());
					}

				}

			}
			/* YSLogt@C͌ɕ͌ʂZbg */
			setAccesslogInfo();
		}

	}

	public void resetLogControlData() {
		tableCount = 0;
		AccessLogInfoReceiveMessageQueue.getInstance().clearMessageQueue();
		LogAlizerInfoReceiveMessageQueue.getInstance().clearMessageQueue();
		Table accessLogTable = AccessLogTableTimerProcessor.getInstance().getAccessLogTable();
		if (accessLogTable != null && !accessLogTable.isDisposed()) {
			accessLogTable.removeAll();
		}
		Table accessLogAlizerTable = LogAlizerTableTimerProcessor.getInstance().getAccessLogTable();
		if (accessLogAlizerTable != null && !accessLogAlizerTable.isDisposed()) {
			accessLogAlizerTable.removeAll();
		}
		AccessAgentIPAddress.getInstance().clearAgentIPLogAlizerMap();
		LogInfoControl.getInstance().cleartAccessPlainLogData();
		LogInfoControl.getInstance().cleartAccessSiteLogData();

	}

	public void parseLogFilr(boolean isCheckDate, File file, String fileName)
			throws IOException {
		if (fileName.length() >= ".gz".length()) {
			int gzPos = fileName.lastIndexOf(".gz");
			if ((gzPos + ".gz".length()) == fileName.length()) {
				proccessUnZip(isCheckDate, file);
			} else {
				parseFile(isCheckDate, file);
			}

		}
	}

	private Date parseFileNameDate(File logFfile) throws Exception {
		int n = logFfile.getName().length();

		String bodyName;
		if (logFfile.getName().regionMatches(n - 3, ".gz", 0, 3))
			bodyName = logFfile.getName().substring(0, n - 3);
		else
			bodyName = logFfile.getName();

		if (bodyName.length() < 8) {
			return null;
		}
		String dateString = bodyName.substring(bodyName.length() - 8, bodyName
				.length());

		String year = dateString.substring(0, 4);
		String month = dateString.substring(4, 6);
		String day = dateString.substring(6, 8);

		Calendar cal = Calendar.getInstance();
		cal.set(Integer.parseInt(year), Integer.parseInt(month) - 1, Integer
				.parseInt(day), 0, 0, 0);
		Date fileNameDate = cal.getTime();
		// logger.info("fileName Date : " + fileNameDate);
		return fileNameDate;

	}

	private void parseFile(boolean isCheckDate, File filename)
			throws IOException {

		FileInputStream fis = null;

		InputStreamReader isr = null;
		BufferedReader br = null;
		try {
			fis = new FileInputStream(filename);
			isr = new InputStreamReader(fis);
			br = new BufferedReader(isr);

			String lineString;

			while ((lineString = br.readLine()) != null) {
				setLogInfo(isCheckDate, lineString);
			}

		} catch (FileNotFoundException e) {
			throw e;
		} catch (IOException e) {
			throw e;
		} finally {
			if (br != null) {
				br.close();
			}
			if (isr != null) {
				isr.close();
			}

			if (fis != null) {
				fis.close();
			}
		}
	}

	public void proccessUnZip(boolean isCheckDate, File filename)
			throws IOException {

		FileInputStream fis = null;
		GZIPInputStream gzis = null;
		InputStreamReader isr = null;
		BufferedReader br = null;
		try {
			fis = new FileInputStream(filename);
			gzis = new GZIPInputStream(fis);
			isr = new InputStreamReader(gzis);
			br = new BufferedReader(isr);

			String lineString;

			while ((lineString = br.readLine()) != null) {
				setLogInfo(isCheckDate, lineString);
			}

		} catch (FileNotFoundException e) {
			throw e;
		} catch (IOException e) {
			throw e;
		} finally {
			if (br != null) {
				br.close();
			}
			if (isr != null) {
				isr.close();
			}
			if (gzis != null) {
				gzis.close();
			}
			if (fis != null) {
				fis.close();
			}
		}
	}

	private void setLogInfo(boolean isCheckDate, String lineString) {
		Pattern pattern;

		pattern = Pattern.compile("[ \t]");
		String accessIPAddress;
		String userName;
		String authUserName;
		String accessDate;
		String request;
		String status;
		String transferByte;
		String referer = "";
		String agent = "";

		String work0;
		String work1;

		String[] workItemArray;
		workItemArray = pattern.split(lineString, 4);

		accessIPAddress = workItemArray[REMOTE_IP_ADDRESS_POS];
		userName = workItemArray[REMOTE_USER_POS];
		authUserName = workItemArray[REMOTE_AUTH_USER];
		work0 = workItemArray[DATE_AND_TIME_POS];
		accessDate = work0
				.substring(work0.indexOf("[") + 1, work0.indexOf("]"));

		request = work0.substring(work0.indexOf('\"') + 1, work0.indexOf('\"',
				work0.indexOf('\"') + 1));

		work1 = work0.substring(work0.indexOf('\"', work0.indexOf('\"') + 1));
		String[] workItemArray2;
		workItemArray2 = pattern.split(work1, 5);

		status = workItemArray2[HTTP_STATUS_POS];
		transferByte = workItemArray2[BYTES_SENT_POS];

		if (workItemArray2.length >= 4) {
			referer = workItemArray2[REFERER_POS].substring(1,
					workItemArray2[REFERER_POS].length() - 1);
		}
		if (workItemArray2.length >= 5) {
			agent = workItemArray2[AGENT_POS].substring(1,
					workItemArray2[AGENT_POS].length() - 1);
		}
		Date logDate = CalendarControl.getInstance()
				.setStringToDate(accessDate);

		if (CalendarControl.getInstance().isCheckCalendarFilter(isCheckDate,
				logDate)) {

			if (FilterControl.getInstance().isCheckSearchEngineBotFilter(
					isCheckDate, accessIPAddress, request)) {
				if (!FilterControl.getInstance().isCheckHideURLFilter(
						isCheckDate, accessIPAddress, request)) {

					String domainName = "";

					AccessPlainLogInfo accessLogInfo = new AccessPlainLogInfo();
					tableCount++;
					accessLogInfo.setLogNo(Integer.toString(tableCount));
					accessLogInfo.setAccessIPAddress(accessIPAddress);
					accessLogInfo.setDomainName(domainName);
					accessLogInfo.setUserName(userName);
					accessLogInfo.setAuthUserName(authUserName);
					accessLogInfo.setAccessDate(logDate);
					accessLogInfo.setRequest(request);
					accessLogInfo.setStatus(status);
					accessLogInfo.setTransferByte(transferByte);
					accessLogInfo.setReferer(referer);
					accessLogInfo.setAgent(agent);

					if (tableCount <= LogDataFilterInfo.getInstance()
							.getLimit()) {
						AccessLogInfoReceiveMessageQueue.getInstance()
								.pushAccessLogInfo(accessLogInfo);
					}

					AccessAgentIPAddress.getInstance().putAgentIPLogAlizerMap(
							accessIPAddress, accessLogInfo);

					LogInfoControl.getInstance().addAccessPlainLogData(
							accessLogInfo);
				}
			}
		}
	}

	public void setAccesslogInfo() {
		int logCount = 0;
		Iterator it = null;

		Map accessIPAddressMap = AccessAgentIPAddress.getInstance()
				.getAgentIPAddressHashMap();

		for (it = accessIPAddressMap.keySet().iterator(); it.hasNext();) {
			String keyIPAddress = (String) it.next();

			AccessSiteLogInfoCounterAlizer siteLogAlizerInfo = (AccessSiteLogInfoCounterAlizer) accessIPAddressMap
					.get(keyIPAddress);
			logCount++;
			AccessSiteLogInfo accessSiteLogInfo = new AccessSiteLogInfo();
			accessSiteLogInfo.setLogNo(Integer.toString(logCount));
			accessSiteLogInfo.setAccessIPAddress(siteLogAlizerInfo
					.getIpAddress());
			accessSiteLogInfo.setHitCount(Long.toString(siteLogAlizerInfo
					.getHitCount()));
			accessSiteLogInfo.setFileCount(Long.toString(siteLogAlizerInfo
					.getFileCount()));
			accessSiteLogInfo.setPageCount(Long.toString(siteLogAlizerInfo
					.getPageCount()));
			accessSiteLogInfo.setVisitCount(Long.toString(siteLogAlizerInfo
					.getVisitCount()));
			accessSiteLogInfo.setByteCount(Long.toString(siteLogAlizerInfo
					.getByteCount()));

			if (logCount <= LogDataFilterInfo.getInstance().getLimit()) {
				LogAlizerInfoReceiveMessageQueue.getInstance()
						.pushAccessLogInfo(accessSiteLogInfo);
			}
			LogInfoControl.getInstance()
					.addAccessSiteLogData(accessSiteLogInfo);

		}
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static AccessLogFileParse getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final AccessLogFileParse RESOURCE = new AccessLogFileParse();
	}
}
