/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.model;

import java.util.ArrayList;

import netjfwatcher.webalizer.preference.ResourceConfigFileParse;

public class FilterControl {

	private FilterControl() {

	}

	public boolean isCheckSearchEngineBotFilter(boolean isCheck,
			String accessIPAddress, String request) {
		if (!isCheck) {
			return true;
		}
		ArrayList<String> searchEngineList = ResourceConfigFileParse
				.getInstance().getSearchEngineBotList();
		for (int i = 0; i < searchEngineList.size(); i++) {
			String checkSearchEngine = (String) searchEngineList.get(i);
			int index = accessIPAddress.indexOf(checkSearchEngine);
			if (index >= 0) {

				return false;
			}
		}
		return true;
	}

	public boolean isCheckHideURLFilter(boolean isCheck,
			String accessIPAddress, String request) {
		if (!isCheck) {
			return false;
		}
		ArrayList<String> hideURLList = ResourceConfigFileParse.getInstance()
				.getHideURLList();
		for (int i = 0; i < hideURLList.size(); i++) {
			String checkHideURL = (String) hideURLList.get(i);
			int index = request.indexOf(checkHideURL);
			if (index >= 0) {

				return true;
			}
		}
		return false;
	}

	public boolean isCheckPageTypeFilter(String accessIPAddress, String request) {

		ArrayList<String> pageTypeList = ResourceConfigFileParse.getInstance()
				.getPageTypeList();
		for (int i = 0; i < pageTypeList.size(); i++) {
			String checkPageType = (String) pageTypeList.get(i);
			int index = request.indexOf(checkPageType);
			if (index >= 0) {

				return true;
			}
		}
		return false;
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static FilterControl getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final FilterControl RESOURCE = new FilterControl();
	}
}
