/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.model.info;

import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

import netjfwatcher.webalizer.model.FilterControl;

public class AccessAgentIPAddress {

	private static final String SUCCESS_OK = "200";

	private static final int VISIT_TIME = 30 * 60 * 1000;

	private Map<String, AccessSiteLogInfoCounterAlizer> agentIPAddressHashMap;

	private AccessAgentIPAddress() {
		agentIPAddressHashMap = Collections
				.synchronizedMap(new LinkedHashMap<String, AccessSiteLogInfoCounterAlizer>());
	}

	public void clearAgentIPLogAlizerMap() {
		agentIPAddressHashMap.clear();
	}

	public void putAgentIPLogAlizerMap(String ipAddress, AccessPlainLogInfo info) {
		AccessSiteLogInfoCounterAlizer logAlizerInfo = null;
		if (agentIPAddressHashMap.containsKey(ipAddress)) {
			logAlizerInfo = (AccessSiteLogInfoCounterAlizer) agentIPAddressHashMap
					.get(ipAddress);
		} else {
			logAlizerInfo = new AccessSiteLogInfoCounterAlizer();
			logAlizerInfo.setIpAddress(ipAddress);
		}

		logAlizerInfo = addHitCount(info, logAlizerInfo);
		logAlizerInfo = addByteCount(info, logAlizerInfo);
		logAlizerInfo = addFilesCount(info, logAlizerInfo);
		logAlizerInfo = addVisitsCount(info, logAlizerInfo);
		logAlizerInfo = addPagesCount(info, logAlizerInfo);

		agentIPAddressHashMap.put(ipAddress, logAlizerInfo);

	}

	private AccessSiteLogInfoCounterAlizer addByteCount(
			AccessPlainLogInfo info,
			AccessSiteLogInfoCounterAlizer logAlizerInfo) {
		if (info.getStatus().equals(SUCCESS_OK)) {
			long byteCount = 0;
			try {
				byteCount = Long.parseLong(info.getTransferByte());
			} catch (NumberFormatException e) {
				// nothing
			}
			logAlizerInfo.addByteCount(byteCount);
		}
		return logAlizerInfo;
	}

	private AccessSiteLogInfoCounterAlizer addHitCount(AccessPlainLogInfo info,
			AccessSiteLogInfoCounterAlizer logAlizerInfo) {

		logAlizerInfo.addHitCount();
		return logAlizerInfo;
	}

	private AccessSiteLogInfoCounterAlizer addFilesCount(
			AccessPlainLogInfo info,
			AccessSiteLogInfoCounterAlizer logAlizerInfo) {
		if (info.getStatus().equals(SUCCESS_OK)) {
			logAlizerInfo.addFileCount();
		}
		return logAlizerInfo;

	}

	private AccessSiteLogInfoCounterAlizer addPagesCount(
			AccessPlainLogInfo info,
			AccessSiteLogInfoCounterAlizer logAlizerInfo) {
		if (info.getStatus().equals(SUCCESS_OK)) {
			if (FilterControl.getInstance().isCheckPageTypeFilter(
					info.getAccessIPAddress(), info.getRequest())) {
				logAlizerInfo.addPageCount();
			}
		}
		return logAlizerInfo;
	}

	private AccessSiteLogInfoCounterAlizer addVisitsCount(
			AccessPlainLogInfo info,
			AccessSiteLogInfoCounterAlizer logAlizerInfo) {

		Date visitDate = info.getAccessDate();
		Date preVisitDate = logAlizerInfo.getPreVisitDate();
		if (visitDate != null && preVisitDate != null) {
			if (visitDate.getTime() >= preVisitDate.getTime() + VISIT_TIME) {
				logAlizerInfo.addVisitCount();
			}
		} else {
			logAlizerInfo.addVisitCount();
		}
		logAlizerInfo.setPreVisitDate(visitDate);

		return logAlizerInfo;
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static AccessAgentIPAddress getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final AccessAgentIPAddress RESOURCE = new AccessAgentIPAddress();
	}

	public Map getAgentIPAddressHashMap() {
		return agentIPAddressHashMap;
	}
}
