/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.model.info;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LogInfoControl {

	private static final int LIMIT = 100000;

	private List<AccessPlainLogInfo> accessPlainLogInfoList;

	private List<AccessSiteLogInfo> accessSiteLogInfoList;

	private LogInfoControl() {
		accessPlainLogInfoList = Collections
				.synchronizedList(new ArrayList<AccessPlainLogInfo>());
		accessSiteLogInfoList = Collections
				.synchronizedList(new ArrayList<AccessSiteLogInfo>());
	}

	public void addAccessPlainLogData(AccessPlainLogInfo info) {
		if (accessPlainLogInfoList.size() < LIMIT) {
			accessPlainLogInfoList.add(info);
		}
	}

	public void addAccessSiteLogData(AccessSiteLogInfo info) {
		if (accessSiteLogInfoList.size() < LIMIT) {
			accessSiteLogInfoList.add(info);
		}
	}

	public List getAccessPlainLogData() {
		return accessPlainLogInfoList;
	}

	public List getAccessSiteLogData() {
		return accessSiteLogInfoList;
	}

	public void cleartAccessPlainLogData() {
		accessPlainLogInfoList.clear();
	}

	public void cleartAccessSiteLogData() {
		accessSiteLogInfoList.clear();
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static LogInfoControl getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final LogInfoControl RESOURCE = new LogInfoControl();
	}
}
