/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.perspective;

import netjfwatcher.webalizer.gui.filtersearch.CalendarView;
import netjfwatcher.webalizer.gui.filtersearch.FilterView;
import netjfwatcher.webalizer.gui.filtersearch.SearchView;
import netjfwatcher.webalizer.gui.table.plainlog.AccessLogTableView;
import netjfwatcher.webalizer.gui.table.sitelog.LogAlizerTableView;
import netjfwatcher.webalizer.gui.treeview.LogTreeView;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

public class WebalizerPerspective implements IPerspectiveFactory {
	public static final String ID = "netjfwatcher.webalizer.perspective.WebalizerPerspective";

	private static final float LEFT_RATIO = 0.15f;

	private static final float TABLE_VIEW_RATIO = 0.40f;

	private static final float RIGHT_RATIO = 0.77f;

	/**
	 * CAEg̏ݒs܂B
	 * 
	 * @param layout
	 *            IPageLayout
	 */
	public void createInitialLayout(IPageLayout layout) {
		layout.setEditorAreaVisible(false);

		String editorArea = layout.getEditorArea();

		/* Webalizer Log Treer[ */
		IFolderLayout left = layout.createFolder("left", IPageLayout.LEFT,
				LEFT_RATIO, editorArea);
		left.addView(LogTreeView.class.getName());

		/* Webalizer Perspective ECalendarzu */
		IFolderLayout right = layout.createFolder("right", IPageLayout.RIGHT,
				RIGHT_RATIO, editorArea);

		right.addView(CalendarView.class.getName());
		right.addView(SearchView.class.getName());
		right.addView(FilterView.class.getName());

		IFolderLayout top = layout.createFolder("top", IPageLayout.BOTTOM,
				TABLE_VIEW_RATIO, editorArea);
		top.addView(LogAlizerTableView.class.getName());
		top.addView(AccessLogTableView.class.getName());

	}
}
