/*
 * Created on 2007/03/24
 *
 *
 * Copyright(c) 2007 Yoshimasa Matsumoto
 */
package netjfwatcher.webalizer.preference;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Logger;

import netjfwatcher.webalizer.Activator;

import org.osgi.framework.Bundle;

public class ResourceConfigFileParse {
	/* Logging */
	private static Logger logger = null;

	private ArrayList<String> searchEngineBotList;

	private ArrayList<String> hideURLList;

	private ArrayList<String> pageTypeList;

	private ResourceConfigFileParse() {
		logger = Logger.getLogger(this.getClass().getName());
		searchEngineBotList = new ArrayList<String>();

		URL url = getDocument(WebalizerPreference.SEARCH_ENGINE_BOT_CONF_FILE);

		if (url != null) {
			parseURLFile(url, searchEngineBotList);
		}

		hideURLList = new ArrayList<String>();

		url = getDocument(WebalizerPreference.HIDE_URL_CONF_FILE);

		if (url != null) {
			parseURLFile(url, hideURLList);
		}

		pageTypeList = new ArrayList<String>();

		url = getDocument(WebalizerPreference.PAGE_TYPE_CONF_FILE);

		if (url != null) {
			parseURLFile(url, pageTypeList);
		}

	}

	/*
	 * t@CE͂URLԂ܂B
	 * 
	 * @param filePath t@CpX @return url URL
	 */
	private URL getDocument(String filePath) {
		URL url = null;

		Bundle bundle = Activator.getDefault().getBundle();

		// this.getClass().getClassLoader().getResource(filePath);
		url = bundle.getEntry(filePath);

		if (url == null) {
			/* bZ[W\[Xt@CȂꍇMO̎ */
			logger.severe("Not found file url : " + filePath);

			return null;
		}

		return url;
	}

	public void parseURLFile(URL url, ArrayList<String> resourceList) {
		logger = Logger.getLogger(this.getClass().getName());

		logger.info("file : " + url.getFile());

		InputStream is = null;

		try {
			is = url.openStream();
		} catch (IOException e3) {
			e3.printStackTrace();
			return;
		}

		BufferedReader buffReader = null;
		try {
			InputStreamReader ti = new InputStreamReader(is);
			buffReader = new BufferedReader(ti);

			String message;

			resourceList.clear();
			while ((message = buffReader.readLine()) != null) {

				resourceList.add(message);
			}
		} catch (FileNotFoundException e1) {
			e1.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (buffReader != null) {
				try {
					buffReader.close();
				} catch (IOException e2) {
					logger.warning(e2.getMessage());
					e2.printStackTrace();
				}
			}

			if (is != null) {
				try {
					is.close();
				} catch (IOException e2) {
					logger.warning(e2.getMessage());
					e2.printStackTrace();
				}
			}
		}
	}

	/**
	 * ̃NX̃CX^XԂ܂B<BR>
	 * iNXێĂVOgEIuWFNg Ԃ܂j<BR>
	 * 
	 * @return VOgEIuWFNgƂĂ̂̃NX CX^X
	 */
	public static ResourceConfigFileParse getInstance() {
		return SingletonResource.RESOURCE;
	}

	/**
	 * VOgEIuWFNgێNXłB<BR>
	 * 
	 */
	private static class SingletonResource {
		static final ResourceConfigFileParse RESOURCE = new ResourceConfigFileParse();
	}

	public ArrayList<String> getSearchEngineBotList() {
		return searchEngineBotList;
	}

	public ArrayList<String> getHideURLList() {
		return hideURLList;
	}

	public ArrayList<String> getPageTypeList() {
		return pageTypeList;
	}
}
