#ifndef FONT_CTRL_H
#define FONT_CTRL_H

/*
  tHg̊Ǘ
  Satofumi KAMIMURA
  $Id$
*/

#include <SDL_ttf.h>
#include "SDLResource.h"
#include <map>

using namespace std;


class FontCtrl {
  const char *fileName;
  map<int,TTF_Font*> fontResources;

  static void ttfInitialized(void);
  FontCtrl(void);
  
public:
  TTF_Font *size(int ptSize);
  SDL_Surface *createSurface(Uint16 str[], int ptSize, Uint32 color);
  SDL_Surface *createSurface(Uint16 str[], int ptSize,
			     Uint32 color, Uint32 back);
    
  FontCtrl(const char *fname);
  ~FontCtrl(void);
};

#endif /* !FONT_CTRL_H */
