#ifndef RESULT_DATA_H
#define RESULT_DATA_H

/*
  ʕ\p̃f[^Ǘ
  Satofumi KAMIMURA
  $Id$
*/

#include <SDL.h>
#include <vector>
#include <limits.h>

using namespace std;


enum ResultDataEnum {
  DELAY_MAX = INT_MAX,
};

typedef struct {
  int id;			// â̒ʂԍ
  int spentTime;		// ͂ɗv [msec]
  int pressedNum;		// Ō [hits]
  int startDelay;		// ͂Jn܂ł̎ [msec]
  int deletePressed;		// 폜L[̗p [hits]
  int kimariji;			// ܂莚̕Ԗ
  int kimarijiSubScore;		// ܂莚̂̓_
} resultData_t;


// ʕ\p̃f[^Ǘ
class ResultData {
  vector<resultData_t> result;
  int totalNum;			// f[^̑
  int totalSpentTime;		// ͂I܂ł̑
  int totalTypingTime;		// ^CsOɔ₵
  int totalPressedNum;		// Ō
  int totalMiss;		// ~X
  int startDelayTotal;		// ϒx [msec]
  int totalScore;		// _
  int kimarijiScore;		// ܂莚̑_
  int startDelayID[100];

public:
  void addData(resultData_t *data);
  void clearTotalInfo(void);
  void profile(void);
  int getDataNum(void);
  int getTotalPressedNum(void);
  int getTotalSpentTime(void);
  int getTotalMiss(void);
  int getStartDelayTotal(void);
  double getPressedNumPerMinute(void);
  void getSlowInputWakaId(int ids[], int idnums);
  int getTotalScore(void);
  int getKimarijiScore(void);
  void clearResultStruct(resultData_t *rd, int id, int kimariji);
  
  ResultData(void);
};

#endif /* !RESULT_DATA_H */
