/*
  â̊Ǘ
  Satofumi KAMIMURA
  $Id$

  UTF16 `̘ãf[^
*/

#include "wakaResource.h"
#include "hyaku.h"		// Slf[^
#include "kimariji.h"		// ܂
#include <stdlib.h>


static void splitWaka(Uint16 moji[5][9], const Uint16 rawData[]) {
  const Uint16 *wch = &rawData[0];

  for (int i = 0; i < 5; ++i) {
    int j = 0;
    do {
      moji[i][j++] = *wch;
    } while (*wch++ != 0x00);
    while (j < 9) {
      moji[i][j++] = 0x00;
    }
  }
}


// wԍ̘â̎o
wakaResource_t WakaResource::getWakaData(int id) {
  wakaResource_t waka;

  if ((id < 0) || (id > 99)) {
    throw Out_Of_Range(id);
  }

  // AǂݖɁAɕč\̂ɔzu
  waka.id = id;
  splitWaka( &waka.kanji[0], wakaData[2*id] );
  splitWaka( &waka.yomi[0], wakaData[2*id + 1] );
  waka.kimariji = kimariji[id];

  return waka;
}


// oãtÕNA
void WakaResource::clearWakaInfo(void) {

  for (int i = 0; i < 100; ++i) {
    unsortedArray[i] = i;
    kimarijiArray[i] = i;
  }
  unsorted_index = 0;
  kimariji_index = 0;
}


static void swap(int *a, int *b) {
  int t = *a;
  *a = *b;
  *b = t;
}


// â̕ёւ
void WakaResource::unsort(void) {

  clearWakaInfo();

  srand(SDL_GetTicks());
  for (int i = 0; i < 200; ++i) {
    int a = (int)(100.0 * rand() / (RAND_MAX + 1.0));
    int b = (int)(100.0 * rand() / (RAND_MAX + 1.0));

    swap(&unsortedArray[a], &unsortedArray[b]);
  }
}


// â̕𐔒lĕԂ
Uint32 WakaResource::wakaStrValue(int id) {
  Uint32 value = 0;
  
  for (int i = 0; i < 4; ++i) {
    value <<= 8;
    // '','' 𓯈ꎋ
    value |= (wakaData[2*id + 1][i] == 0x3092) ?
      0x4a : wakaData[2*id + 1][i] & 0xff;
  }
  return value;
}


// ܂菇ɕёւ
void WakaResource::kimarijiSort(void) {
  clearWakaInfo();
  
  if (kimarijiSorted) {
    return;
  }

  for (int i = 0; i < 100; ++i) {
    Uint32 wstr = wakaStrValue(kimarijiArray[i]);
    int wch_index = i;
    for (int j = i+1; j < 100; ++j) {
      if (wstr < wakaStrValue(kimarijiArray[j])) {
	wstr = wakaStrValue(kimarijiArray[j]);
	wch_index = j;
      }
    }
    swap(&kimarijiArray[i], &kimarijiArray[wch_index]);
  }
  kimarijiSorted = true;
}


// w肵âw菇Ԉȓɑ݂
void WakaResource::setLearnIdSet(int id, int width) {
  // wID̘â݂ʒu unsortedArray[] To
  int index;
  for (index = 0; index < 100; ++index) {
    if (unsortedArray[index] == id) {
      break;
    }
  }
    
  // w肳ꂽ width ȓ̘âƓւ
  int swapId = (int)(1.0 * width * rand() / (RAND_MAX + 1.0));
  swap(&unsortedArray[index], &unsortedArray[swapId]);
}


// ёւâ̎o
wakaResource_t WakaResource::getUnsortedWakaInfo(void) {

  if (unsorted_index > 99) {
    throw Out_Of_Range(unsorted_index);
  }
  return getWakaData(unsortedArray[unsorted_index++]);
}


// ܂莚ɘâ̎o
int WakaResource::getKimarijiOrderWakaId(void) {

  if (kimariji_index > 99) {
    throw Out_Of_Range(kimariji_index);
  }
  
  return kimarijiArray[kimariji_index++];
}


// ܂莚̃\[gς݂ۂtOǗ
WakaResource::WakaResource(void) : kimarijiSorted(false) {
}
