// Config.cpp: implementation of the CConfig class.
//
//////////////////////////////////////////////////////////////////////

/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#include "stdafx.h"
#include "NotesAntiSpam.h"
#include "Config.h"
#include <Dbghelp.h>
#include "dspam/libdspam.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CConfig::CConfig()
: m_schedule(0)
{
	HKEY    hKey;
	DWORD   valueSize;
	DWORD   valueType;
	LONG    regRetVal;
	char*   value;
	int     intValue;
//	double  doubleValue;
	int     i;
	CString key;
	CString tempStr;

	// Default-Values
	m_debug=FALSE;
	m_sso=FALSE;
	m_schedule=60000;
	m_dSpamFilter=TRUE;
	m_dnsblFilter=FALSE;
	m_informNewMail=TRUE;
	m_dSpam_trainMode=DST_TEFT;

	// Read the Lotus-Notes Directory
	regRetVal=RegOpenKeyEx(HKEY_LOCAL_MACHINE,
	                       "Software\\Lotus\\Notes",
					       0,
					       KEY_QUERY_VALUE,
					       &hKey);
	if(regRetVal==ERROR_SUCCESS)
	{
		// Name
		valueType=REG_SZ;
		if(RegQueryValueEx(hKey,
		                   "Path",
						   NULL,
						   &valueType,
						   NULL,
						   &valueSize)==ERROR_SUCCESS)
		{
			value=new char[valueSize];
			if(RegQueryValueEx(hKey,
			                   "Path",
							   NULL,
							   &valueType,
							   (LPBYTE)value,
							   &valueSize)==ERROR_SUCCESS)
			{
				m_notesPath=value;
			}
			delete value;
		}
		// Close Session-Key
		RegCloseKey(hKey);
	}
	m_notesPath+="\\";

	// Read Filename of notes.ini
	m_notesIniFilename=GetLNIniFilename();

	// Read Machine-Registry
	regRetVal=RegOpenKeyEx(HKEY_LOCAL_MACHINE,
	                       "Software\\NotesAntiSpam",
					       0,
					       KEY_QUERY_VALUE,
					       &hKey);
	if(regRetVal==ERROR_SUCCESS)
	{
		// Name
		valueType=REG_SZ;
		if(RegQueryValueEx(hKey,
		                   "Install_Dir",
						   NULL,
						   &valueType,
						   NULL,
						   &valueSize)==ERROR_SUCCESS)
		{
			value=new char[valueSize];
			if(RegQueryValueEx(hKey,
			                   "Install_Dir",
							   NULL,
							   &valueType,
							   (LPBYTE)value,
							   &valueSize)==ERROR_SUCCESS)
			{
				m_instpath=value;
			}
			delete value;
		}
		// Close Session-Key
		RegCloseKey(hKey);
	}

	/*
	 * Read User-Registry
	 */
	// Build User-Path
	key="SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
	// get Registry-Key
	regRetVal=RegOpenKeyEx(HKEY_CURRENT_USER,
	                       key,
					       0,
					       KEY_QUERY_VALUE,
					       &hKey);
	if(regRetVal==ERROR_SUCCESS)
	{
		// MailBoxServer
		valueType=REG_SZ;
		if(RegQueryValueEx(hKey,
		                   "AppData",
						   NULL,
						   &valueType,
						   NULL,
						   &valueSize)==ERROR_SUCCESS)
		{
			value=new char[valueSize];
			if(RegQueryValueEx(hKey,
			                   "AppData",
							   NULL,
							   &valueType,
							   (LPBYTE)value,
							   &valueSize)==ERROR_SUCCESS)
			{
				tempStr=value;
			}
			delete value;
		}

		// Close User-Key
		RegCloseKey(hKey);
	}
	m_userpath=tempStr+"\\NotesAntiSpam\\";
	MakeSureDirectoryPathExists(m_userpath);

	// Application-Specific
	key="SOFTWARE\\Thomas Kriener\\NotesAntiSpam";
	// get Registry-Key
	regRetVal=RegOpenKeyEx(HKEY_CURRENT_USER,
	                       key,
					       0,
					       KEY_QUERY_VALUE,
					       &hKey);
	if(regRetVal==ERROR_SUCCESS)
	{
		// Debug
		valueType=REG_DWORD;
		valueSize=sizeof(intValue);
		if(RegQueryValueEx(hKey,
		                   "Debug",
						   NULL,
						   &valueType,
						   (LPBYTE)&intValue,
						   &valueSize)==ERROR_SUCCESS)
		{
			m_debug=intValue;
		}
		// SSO
		valueType=REG_DWORD;
		valueSize=sizeof(intValue);
		if(RegQueryValueEx(hKey,
		                   "SSO",
						   NULL,
						   &valueType,
						   (LPBYTE)&intValue,
						   &valueSize)==ERROR_SUCCESS)
		{
			m_sso=intValue;
		}
		// InformNewMail
		valueType=REG_DWORD;
		valueSize=sizeof(intValue);
		if(RegQueryValueEx(hKey,
		                   "InformNewMail",
						   NULL,
						   &valueType,
						   (LPBYTE)&intValue,
						   &valueSize)==ERROR_SUCCESS)
		{
			m_informNewMail=intValue;
		}
		// Schedule
		valueType=REG_DWORD;
		valueSize=sizeof(intValue);
		if(RegQueryValueEx(hKey,
		                   "Schedule",
						   NULL,
						   &valueType,
						   (LPBYTE)&intValue,
						   &valueSize)==ERROR_SUCCESS)
		{
			m_schedule=intValue;
		}
		// DSpamFilter
		valueType=REG_DWORD;
		valueSize=sizeof(intValue);
		if(RegQueryValueEx(hKey,
		                   "DSpamFilter",
						   NULL,
						   &valueType,
						   (LPBYTE)&intValue,
						   &valueSize)==ERROR_SUCCESS)
		{
			m_dSpamFilter=intValue;
		}
		// DNSBLFilter
		valueType=REG_DWORD;
		valueSize=sizeof(intValue);
		if(RegQueryValueEx(hKey,
		                   "DNSBLFilter",
						   NULL,
						   &valueType,
						   (LPBYTE)&intValue,
						   &valueSize)==ERROR_SUCCESS)
		{
			m_dnsblFilter=intValue;
		}

		// MailBox
		valueType=REG_SZ;
		if(RegQueryValueEx(hKey,
		                   "MailBox",
						   NULL,
						   &valueType,
						   NULL,
						   &valueSize)==ERROR_SUCCESS)
		{
			value=new char[valueSize];
			if(RegQueryValueEx(hKey,
			                   "MailBox",
							   NULL,
							   &valueType,
							   (LPBYTE)value,
							   &valueSize)==ERROR_SUCCESS)
			{
				m_mailBox=value;
			}
			delete value;
		}

		// MailBoxServer
		valueType=REG_SZ;
		if(RegQueryValueEx(hKey,
		                   "MailBoxServer",
						   NULL,
						   &valueType,
						   NULL,
						   &valueSize)==ERROR_SUCCESS)
		{
			value=new char[valueSize];
			if(RegQueryValueEx(hKey,
			                   "MailBoxServer",
							   NULL,
							   &valueType,
							   (LPBYTE)value,
							   &valueSize)==ERROR_SUCCESS)
			{
				m_mailBoxServer=value;
			}
			delete value;
		}

		// DSpam-TrainMode
		valueType=REG_DWORD;
		valueSize=sizeof(intValue);
		if(RegQueryValueEx(hKey,
		                   "DSpam-TrainMode",
						   NULL,
						   &valueType,
						   (LPBYTE)&intValue,
						   &valueSize)==ERROR_SUCCESS)
		{
			m_dSpam_trainMode=intValue;
		}

		// Close User-Key
		RegCloseKey(hKey);
	}

	/*
	 * Read DNS-Blacklists
	 */
	i=0;
	do
	{
		CDnsblEntry actDnsblEntry;
		key.Format("SOFTWARE\\Thomas Kriener\\NotesAntiSpam\\DNSBL%i",i);
		// get Last Date from Registry
		regRetVal=RegOpenKeyEx(HKEY_CURRENT_USER,
		                       key,
						       0,
						       KEY_QUERY_VALUE,
						       &hKey);

		if(regRetVal==ERROR_SUCCESS)
		{
			// Name
			valueType=REG_SZ;
			if(RegQueryValueEx(hKey,
			                   "Name",
							   NULL,
							   &valueType,
							   NULL,
							   &valueSize)==ERROR_SUCCESS)
			{
				value=new char[valueSize];
				if(RegQueryValueEx(hKey,
				                   "Name",
								   NULL,
								   &valueType,
								   (LPBYTE)value,
								   &valueSize)==ERROR_SUCCESS)
				{
					actDnsblEntry.m_name=value;
				}
				delete value;
			}

			// Domain
			valueType=REG_SZ;
			if(RegQueryValueEx(hKey,
			                   "Domain",
							   NULL,
							   &valueType,
							   NULL,
							   &valueSize)==ERROR_SUCCESS)
			{
				value=new char[valueSize];
				if(RegQueryValueEx(hKey,
				                   "Domain",
								   NULL,
								   &valueType,
								   (LPBYTE)value,
								   &valueSize)==ERROR_SUCCESS)
				{
					actDnsblEntry.m_domain=value;
				}
				delete value;
			}

			// URL
			valueType=REG_SZ;
			if(RegQueryValueEx(hKey,
			                   "URL",
							   NULL,
							   &valueType,
							   NULL,
							   &valueSize)==ERROR_SUCCESS)
			{
				value=new char[valueSize];
				if(RegQueryValueEx(hKey,
				                   "URL",
								   NULL,
								   &valueType,
								   (LPBYTE)value,
								   &valueSize)==ERROR_SUCCESS)
				{
					actDnsblEntry.m_url=value;
				}
				delete value;
			}

			// Comment
			valueType=REG_SZ;
			if(RegQueryValueEx(hKey,
			                   "Comment",
							   NULL,
							   &valueType,
							   NULL,
							   &valueSize)==ERROR_SUCCESS)
			{
				value=new char[valueSize];
				if(RegQueryValueEx(hKey,
				                   "Comment",
								   NULL,
								   &valueType,
								   (LPBYTE)value,
								   &valueSize)==ERROR_SUCCESS)
				{
					actDnsblEntry.m_comment=value;
				}
				delete value;
			}

			// Add Entry to search-list
			if(actDnsblEntry.m_name!="")
				m_dnsbl.Add(actDnsblEntry);

			// Close Reg-Key
			RegCloseKey(hKey);
		}

		// Try next Entry
		i++;
	} while (regRetVal==ERROR_SUCCESS);

	/*
	 * If no dnsbl in Registry load default
	 */
	if(m_dnsbl.GetSize()==0)
	{
		CDnsblEntry newEntry;

		newEntry.m_name="SpamCop";
		newEntry.m_domain=".bl.spamcop.net";
		newEntry.m_url="http://www.spamcop.net/";
		newEntry.m_comment="SpamCop is fairly agressive. That is, they flag lots of spam, but are also known for accidentally flagging legitimate mail, particularly mailing-lists.";
		m_dnsbl.Add(newEntry);

   		newEntry.m_name="ORDB";
		newEntry.m_domain=".relays.ordb.org";
		newEntry.m_url="http://www.ordb.org/";
		newEntry.m_comment="ORDB.org is the Open Relay Database. ORDB.org is a non-profit organisation which stores a IP-addresses of verified open SMTP relays.";
		m_dnsbl.Add(newEntry);

//		newEntry.m_name="MAPS-Blackholes";
//		newEntry.m_domain=".blackholes.mail-abuse.org";
//		newEntry.m_url="http://www.mail-abuse.org/rbl/";
//		newEntry.m_comment="IP addresses in the RBLSM may be a multi-hop (multiple IP) open relay, a spam source, or a spam support service (e.g., a webserver or nameserver).";
//		m_dnsbl.Add(newEntry);
		
//		newEntry.m_name="MAPS-Relays";
//		newEntry.m_domain=".relays.mail-abuse.org";
//		newEntry.m_url="http://work-rss.mail-abuse.org/rss/";
//		newEntry.m_comment="MAPSSM Relay Spam Stopper  (RSSSM) is a queryable DNS-based database of spam-relaying mail servers.";
//		m_dnsbl.Add(newEntry);

		// Add K.OHMI
   		newEntry.m_name="dsbl";
		newEntry.m_domain=".list.dsbl.org";
		newEntry.m_url="http://dsbl.org/";
		newEntry.m_comment="Distributed Server Boycott List";
		m_dnsbl.Add(newEntry);

		// Add K.OHMI
   		newEntry.m_name="SORBS";
		newEntry.m_domain=".dnsbl.sorbs.net";
		newEntry.m_url="http://www.dnsbl.sorbs.net/";
		newEntry.m_comment="Spam & Open Relay Blocking System";
		m_dnsbl.Add(newEntry);

	}

	/*
	 * Read Whitelist
	 */
	i=0;
	do
	{
		CWhitelistEntry actWhitelistEntry;
		key.Format("SOFTWARE\\Thomas Kriener\\NotesAntiSpam\\Whitelist%i",i);
		// get Last Date from Registry
		regRetVal=RegOpenKeyEx(HKEY_CURRENT_USER,
		                       key,
						       0,
						       KEY_QUERY_VALUE,
						       &hKey);

		if(regRetVal==ERROR_SUCCESS)
		{
			// Name
			valueType=REG_SZ;
			if(RegQueryValueEx(hKey,
			                   "Name",
							   NULL,
							   &valueType,
							   NULL,
							   &valueSize)==ERROR_SUCCESS)
			{
				value=new char[valueSize];
				if(RegQueryValueEx(hKey,
				                   "Name",
								   NULL,
								   &valueType,
								   (LPBYTE)value,
								   &valueSize)==ERROR_SUCCESS)
				{
					actWhitelistEntry.m_name=value;
				}
				delete value;
			}

			// Address
			valueType=REG_SZ;
			if(RegQueryValueEx(hKey,
			                   "Address",
							   NULL,
							   &valueType,
							   NULL,
							   &valueSize)==ERROR_SUCCESS)
			{
				value=new char[valueSize];
				if(RegQueryValueEx(hKey,
				                   "Address",
								   NULL,
								   &valueType,
								   (LPBYTE)value,
								   &valueSize)==ERROR_SUCCESS)
				{
					actWhitelistEntry.m_address=value;
				}
				delete value;
			}

			// Add Entry to search-list
			if(actWhitelistEntry.m_name!="")
				m_whitelist.Add(actWhitelistEntry);

			// Close Reg-Key
			RegCloseKey(hKey);
		}

		// Try next Whitelist-Entry
		i++;
	} while (regRetVal==ERROR_SUCCESS);
}

CConfig::~CConfig()
{
}

void CConfig::SaveConfig()
{
	HKEY    hKey;
	DWORD   valueSize;
	DWORD   valueType;
	CString key;
	LONG    regRetVal;
	int     intValue;
//	double  doubleValue;
	int     i;

	key="SOFTWARE\\Thomas Kriener\\NotesAntiSpam";
	// open Key with write-rights
	if(RegCreateKeyEx(HKEY_CURRENT_USER,
	                  key,
					  0,
					  "CLASS",
					  REG_OPTION_NON_VOLATILE,
					  KEY_WRITE,
					  NULL,
					  &hKey,
					  NULL)==ERROR_SUCCESS)
	{
		// Debug
		valueType=REG_DWORD;
		valueSize=sizeof(intValue);
		intValue=m_debug;
		if(RegSetValueEx(hKey,
		                 "Debug",
						 NULL,
						 valueType,
						 (LPBYTE)&intValue,
						 valueSize)!=ERROR_SUCCESS)
		{
			AfxMessageBox(IDS_UNABLETOWRITEREG,MB_ICONERROR|MB_OK);
			return;
		}
		// SSO
		valueType=REG_DWORD;
		valueSize=sizeof(intValue);
		intValue=m_sso;
		if(RegSetValueEx(hKey,
		                 "SSO",
						 NULL,
						 valueType,
						 (LPBYTE)&intValue,
						 valueSize)!=ERROR_SUCCESS)
		{
			AfxMessageBox(IDS_UNABLETOWRITEREG,MB_ICONERROR|MB_OK);
			return;
		}
		// InformNewMail
		valueType=REG_DWORD;
		valueSize=sizeof(intValue);
		intValue=m_informNewMail;
		if(RegSetValueEx(hKey,
		                 "InformNewMail",
						 NULL,
						 valueType,
						 (LPBYTE)&intValue,
						 valueSize)!=ERROR_SUCCESS)
		{
			AfxMessageBox(IDS_UNABLETOWRITEREG,MB_ICONERROR|MB_OK);
			return;
		}
		// Schedule
		valueType=REG_DWORD;
		valueSize=sizeof(intValue);
		intValue=m_schedule;
		if(RegSetValueEx(hKey,
		                 "Schedule",
						 NULL,
						 valueType,
						 (LPBYTE)&intValue,
						 valueSize)!=ERROR_SUCCESS)
		{
			AfxMessageBox(IDS_UNABLETOWRITEREG,MB_ICONERROR|MB_OK);
			return;
		}
		// DSpamFilter
		valueType=REG_DWORD;
		valueSize=sizeof(intValue);
		intValue=m_dSpamFilter;
		if(RegSetValueEx(hKey,
		                 "DSpamFilter",
						 NULL,
						 valueType,
						 (LPBYTE)&intValue,
						 valueSize)!=ERROR_SUCCESS)
		{
			AfxMessageBox(IDS_UNABLETOWRITEREG,MB_ICONERROR|MB_OK);
			return;
		}
		// DNSBLFilter
		valueType=REG_DWORD;
		valueSize=sizeof(intValue);
		intValue=m_dnsblFilter;
		if(RegSetValueEx(hKey,
		                 "DNSBLFilter",
						 NULL,
						 valueType,
						 (LPBYTE)&intValue,
						 valueSize)!=ERROR_SUCCESS)
		{
			AfxMessageBox(IDS_UNABLETOWRITEREG,MB_ICONERROR|MB_OK);
			return;
		}

		// MailBox
		valueSize=m_mailBox.GetLength()+1;
		valueType=REG_SZ;
		if(RegSetValueEx(hKey,
		                 "MailBox",
						 NULL,
						 valueType,
						 (LPBYTE)(LPCSTR)m_mailBox,
						 valueSize)!=ERROR_SUCCESS)
		{
			AfxMessageBox(IDS_UNABLETOWRITEREG,MB_ICONERROR|MB_OK);
			return;
		}

		// MailBoxServer
		valueSize=m_mailBoxServer.GetLength()+1;
		valueType=REG_SZ;
		if(RegSetValueEx(hKey,
		                 "MailBoxServer",
						 NULL,
						 valueType,
						 (LPBYTE)(LPCSTR)m_mailBoxServer,
						 valueSize)!=ERROR_SUCCESS)
		{
			AfxMessageBox(IDS_UNABLETOWRITEREG,MB_ICONERROR|MB_OK);
			return;
		}

		// DSpam-TrainMode
		valueType=REG_DWORD;
		valueSize=sizeof(intValue);
		intValue=m_dSpam_trainMode;
		if(RegSetValueEx(hKey,
		                 "DSpam-TrainMode",
						 NULL,
						 valueType,
						 (LPBYTE)&intValue,
						 valueSize)!=ERROR_SUCCESS)
		{
			AfxMessageBox(IDS_UNABLETOWRITEREG,MB_ICONERROR|MB_OK);
			return;
		}


		// Close Key
		RegCloseKey(hKey);
	}
	else
	{
		AfxMessageBox(IDS_UNABLETOWRITEREG,MB_ICONERROR|MB_OK);
		return;
	}
	/*
	 * DNS-Blacklists
	 */
	for(i=0; i<m_dnsbl.GetSize(); i++)
	{
		CDnsblEntry actDnsblEntry=m_dnsbl[i];
	
		key.Format("SOFTWARE\\Thomas Kriener\\NotesAntiSpam\\DNSBL%i",i);
		// open Key with write-rights
		if(RegCreateKeyEx(HKEY_CURRENT_USER,
		                  key,
						  0,
						  "CLASS",
						  REG_OPTION_NON_VOLATILE,
						  KEY_WRITE,
						  NULL,
						  &hKey,
						  NULL)==ERROR_SUCCESS)
		{

			// Name
			valueSize=actDnsblEntry.m_name.GetLength()+1;
			valueType=REG_SZ;
			if(RegSetValueEx(hKey,
			                 "Name",
							 NULL,
							 valueType,
							 (LPBYTE)(LPCSTR)actDnsblEntry.m_name,
							 valueSize)!=ERROR_SUCCESS)
			{
				AfxMessageBox(IDS_UNABLETOWRITEREG,MB_ICONERROR|MB_OK);
				return;
			}
			
			// Domain
			valueSize=actDnsblEntry.m_domain.GetLength()+1;
			valueType=REG_SZ;
			if(RegSetValueEx(hKey,
			                 "Domain",
							 NULL,
							 valueType,
							 (LPBYTE)(LPCSTR)actDnsblEntry.m_domain,
							 valueSize)!=ERROR_SUCCESS)
			{
				AfxMessageBox(IDS_UNABLETOWRITEREG,MB_ICONERROR|MB_OK);
				return;
			}

			// URL
			valueSize=actDnsblEntry.m_url.GetLength()+1;
			valueType=REG_SZ;
			if(RegSetValueEx(hKey,
			                 "URL",
							 NULL,
							 valueType,
							 (LPBYTE)(LPCSTR)actDnsblEntry.m_url,
							 valueSize)!=ERROR_SUCCESS)
			{
				AfxMessageBox(IDS_UNABLETOWRITEREG,MB_ICONERROR|MB_OK);
				return;
			}

			// Comment
			valueSize=actDnsblEntry.m_comment.GetLength()+1;
			valueType=REG_SZ;
			if(RegSetValueEx(hKey,
			                 "Comment",
							 NULL,
							 valueType,
							 (LPBYTE)(LPCSTR)actDnsblEntry.m_comment,
							 valueSize)!=ERROR_SUCCESS)
			{
				AfxMessageBox(IDS_UNABLETOWRITEREG,MB_ICONERROR|MB_OK);
				return;
			}

			RegCloseKey(hKey);
		}
		else
		{
			AfxMessageBox(IDS_UNABLETOWRITEREG,MB_ICONERROR|MB_OK);
			return;
		}
	}

	// Delete old Entries
	do
	{
		key.Format("SOFTWARE\\Thomas Kriener\\NotesAntiSpam\\DNSBL%i",i);
		// get Last Date from Registry
		regRetVal=RegOpenKeyEx(HKEY_CURRENT_USER,
		                       key,
						       0,
						       KEY_QUERY_VALUE,
						       &hKey);
		RegCloseKey(hKey);

		if(regRetVal==ERROR_SUCCESS)
		{
			RegDeleteKey(HKEY_CURRENT_USER, key);
		}

		// Try next Entry
		i++;
	} while (regRetVal==ERROR_SUCCESS);

	/*
	 * Whitelists
	 */
	for(i=0; i<m_whitelist.GetSize(); i++)
	{
		CWhitelistEntry actWhitelistEntry=m_whitelist[i];
	
		key.Format("SOFTWARE\\Thomas Kriener\\NotesAntiSpam\\Whitelist%i",i);
		// open Key with write-rights
		if(RegCreateKeyEx(HKEY_CURRENT_USER,
		                  key,
						  0,
						  "CLASS",
						  REG_OPTION_NON_VOLATILE,
						  KEY_WRITE,
						  NULL,
						  &hKey,
						  NULL)==ERROR_SUCCESS)
		{

			// Name
			valueSize=actWhitelistEntry.m_name.GetLength()+1;
			valueType=REG_SZ;
			if(RegSetValueEx(hKey,
			                 "Name",
							 NULL,
							 valueType,
							 (LPBYTE)(LPCSTR)actWhitelistEntry.m_name,
							 valueSize)!=ERROR_SUCCESS)
			{
				AfxMessageBox(IDS_UNABLETOWRITEREG,MB_ICONERROR|MB_OK);
				return;
			}
			
			// Address
			valueSize=actWhitelistEntry.m_address.GetLength()+1;
			valueType=REG_SZ;
			if(RegSetValueEx(hKey,
			                 "Address",
							 NULL,
							 valueType,
							 (LPBYTE)(LPCSTR)actWhitelistEntry.m_address,
							 valueSize)!=ERROR_SUCCESS)
			{
				AfxMessageBox(IDS_UNABLETOWRITEREG,MB_ICONERROR|MB_OK);
				return;
			}

			RegCloseKey(hKey);
		}
		else
		{
			AfxMessageBox(IDS_UNABLETOWRITEREG,MB_ICONERROR|MB_OK);
			return;
		}
	}

	// Delete old Entries
	do
	{
		key.Format("SOFTWARE\\Thomas Kriener\\NotesAntiSpam\\Whitelist%i",i);
		// get Last Date from Registry
		regRetVal=RegOpenKeyEx(HKEY_CURRENT_USER,
		                       key,
						       0,
						       KEY_QUERY_VALUE,
						       &hKey);
		RegCloseKey(hKey);

		if(regRetVal==ERROR_SUCCESS)
		{
			RegDeleteKey(HKEY_CURRENT_USER, key);
		}

		// Try next Entry
		i++;
	} while (regRetVal==ERROR_SUCCESS);

}

CString CConfig::GetLNIniFilename()
{
	HKEY    hKey;
	DWORD   valueSize;
	DWORD   valueType;
	CString key;
	LONG    regRetVal;
	int     intValue;
	char*   value;
	CString retVal;
	int     multiUser=0;

	/*
	 * Check if Notes is installed with Multiuser
	 */
	regRetVal=RegOpenKeyEx(HKEY_LOCAL_MACHINE,
	                       "Software\\Lotus\\Notes",
					       0,
					       KEY_QUERY_VALUE,
					       &hKey);
	if(regRetVal==ERROR_SUCCESS)
	{
		// MultiUser
		valueType=REG_DWORD;
		valueSize=sizeof(intValue);
		if(RegQueryValueEx(hKey,
		                   "MultiUser",
						   NULL,
						   &valueType,
						   (LPBYTE)&intValue,
						   &valueSize)==ERROR_SUCCESS)
		{
			multiUser=intValue;
		}
		else
		{
			multiUser=0;
		}
		// Close Session-Key
		RegCloseKey(hKey);
	}

	if(multiUser==0)
	{
		// If in Single-User-Mode use the default ini in the Notes-Directory
		retVal=m_notesPath+"\\notes.ini";
	}
	else
	{
		/*
		 *Read the Lotus-Notes INI-Filename for Lotus Notes 6.0
		 */
		regRetVal=RegOpenKeyEx(HKEY_CURRENT_USER,
		                       "Software\\Lotus\\Notes\\6.0",
					           0,
					           KEY_QUERY_VALUE,
					           &hKey);
		if(regRetVal==ERROR_SUCCESS)
		{
			// Path
			valueType=REG_SZ;
			if(RegQueryValueEx(hKey,
		                       "NotesIniPath",
						       NULL,
						       &valueType,
						       NULL,
						       &valueSize)==ERROR_SUCCESS)
			{
				value=new char[valueSize];
				if(RegQueryValueEx(hKey,
			                       "NotesIniPath",
							       NULL,
							       &valueType,
							       (LPBYTE)value,
							       &valueSize)==ERROR_SUCCESS)
				{
					retVal=value;
				}
				delete value;
			}
			// Close Session-Key
			RegCloseKey(hKey);
		}

		// if retval empty we might have Notes 5.0
		if(retVal=="")
		{
			/*
			 *Read the Lotus-Notes INI-Filename for Lotus Notes 5.0
			 */
			regRetVal=RegOpenKeyEx(HKEY_CURRENT_USER,
		                           "Software\\Lotus\\Notes\\5.0",
					               0,
					               KEY_QUERY_VALUE,
					               &hKey);
			if(regRetVal==ERROR_SUCCESS)
			{
				// Path
				valueType=REG_SZ;
				if(RegQueryValueEx(hKey,
		                           "NotesIniPath",
						           NULL,
						           &valueType,
						           NULL,
						           &valueSize)==ERROR_SUCCESS)
				{
					value=new char[valueSize];
					if(RegQueryValueEx(hKey,
			                           "NotesIniPath",
							           NULL,
							           &valueType,
							           (LPBYTE)value,
							           &valueSize)==ERROR_SUCCESS)
					{
						retVal=value;
					}
					delete value;
				}
				// Close Session-Key
				RegCloseKey(hKey);
			}
		}
	}

	if(retVal=="") retVal=m_notesPath+"\\notes.ini";

	return retVal;
}
