// ConfigDnsblDlg.cpp : implementation file
//

/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#include "stdafx.h"
#include "NotesAntiSpam.h"
#include "ConfigDnsblDlg.h"
#include "ConfigDnsblEntryDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConfigDnsblDlg dialog


CConfigDnsblDlg::CConfigDnsblDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CConfigDnsblDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConfigDnsblDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	myApp=(CNotesAntiSpamApp*)AfxGetApp();
}


void CConfigDnsblDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConfigDnsblDlg)
	DDX_Control(pDX, IDC_DNSBL_LIST, m_dnsblList);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConfigDnsblDlg, CDialog)
	//{{AFX_MSG_MAP(CConfigDnsblDlg)
	ON_BN_CLICKED(IDC_BUTTON_UP, OnButtonUp)
	ON_BN_CLICKED(IDC_BUTTON_DOWN, OnButtonDown)
	ON_NOTIFY(NM_DBLCLK, IDC_DNSBL_LIST, OnDblclkDnsblList)
	ON_BN_CLICKED(IDC_BUTTON_NEW, OnButtonNew)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, OnButtonDelete)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigDnsblDlg message handlers

BOOL CConfigDnsblDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// Set Header of Listbox
	m_dnsblList.InsertColumn(0,"Name",LVCFMT_LEFT,100, 0);
	m_dnsblList.InsertColumn(1,"Domain", LVCFMT_LEFT,180, 1);
	m_dnsblList.InsertColumn(2,"URL",  LVCFMT_LEFT,180, 2);
	m_dnsblList.InsertColumn(3,"Comment",LVCFMT_LEFT,320, 3);

	// select full rows
	m_dnsblList.SetExtendedStyle(LVS_EX_FULLROWSELECT);

	// fill Listbox
	for(int i=myApp->m_config.m_dnsbl.GetSize()-1; i>=0; i--)
	{
		addListEntry(myApp->m_config.m_dnsbl[i]);

	}
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

int CConfigDnsblDlg::addListEntry(const CDnsblEntry &entry)
{
	int     item;
	CString itemText;
	CString tempStr;

	item=m_dnsblList.InsertItem(LVIF_TEXT | LVIF_PARAM, 0, entry.m_name, 0, 0, 0, (LPARAM )0);
	m_dnsblList.SetItemText(item,0,entry.m_name);
	m_dnsblList.SetItemText(item,1,entry.m_domain);
	m_dnsblList.SetItemText(item,2,entry.m_url);
	m_dnsblList.SetItemText(item,3,entry.m_comment);

	return item;
}

CDnsblEntry CConfigDnsblDlg::getListEntry(int item)
{
	CDnsblEntry retVal;

	retVal.m_name=m_dnsblList.GetItemText(item,0);
	retVal.m_domain=m_dnsblList.GetItemText(item,1);
	retVal.m_url=m_dnsblList.GetItemText(item,2);
	retVal.m_comment=m_dnsblList.GetItemText(item,3);

	return retVal;
}

void CConfigDnsblDlg::setListEntry(int item,const CDnsblEntry &entry)
{
	m_dnsblList.SetItemText(item,0,entry.m_name);
	m_dnsblList.SetItemText(item,1,entry.m_domain);
	m_dnsblList.SetItemText(item,2,entry.m_url);
	m_dnsblList.SetItemText(item,3,entry.m_comment);
}

void CConfigDnsblDlg::OnOK() 
{
	CDnsblEntry newEntry;

	// flush list
	myApp->m_config.m_dnsbl.RemoveAll();

	// fill list with items
	for(int i=0; i<m_dnsblList.GetItemCount(); i++)
	{
		newEntry=getListEntry(i);
		myApp->m_config.m_dnsbl.Add(newEntry);
	}

	/*
	 * Save Config
	 */
	myApp->m_config.SaveConfig();
	
	CDialog::OnOK();
}


void CConfigDnsblDlg::OnButtonUp() 
{
	int itemPos;
	CDnsblEntry entry;

	itemPos=m_dnsblList.GetSelectionMark();
	if(itemPos>0)
	{
		entry.m_name=m_dnsblList.GetItemText(itemPos,0);
		entry.m_domain=m_dnsblList.GetItemText(itemPos,1);
		entry.m_url=m_dnsblList.GetItemText(itemPos,2);
		entry.m_comment=m_dnsblList.GetItemText(itemPos,3);
		m_dnsblList.DeleteItem(itemPos);

		itemPos=m_dnsblList.InsertItem(LVIF_TEXT | LVIF_PARAM, itemPos-1, entry.m_name, 0, 0, 0, (LPARAM )0);
		m_dnsblList.SetItemText(itemPos,0,entry.m_name);
		m_dnsblList.SetItemText(itemPos,1,entry.m_domain);
		m_dnsblList.SetItemText(itemPos,2,entry.m_url);
		m_dnsblList.SetItemText(itemPos,3,entry.m_comment);

	}
	m_dnsblList.SetSelectionMark(itemPos);
	m_dnsblList.SetItemState(itemPos, LVIS_SELECTED, LVIS_SELECTED);
	m_dnsblList.RedrawItems(0,m_dnsblList.GetItemCount()-1);
	UpdateWindow();
}

void CConfigDnsblDlg::OnButtonDown() 
{
	int itemPos;
	CDnsblEntry entry;

	itemPos=m_dnsblList.GetSelectionMark();
	if(itemPos<m_dnsblList.GetItemCount()-1)
	{
		entry.m_name=m_dnsblList.GetItemText(itemPos,0);
		entry.m_domain=m_dnsblList.GetItemText(itemPos,1);
		entry.m_url=m_dnsblList.GetItemText(itemPos,2);
		entry.m_comment=m_dnsblList.GetItemText(itemPos,3);
		m_dnsblList.DeleteItem(itemPos);

		itemPos=m_dnsblList.InsertItem(LVIF_TEXT | LVIF_PARAM, itemPos+1, entry.m_name, 0, 0, 0, (LPARAM )0);
		m_dnsblList.SetItemText(itemPos,0,entry.m_name);
		m_dnsblList.SetItemText(itemPos,1,entry.m_domain);
		m_dnsblList.SetItemText(itemPos,2,entry.m_url);
		m_dnsblList.SetItemText(itemPos,3,entry.m_comment);
	}
	m_dnsblList.SetSelectionMark(itemPos);
	m_dnsblList.SetItemState(itemPos, LVIS_SELECTED, LVIS_SELECTED);
	m_dnsblList.RedrawItems(0,m_dnsblList.GetItemCount()-1);
	UpdateWindow();
}

void CConfigDnsblDlg::OnDblclkDnsblList(NMHDR* pNMHDR, LRESULT* pResult) 
{
	int item;
	CConfigDnsblEntryDlg dlg;

	UpdateData();
	
	item=m_dnsblList.GetSelectionMark();
	if(item>=0)
	{
		dlg.m_entry=getListEntry(item);
		
		if(dlg.DoModal()==IDOK)
		{
			setListEntry(item,dlg.m_entry);
		}
	}

	*pResult = 0;
}

void CConfigDnsblDlg::OnButtonNew() 
{
	CConfigDnsblEntryDlg dlg;

	UpdateData();
	
	if(dlg.DoModal()==IDOK)
	{
		addListEntry(dlg.m_entry);
	}
}

void CConfigDnsblDlg::OnButtonDelete() 
{
	int item;
	CString tmp;
	CDnsblEntry entry;

	UpdateData();
	
	item=m_dnsblList.GetSelectionMark();
	if(item>=0)
	{
		entry=getListEntry(item);
		
		tmp.Format(IDS_REALLYDELETEDNSBLENTRY,entry.m_name);
		if(MessageBox(tmp,NULL,MB_ICONQUESTION|MB_YESNO)==IDYES)
		{
			m_dnsblList.DeleteItem(item);
		}
		m_dnsblList.RedrawItems(0,m_dnsblList.GetItemCount()-1);
		UpdateWindow();
	}
}
