// ConfigWhitelistEntryDlg.cpp : implementation file
//
/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#include "stdafx.h"
#include "NotesAntiSpam.h"
#include "ConfigWhitelistEntryDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CConfigWhitelistEntryDlg dialog


CConfigWhitelistEntryDlg::CConfigWhitelistEntryDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CConfigWhitelistEntryDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CConfigWhitelistEntryDlg)
	m_address = _T("");
	m_name = _T("");
	//}}AFX_DATA_INIT
}


void CConfigWhitelistEntryDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CConfigWhitelistEntryDlg)
	DDX_Text(pDX, IDC_ADDRESS, m_address);
	DDX_Text(pDX, IDC_NAME, m_name);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CConfigWhitelistEntryDlg, CDialog)
	//{{AFX_MSG_MAP(CConfigWhitelistEntryDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CConfigWhitelistEntryDlg message handlers

BOOL CConfigWhitelistEntryDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	m_name=m_entry.m_name;
	m_address=m_entry.m_address;

	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CConfigWhitelistEntryDlg::OnOK() 
{
	CString tmp;
	UpdateData();

	if(m_name=="")
	{
		tmp.Format(IDS_WHITELISTENTRYNAMEEMPTY);
		MessageBox(tmp,NULL,MB_ICONERROR|MB_OK);
		return;
	}
	if(m_address=="")
	{
		tmp.Format(IDS_WHITELISTENTRYADDRESSEMPTY);
		MessageBox(tmp,NULL,MB_ICONERROR|MB_OK);
		return;
	}
	if(m_address.Find("@")<0)
	{
		tmp.Format(IDS_WHITELISTENTRYADDRESSWRONGFROMAT);
		MessageBox(tmp,NULL,MB_ICONERROR|MB_OK);
		return;
	}
	m_entry.m_name=m_name;
	m_entry.m_address=m_address;
	
	CDialog::OnOK();
}
