// DSpamFilter.h: interface for the CDSpamFilter class.
//
//////////////////////////////////////////////////////////////////////
/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#if !defined(AFX_DPSPAMFILTER_H__C7EB27C8_0CB8_4E83_93F6_21D00ADD7354__INCLUDED_)
#define AFX_DPSPAMFILTER_H__C7EB27C8_0CB8_4E83_93F6_21D00ADD7354__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

extern "C"
{
	#include "dspam/libdspam.h"
}

class CDSpamFilter  
{
public:
	BOOL CheckSpam(const CString& mail, CString& signature);
	void TrainHamAsSpam(const CString& signature);
	void TrainSpamAsHam(const CString& signature);
	void TrainHam(const CString& mail);
	void TrainSpam(const CString& mail);
	CDSpamFilter();
	virtual ~CDSpamFilter();
	static bool GetTotals(_ds_spam_totals * totals);
	void CleanupDatabase(bool purgeSigs=true,
	                     int  ageSigs=14,
						 bool purgeNeutral=true,
						 int  ageNeutral=30,
						 bool purgeUnused=true,
						 int  ageUnused=60,
						 int  ageHapaxes=15,
						 int  ageHits1S=10,
						 int  ageHits1I=10,
						 bool vaccumDB=true);

protected:
	CNotesAntiSpamApp* m_myApp; // the running App for Config etc.
	CString m_dspamHome; // DSPAM HomeDirectory
	CString m_dspamUser; // DSPAM UserName
	
	CString SaveSignature(DSPAM_CTX *CTX);
	int ProcessSigs(DSPAM_CTX * CTX, int age);
	int ProcessNeutral(DSPAM_CTX *CTX, int age);
	int ProcessUnused(DSPAM_CTX *CTX, int any, int quota, int nospam, int onehit);
	int VacuumDB(DSPAM_CTX* CTX);
};

#endif // !defined(AFX_DPSPAMFILTER_H__C7EB27C8_0CB8_4E83_93F6_21D00ADD7354__INCLUDED_)
