// Debugger.cpp: implementation of the CDebugger class.
//
//////////////////////////////////////////////////////////////////////

/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#include "stdafx.h"
#include "Debugger.h"

#include <fstream>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDebugger::CDebugger(const CString& filename)
{
	char    *pth;
	char    path[256];
	int     n;

	// Build PATH
	if ((pth = getenv("TEMP")) == NULL)
		strcpy(path, "\\");
	else
	{
		strcpy(path, pth);
		if ((n = strlen(path)) && (path[--n] == '\\'))
			path[n] = '\0';
	}

	m_logFile=path;
	m_logFile+="\\";
	m_logFile+=filename;
//	m_state=true;
}

CDebugger::~CDebugger()
{

}

void CDebugger::SetState(BOOL state)
{
	m_state=state;
}

/* Write Debug-Messages */
void CDebugger::Add(const CString& file, const int line, const CString& message)
{
	/* If Debug is switched off, do nothing */
	if(!m_state) return;

	std::ofstream debugFile;
	CTime time = CTime::GetCurrentTime();
	
	CString temp;
	temp.Format("%s (%i): %s",file.Right(file.GetLength()-file.ReverseFind('\\')-1),line,message);

	/* Write Debug to Standard Debug-Output */
	OutputDebugString(temp+"\n");

	/* Write Debug to File */
	debugFile.open(m_logFile,std::ios::app);
	debugFile<<time.Format("%d.%m.%Y %H:%M:%S ")<<temp<<std::endl;
	debugFile.close();
}
BOOL CDebugger::GetState()
{
	return m_state;
}

void CDebugger::Reset()
{
	// Delete contents of debug-File
	std::ofstream debugFile;
	debugFile.open(m_logFile);
	debugFile.close();
}
