// DnsblCache.h: interface for the CDnsblCache class.
//
//////////////////////////////////////////////////////////////////////

/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#if !defined(AFX_DNSBLCACHE_H__192336D5_1401_488A_A478_3A9533E06B04__INCLUDED_)
#define AFX_DNSBLCACHE_H__192336D5_1401_488A_A478_3A9533E06B04__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "DnsblCacheEntry.h"

class CDnsblCache  
{
public:
	CString GetDnsbl4IPAddress(const CIPAddress& ipAddress);
	void AddEntry(const CIPAddress& ipAddress, const CString& dnsbl);
	BOOL Check(const CIPAddress& ipAddress);
	CDnsblCache();
	virtual ~CDnsblCache();

protected:
	CArray<CDnsblCacheEntry,CDnsblCacheEntry&> m_cache;
};

#endif // !defined(AFX_DNSBLCACHE_H__192336D5_1401_488A_A478_3A9533E06B04__INCLUDED_)
