// IPAddress.h: interface for the CIPAddress class.
//
//////////////////////////////////////////////////////////////////////

/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#if !defined(AFX_IPADDRESS_H__F987DF5D_FF2E_411C_812D_D62EB93CA998__INCLUDED_)
#define AFX_IPADDRESS_H__F987DF5D_FF2E_411C_812D_D62EB93CA998__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CIPAddress  
{
public:
	CIPAddress();
	CIPAddress(const CString& ipStr);
	virtual ~CIPAddress();

	CString reverseIPString() const;
	CString toString() const;
	BOOL    operator==(const CIPAddress& ip);

protected:
	void splitIp(const CString& ip, BYTE& ip1, BYTE& ip2, BYTE& ip3, BYTE& ip4) const;
	void joinIp(BYTE ip1, BYTE ip2, BYTE ip3, BYTE ip4, CString& ip) const;

	BYTE m_ip1;
	BYTE m_ip2;
	BYTE m_ip3;
	BYTE m_ip4;
};

#endif // !defined(AFX_IPADDRESS_H__F987DF5D_FF2E_411C_812D_D62EB93CA998__INCLUDED_)
