// NASExtPwd.cpp : Defines the initialization routines for the DLL.
//

/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#include "stdafx.h"

/* Program header files */
#include "NASExtPwd.h"
#include "PasswordDialog.h"

/////////////////////////////////////////////////////////////////////////////
// Storage for the global data in the DLL

// MSVC is bugged - if a default value is missed off from one of the following
// variables then that variable is process-specific for some reason!

#pragma data_seg(".GSHARED")

char globalPassword[MAX_ID_PASSWORD+1]="";

#pragma data_seg()
#pragma comment(linker, "/SECTION:.GSHARED,RWS") 

/*
 * Global Data
 */
HEMREGISTRATION hGetPwdHandler = 0;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//
//	Note!
//
//		If this DLL is dynamically linked against the MFC
//		DLLs, any functions exported from this DLL which
//		call into MFC must have the AFX_MANAGE_STATE macro
//		added at the very beginning of the function.
//
//		For example:
//
//		extern "C" BOOL PASCAL EXPORT ExportedFunction()
//		{
//			AFX_MANAGE_STATE(AfxGetStaticModuleState());
//			// normal function body here
//		}
//
//		It is very important that this macro appear in each
//		function, prior to any calls into MFC.  This means that
//		it must appear as the first statement within the 
//		function, even before any object variable declarations
//		as their constructors may generate calls into the MFC
//		DLL.
//
//		Please see MFC Technical Notes 33 and 58 for additional
//		details.
//

/////////////////////////////////////////////////////////////////////////////
// CSMBChgPwApp

BEGIN_MESSAGE_MAP(CNASExtPwdApp, CWinApp)
	//{{AFX_MSG_MAP(CNASExtPwdApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSMBChgPwApp construction

CNASExtPwdApp::CNASExtPwdApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CSMBChgPwApp object

CNASExtPwdApp theApp;

/* Main DLL-Entry */
/*BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:
		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:
		case DLL_PROCESS_DETACH:
			break;
    }
    return TRUE;
}
*/


/*
 *  Architecture
 *  ------------
 *
 *  An Extension Manager DLL contains the following major components:
 *
 *    1)  DLL startup and shutdown (in platform DLL file, e.g., extwin.c):
 *        Under Win32: the -DllEntryPoint function, here DllMain
 *        Under Win16: LibMain & WEP
 *
 *    2)  Notes entry point at ordinal 1:  MainEntryPoint
 *
 *    3)  Extension manager callback:  ExtHandler
 */

/* Extension manager entry point */
NASEXTPWD_API STATUS LNPUBLIC MainEntryPoint (void)
{
	STATUS  status;
	char    msgBuf [256];

	status = EMRegister(EM_GETPASSWORD, EM_REG_BEFORE, GetPwdExtHandler, 0, &hGetPwdHandler);

	if (NOERROR != status)
	{
		wsprintf (msgBuf, "Could not register extension handler for EM_GETPASSWORD - status: 0x%lX",status);
		MessageBox(NULL,msgBuf,"NASExtPwd.dll",MB_ICONERROR|MB_OK);
		return (status);

	}

	return (status);
}

/* Deregister extensions */
NASEXTPWD_API STATUS LNPUBLIC ExtClear (void)
{
	STATUS  status;

	if (0 != hGetPwdHandler)
		status = EMDeregister (hGetPwdHandler);
	else
		status = NOERROR;

	return (status);
}


/*
 * Get-Password callback handler
 */
STATUS LNCALLBACK GetPwdExtHandler (EMRECORD far *pRecord)
{
	/* for MFC */
	AFX_MANAGE_STATE(AfxGetStaticModuleState());

	/* Notes Arguments */
	VARARG_PTR  pArgs;

    /* Function arguments */
	DWORD         MaxPwdLen;
	DWORD far *   retLength;
	char far *    retPassword;
	char far *    idFile;
	char far *    ownerName;


	/* Registry values*/
	HKEY    hKey;
	DWORD   valueSize;
	DWORD   valueType;
	LONG    regRetVal;
	int     intValue;
	CString key;
	BOOL    sso;

	/* Help-Variables */
	CString tmpPassword;

	/* Check if this Handler is really called to get a password */
	if (EM_GETPASSWORD != pRecord->EId)
		return (ERR_EM_CONTINUE);

    /* Fetch the arguments */
	        pArgs = pRecord->Ap;
		MaxPwdLen = VARARG_GET (pArgs, DWORD);
        retLength = VARARG_GET (pArgs, DWORD far *);
      retPassword = VARARG_GET (pArgs, char far *);
	       idFile = VARARG_GET (pArgs, char far *);
		ownerName = VARARG_GET (pArgs, char far *);

//	MessageBox(NULL,ownerName,"NASExtPwd.dll:OwnerName",MB_ICONERROR|MB_OK);

	/* Set sso to false for security reasons */
	sso=FALSE;
	/* Read Config from registry */
	key="SOFTWARE\\Thomas Kriener\\NotesAntiSpam";
	// get Registry-Key
	regRetVal=RegOpenKeyEx(HKEY_CURRENT_USER,
	                       key,
					       0,
					       KEY_QUERY_VALUE,
					       &hKey);
	if(regRetVal==ERROR_SUCCESS)
	{
		// SSO
		valueType=REG_DWORD;
		valueSize=sizeof(intValue);
		if(RegQueryValueEx(hKey,
		                   "SSO",
						   NULL,
						   &valueType,
						   (LPBYTE)&intValue,
						   &valueSize)==ERROR_SUCCESS)
		{
			sso=intValue;
		}

		// Close Session-Key
		RegCloseKey(hKey);
	}

	/* Ask for Password */
	if ((NULL != retLength)	&& (NULL != retPassword))
	{		
		int  len;
		CPasswordDialog dlg;

		if(sso && (strlen(globalPassword)>0))
		{
			tmpPassword=globalPassword;
		}
		else
		{
			dlg.m_username=ownerName;
			dlg.DoModal();
			tmpPassword=dlg.m_password;
		}

		len=tmpPassword.GetLength();
		if(len>MAX_ID_PASSWORD)
		{
			MessageBox(NULL,"Password too long!","amln.dll",MB_ICONERROR|MB_OK);
			return ERR_EM_CONTINUE;
		}
		if(sso)
		{
			strcpy(globalPassword,tmpPassword);
		}
		// prepare return-value
		*retLength = len;
		memcpy (retPassword, tmpPassword.LockBuffer(), len);

		tmpPassword.UnlockBuffer();

		// return success
		return (ERR_BSAFE_EXTERNAL_PASSWORD);
	}

	return (ERR_EM_CONTINUE);
}

