// NotesAntiSpamDlg.cpp : implementation file
//

/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#include "stdafx.h"
#include <windowsx.h>
#include <afxpriv.h>
#include "NotesAntiSpam.h"
#include "NotesAntiSpamDlg.h"
#include "ConfigGeneralDlg.h"
#include "ConfigDnsblDlg.h"
#include "ConfigWhitelistDlg.h"
#include "ConfigDSpamDlg.h"
#include "InformNewMailDlg.h"
#include "ShowDSpamStatistic.h"

#include ".\notesantispamdlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNotesAntiSpamDlg dialog

CString CNotesAntiSpamDlg::m_logTmp="";

CNotesAntiSpamDlg::CNotesAntiSpamDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CNotesAntiSpamDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNotesAntiSpamDlg)
	m_log = _T("");
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_informNewMailActive=FALSE;
}

void CNotesAntiSpamDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNotesAntiSpamDlg)
	DDX_Control(pDX, IDC_BUTTONSEARCH, m_searchButton);
	DDX_Control(pDX, IDC_BUTTONTRAINDPSPAM, m_trainButton);
	DDX_Text(pDX, IDC_LOG, m_log);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CNotesAntiSpamDlg, CDialog)
	//{{AFX_MSG_MAP(CNotesAntiSpamDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_CREATE()
	ON_BN_CLICKED(IDC_BUTTONSEARCH, OnButtonSearch)
	ON_COMMAND(ID_HELP_ABOUTNOTESANTISPAM, OnHelpAboutNotesAntiSpam)
	ON_COMMAND(ID_FILE_DSPAM_STATISTIC, OnFileDSpamStatistic)
	ON_COMMAND(ID_CONFIGURATION_GENERAL, OnConfigurationGeneral)
	ON_COMMAND(ID_CONFIGURATION_DNSBLACKLISTS, OnConfigurationDnsBlacklists)
	ON_COMMAND(ID_CONFIGURATION_WHITELIST, OnConfigurationWhitelist)
	ON_COMMAND(ID_CONFIGURATION_DPSPAM, OnConfigurationDSpam)
	ON_BN_CLICKED(IDC_BUTTONTRAINDPSPAM, OnButtonTrainDSpam)
	//}}AFX_MSG_MAP
	ON_MESSAGE(MYWM_UPDATEDISPLAY, OnUpdateDisplay)
	ON_MESSAGE(MYWM_INFORMNEWMAIL, OnInformNewMail)
	ON_MESSAGE(WM_ICON_NOTIFY, OnNotifyIcon)
	ON_MESSAGE(MYWM_ENDNOTESANTISPAM, OnEndNotesAntiSpam)
	ON_MESSAGE(MYWM_SEARCHSPAMSTART, OnSearchSpamStart)
	ON_MESSAGE(MYWM_SEARCHSPAMSTOP, OnSearchSpamStop)
	ON_COMMAND(ID_FILE_DSPAM_PURGE, OnFileDspamPurge)
	ON_COMMAND(ID_RESTORE, OnRestore)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNotesAntiSpamDlg message handlers

BOOL CNotesAntiSpamDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CNotesAntiSpamDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else if (nID==SC_MINIMIZE)
	{
		ShowWindow(SW_HIDE);
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CNotesAntiSpamDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CNotesAntiSpamDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CNotesAntiSpamDlg::AddLog(const CString &logMsg)
{
	CNotesAntiSpamDlg* mainWnd=((CNotesAntiSpamDlg*)AfxGetMainWnd());

	// Text should be larger than 15k
	if(mainWnd->m_logTmp.GetLength()>15000)
	{
		int i=mainWnd->m_logTmp.Find('\r',logMsg.GetLength()+512);
		mainWnd->m_logTmp.Delete(0,i+1);
		mainWnd->m_logTmp+=logMsg;
	}
	else
	{
		mainWnd->m_logTmp+=logMsg;
	}
	AfxGetMainWnd()->PostMessage(MYWM_UPDATEDISPLAY);
}

LRESULT CNotesAntiSpamDlg::OnUpdateDisplay(WPARAM wParam, LPARAM lParam)
{
	m_log=m_logTmp;
	UpdateData(FALSE);
	Invalidate();
	UpdateWindow();
	BeginWaitCursor(); // display the hourglass cursor
	SendDlgItemMessage(IDC_LOG, EM_LINESCROLL, 0, 10000);
	return (LRESULT)0;
}

LRESULT CNotesAntiSpamDlg::OnInformNewMail(WPARAM wParam, LPARAM lParam)
{
	m_TrayIcon.ShowBalloon("VK[M܂","NotesAntiSpam",NIIF_INFO,30);
	if ((!m_informNewMailActive)&&((CNotesAntiSpamApp*)AfxGetApp())->m_config.m_informNewMail)
	{
		CInformNewMailDlg dlg;
		m_informNewMailActive=TRUE;
		dlg.DoModal();
		m_informNewMailActive=FALSE;
	}

	return (LRESULT)0;
}

BOOL CNotesAntiSpamDlg::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	switch (GET_WM_COMMAND_ID(wParam, lParam))
	{
	case IDCANCEL:
		if(AfxMessageBox(IDS_STOP_NOTESANTISPAM,
					  MB_YESNO|MB_ICONINFORMATION|MB_SYSTEMMODAL|MB_DEFBUTTON2) == IDYES)
		{
			EndDialog(TRUE);
			PostQuitMessage(0);
		}
		else
			ShowWindow(SW_HIDE);
		break;

	case IDOK:
		ShowWindow(SW_HIDE);
		break;

	}
	return CDialog::OnCommand(wParam, lParam);
}

LRESULT CNotesAntiSpamDlg::OnNotifyIcon(WPARAM WParam, LPARAM LParam)
{
	// Delegate all the work back to the default implementation in CSystemTray.
	return m_TrayIcon.OnTrayNotification(WParam, LParam);
}

LRESULT CNotesAntiSpamDlg::OnEndNotesAntiSpam(WPARAM WParam, LPARAM LParam)
{
	EndDialog(TRUE);
	PostQuitMessage(0);
	return (LRESULT)0;
}

int CNotesAntiSpamDlg::OnCreate(LPCREATESTRUCT createStruct) 
{
	TCHAR toolTip[64];
	AfxLoadString(IDS_TOOLTIP, toolTip, sizeof(toolTip));
	if (!m_TrayIcon.Create(this,
	                       WM_ICON_NOTIFY,
						   toolTip,
						   (HICON)LoadImage(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDI_TRAYICON), IMAGE_ICON, 16, 16, 0),
						   IDR_TRAYMENU,
						   FALSE,
						   "Lotus-NotesXptB^",
						   "NotesAntiSpam",
						   NIIF_INFO,
						   10))
		return -1;
	m_TrayIcon.SetTargetWnd(this);

	// Call original Function
	return CDialog::OnCreate(createStruct);
}

void CNotesAntiSpamDlg::OnDestroy() 
{
	// Call original Function
	CDialog::OnDestroy();
}

void CNotesAntiSpamDlg::OnRestore()
{
	ShowWindow(SW_SHOW);
	SetForegroundWindow();
}

LRESULT CNotesAntiSpamDlg::OnSearchSpamStart(WPARAM wParam, LPARAM lParam)
{
	m_searchButton.EnableWindow(FALSE);
	m_trainButton.EnableWindow(FALSE);
	m_TrayIcon.EnableMenuItem(IDC_BUTTONSEARCH,FALSE);
	m_TrayIcon.EnableMenuItem(IDC_BUTTONTRAINDPSPAM,FALSE);
	m_TrayIcon.SetIconList(IDI_TRAYANIM1,IDI_TRAYANIM4);
	m_TrayIcon.Animate(500);
	return (LRESULT)0;
}

LRESULT CNotesAntiSpamDlg::OnSearchSpamStop(WPARAM wParam, LPARAM lParam)
{
	m_searchButton.EnableWindow(TRUE);
	m_trainButton.EnableWindow(TRUE);
	m_TrayIcon.EnableMenuItem(IDC_BUTTONSEARCH,TRUE);
	m_TrayIcon.EnableMenuItem(IDC_BUTTONTRAINDPSPAM,TRUE);
	m_TrayIcon.StopAnimation();
	m_TrayIcon.SetIcon(IDI_TRAYICON);
	return (LRESULT)0;
}

void CNotesAntiSpamDlg::OnHelpAboutNotesAntiSpam() 
{
	CAboutDlg dlgAbout;
	dlgAbout.DoModal();
}

void CNotesAntiSpamDlg::OnFileDSpamStatistic() 
{
	CShowDSpamStatistic dlg;
	dlg.DoModal();
}

void CNotesAntiSpamDlg::OnConfigurationGeneral() 
{
	CConfigGeneralDlg dlg;
	dlg.DoModal();
}

void CNotesAntiSpamDlg::OnConfigurationDnsBlacklists() 
{
	CConfigDnsblDlg dlg;
	dlg.DoModal();
}

void CNotesAntiSpamDlg::OnConfigurationWhitelist() 
{
	CConfigWhitelistDlg dlg;
	dlg.DoModal();
}


void CNotesAntiSpamDlg::OnConfigurationDSpam() 
{
	CConfigDSpamDlg dlg;
	dlg.DoModal();
}
void CNotesAntiSpamDlg::OnButtonSearch() 
{
	CNotesAntiSpamApp* myApp=(CNotesAntiSpamApp*)AfxGetApp();

	myApp->debugger.Add(__FILE__,__LINE__,"New Search on Request...");
	// The events are initially set or reset in the CreateEvent call;
	// but they may be left in an improperly initialized state if
	// a worker thread has been previously started and then prematurely
	// killed.  Set/reset the events to the proper initial state.
	// Set the "start recalc" event last, since it is the event the
	// triggers the starting of the worker thread recalculation.
	SetEvent(myApp->m_hEventSearchDone);
	ResetEvent(myApp->m_hEventKillSearchThread);
	ResetEvent(myApp->m_hEventSearchThreadKilled);
	SetEvent(myApp->m_hEventStartSearch);
}

void CNotesAntiSpamDlg::OnButtonTrainDSpam() 
{
	CNotesAntiSpamApp* myApp=(CNotesAntiSpamApp*)AfxGetApp();

	myApp->debugger.Add(__FILE__,__LINE__,"Start Training...");
	// The events are initially set or reset in the CreateEvent call;
	// but they may be left in an improperly initialized state if
	// a worker thread has been previously started and then prematurely
	// killed.  Set/reset the events to the proper initial state.
	// Set the "start search" event last, since it is the event the
	// triggers the starting of the worker thread rerun.
	SetEvent(myApp->m_hEventSearchDone);
	ResetEvent(myApp->m_hEventKillSearchThread);
	ResetEvent(myApp->m_hEventSearchThreadKilled);
	SetEvent(myApp->m_hEventStartTrainDSpam);
	SetEvent(myApp->m_hEventStartSearch);
}

void CNotesAntiSpamDlg::OnFileDspamPurge()
{
	CNotesAntiSpamApp* myApp=(CNotesAntiSpamApp*)AfxGetApp();
	// Add K.OHMI
	if(AfxMessageBox(IDS_DSPAM_PURGE,
			  MB_YESNO|MB_ICONINFORMATION|MB_SYSTEMMODAL|MB_DEFBUTTON2) == IDNO)
		return;

	myApp->debugger.Add(__FILE__,__LINE__,"Start purging DSPAM-Database...");
	// The events are initially set or reset in the CreateEvent call;
	// but they may be left in an improperly initialized state if
	// a worker thread has been previously started and then prematurely
	// killed.  Set/reset the events to the proper initial state.
	// Set the "start search" event last, since it is the event the
	// triggers the starting of the worker thread rerun.
	SetEvent(myApp->m_hEventSearchDone);
	ResetEvent(myApp->m_hEventKillSearchThread);
	ResetEvent(myApp->m_hEventSearchThreadKilled);
	SetEvent(myApp->m_hEventStartPurgeDSpam);
	SetEvent(myApp->m_hEventStartSearch);
}

