// NotesMail.h: interface for the CNotesMail class.
//
//////////////////////////////////////////////////////////////////////
/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#if !defined(AFX_NOTESMAIL_H__F1BB25CD_CB22_4050_ACFD_4C2711C4F7B1__INCLUDED_)
#define AFX_NOTESMAIL_H__F1BB25CD_CB22_4050_ACFD_4C2711C4F7B1__INCLUDED_

// normally should the define be imported from mq.h
// fails since C API 5.0.7 installed
#define NOPRIORITY MAXWORD
#include <lncppapi.h>

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CNotesMail : public LNMailMessage  
{
public:
	CString GetMessageID();
	CString dump(BOOL dosFmt=true);
	CNotesMail();
	virtual ~CNotesMail();

	int GetReceivedLines(LNText *received);
	CString GetSubjectString();
	void SetSubjectString(const CString& str);

	CString GetDSpamSignature(void);
	bool SetDSpamSignature(const CString& signature);

	bool GetDSpamIsSpam(void);
	bool SetDSpamIsSpam(bool spam);

	bool GetDSpamIsLearned(void);
	bool SetDSpamIsLearned(bool learned);
};

#endif // !defined(AFX_NOTESMAIL_H__F1BB25CD_CB22_4050_ACFD_4C2711C4F7B1__INCLUDED_)
