// PersistantHashTable.cpp: implementation of the CPersistantHashTable class.
//
//////////////////////////////////////////////////////////////////////
/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#include "stdafx.h"
//#include "NotesAntiSpam.h"
#include "PersistantHashTable.h"
#include <sys/stat.h>

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CPersistantHashTable::CPersistantHashTable()
{
	m_isOpen=FALSE;
}

CPersistantHashTable::CPersistantHashTable(const CString& filename, int flags)
{
	openFile(filename,flags);
}

CPersistantHashTable::~CPersistantHashTable()
{

	if(m_isOpen) closeFile();
}

int CPersistantHashTable::openFile(const CString &filename, int flags)
{
	char fname[2048];

	if(m_isOpen) closeFile();

	strcpy(fname,(LPCSTR)filename);
	m_dbf = gdbm_open(fname, 512, flags|GDBM_NOLOCK|GDBM_SYNC, _S_IREAD|_S_IWRITE, NULL);

	if(m_dbf==NULL)
	{
		CString tmp;

		m_isOpen=FALSE;
		tmp.Format("GDBM-Error %i: %s\r\nFile-Error %i: %s",gdbm_errno,gdbm_strerror(gdbm_errno),errno,strerror(errno));
		AfxMessageBox(tmp);
		return gdbm_errno;
	}
	m_isOpen=TRUE;
	return 0;
}

void CPersistantHashTable::closeFile()
{
	if(m_isOpen)
	{
		gdbm_close(m_dbf);
		m_isOpen=FALSE;
	}
}

int CPersistantHashTable::add(const CString& key, const CString& value)
{
	char  keyStr[2048];
	char  valStr[10000];
	datum keyDatum;
	datum valueDatum;
	int retVal;

	if(!m_isOpen) return -1;

	strcpy(keyStr,(LPCSTR)key);
	keyDatum.dptr=keyStr;
	keyDatum.dsize=key.GetLength()+1;

	strcpy(valStr,(LPCSTR)value);
	valueDatum.dptr=valStr;
	valueDatum.dsize=value.GetLength()+1;

	retVal=gdbm_store(m_dbf, keyDatum, valueDatum, GDBM_INSERT);

	return retVal;
}

int CPersistantHashTable::replace(const CString& key, const CString& value)
{
	char  keyStr[2048];
	char  valStr[10000];
	datum keyDatum;
	datum valueDatum;
	int retVal;

	if(!m_isOpen) return -1;

	strcpy(keyStr,(LPCSTR)key);
	keyDatum.dptr=keyStr;
	keyDatum.dsize=key.GetLength()+1;

	strcpy(valStr,(LPCSTR)value);
	valueDatum.dptr=valStr;
	valueDatum.dsize=value.GetLength()+1;

	retVal=gdbm_store(m_dbf, keyDatum, valueDatum, GDBM_REPLACE);

	return retVal;
}

int CPersistantHashTable::del(const CString& key)
{
	char  keyStr[2048];
	datum keyDatum;
	int retVal;

	if(!m_isOpen) return -1;

	strcpy(keyStr,(LPCSTR)key);
	keyDatum.dptr=keyStr;
	keyDatum.dsize=key.GetLength()+1;

	retVal=gdbm_delete(m_dbf, keyDatum);

	return retVal;
}

CString CPersistantHashTable::get(const CString& key)
{
	char    keyStr[2048];
	datum   keyDatum;
	datum   valueDatum;
	CString retVal;
	char*   tmpStr;

	if(!m_isOpen) return "";

	strcpy(keyStr,(LPCSTR)key);
	keyDatum.dptr=keyStr;
	keyDatum.dsize=key.GetLength()+1;

	valueDatum=gdbm_fetch(m_dbf, keyDatum);

	if(valueDatum.dptr!=NULL)
	{
		tmpStr=new char[valueDatum.dsize+1];
		strncpy(tmpStr,valueDatum.dptr,valueDatum.dsize);
		retVal=tmpStr;
		delete [] tmpStr;
//		TODO : Why is this crashing the app ?
//		free(valueDatum.dptr);
	}
	else
		retVal="";

	return retVal;
}

bool CPersistantHashTable::exists(const CString& key)
{
	char  keyStr[2048];
	datum keyDatum;
	int   retVal;

	if(!m_isOpen) return false;

	strcpy(keyStr,(LPCSTR)key);
	keyDatum.dptr=keyStr;
	keyDatum.dsize=key.GetLength()+1;

	retVal=gdbm_exists(m_dbf, keyDatum);

	return (bool)retVal;
}

CString CPersistantHashTable::getFirstKey()
{
	CString retVal="";
	char*   tmpStr;
	datum keyDatum;

	if(!m_isOpen) return "";

	keyDatum=gdbm_firstkey(m_dbf);
	if(keyDatum.dptr!=NULL)
	{
		tmpStr=new char[keyDatum.dsize+1];
		strncpy(tmpStr,keyDatum.dptr,keyDatum.dsize);
		retVal=tmpStr;
		delete [] tmpStr;
//		TODO : Why is this crashing the app ?
//		free(keyDatum.dptr);
	}
	return retVal;
}

CString CPersistantHashTable::getNextKey(const CString& key)
{
	CString retVal="";
	char*   tmpStr;
	char    oldkeyStr[2048];
	datum   nextkeyDatum;
	datum   oldkeyDatum;

	if(!m_isOpen) return "";

	strcpy(oldkeyStr,(LPCSTR)key);
	oldkeyDatum.dptr=oldkeyStr;
	oldkeyDatum.dsize=key.GetLength()+1;

	nextkeyDatum=gdbm_nextkey(m_dbf,oldkeyDatum);
	if(nextkeyDatum.dptr!=NULL)
	{
		tmpStr=new char[nextkeyDatum.dsize+1];
		strncpy(tmpStr,nextkeyDatum.dptr,nextkeyDatum.dsize);
		retVal=tmpStr;
		delete [] tmpStr;
//		TODO : Why is this crashing the app ?
//		free(nextkeyDatum.dptr);
	}
	return retVal;
}
