// ShowDSpamStatistic.cpp : implementation file
//
/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2004 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#include "stdafx.h"
#include "NotesAntiSpam.h"
#include "ShowDSpamStatistic.h"
#include "DSpamFilter.h"


// CShowDSpamStatistic dialog

IMPLEMENT_DYNAMIC(CShowDSpamStatistic, CDialog)
CShowDSpamStatistic::CShowDSpamStatistic(CWnd* pParent /*=NULL*/)
	: CDialog(CShowDSpamStatistic::IDD, pParent)
{
}

CShowDSpamStatistic::~CShowDSpamStatistic()
{
}

void CShowDSpamStatistic::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(CShowDSpamStatistic, CDialog)
END_MESSAGE_MAP()


// CShowDSpamStatistic message handlers

BOOL CShowDSpamStatistic::OnInitDialog(void)
{
	_ds_spam_totals totals;
	CString tmpStr;

	CDialog::OnInitDialog();
	CDSpamFilter::GetTotals(&totals);

	tmpStr.Format("%i",totals.innocent_classified+totals.spam_classified);
	SetDlgItemText(IDC_TOTAL_MSG, tmpStr);
	tmpStr.Format("%i",totals.spam_classified);
	SetDlgItemText(IDC_TOTAL_SPAM, tmpStr);
	tmpStr.Format("%i",totals.innocent_classified);
	SetDlgItemText(IDC_TOTAL_HAM, tmpStr);

	tmpStr.Format("%i",totals.innocent_misclassified+totals.spam_misclassified);
	SetDlgItemText(IDC_FALSE_MSG, tmpStr);
	tmpStr.Format("%i",totals.spam_misclassified);
	SetDlgItemText(IDC_FALSE_SPAM, tmpStr);
	tmpStr.Format("%i",totals.innocent_misclassified);
	SetDlgItemText(IDC_FALSE_HAM, tmpStr);

	tmpStr.Format("%i",totals.innocent_learned+totals.innocent_corpusfed+totals.spam_learned+totals.spam_corpusfed);
	SetDlgItemText(IDC_LEARNED_MSG, tmpStr);
	tmpStr.Format("%i",totals.spam_learned+totals.spam_corpusfed);
	SetDlgItemText(IDC_LEARNED_SPAM, tmpStr);
	tmpStr.Format("%i",totals.innocent_learned+totals.innocent_corpusfed);
	SetDlgItemText(IDC_LEARNED_HAM, tmpStr);

	return true;
}
