// TrainIDCache.cpp: implementation of the CTrainIDCache class.
//
//////////////////////////////////////////////////////////////////////
/*******************************************************************************
 *                                                                             *
 *  This file is part of NotesAntiSpam.                                        *
 *                                                                             *
 *  NotesAntiSpam is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by       *
 *  the Free Software Foundation; either version 2 of the License, or          *
 *  (at your option) any later version.                                        *
 *                                                                             *
 *  NotesAntiSpam is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *  GNU General Public License for more details.                               *
 *                                                                             *
 *  You should have received a copy of the GNU General Public License          *
 *  along with NotesAntiSpam; if not, write to the Free Software               *
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 *                                                                             *
 *  Copyright (c) 2003 Thomas Kriener                                          *
 *                                                                             *
 *******************************************************************************/

#include "stdafx.h"
#include "NotesAntiSpam.h"
#include "TrainIDCache.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CTrainIDCache::CTrainIDCache(const CString& filename)
{
	CString key;
	CString tmp;

	m_cache.openFile(((CNotesAntiSpamApp*)AfxGetApp())->m_config.m_userpath+filename,GDBM_WRCREAT);
	/* reset all keys to unused */
	key=m_cache.getFirstKey();
	while(key!="")
	{
		tmp.Format("Resetting NoteID %s in cache.",key);
		((CNotesAntiSpamApp*)AfxGetApp())->debugger.Add(__FILE__,__LINE__,tmp);
		m_cache.replace(key,"***");
		key=m_cache.getNextKey(key);
	}
}

CTrainIDCache::~CTrainIDCache()
{
	CString key,nextkey,value;
	CString tmp;

	// Delete unused entries
//#ifndef _DEBUG // this don't work in debug-mode :-(
	key=m_cache.getFirstKey();
	while(key!="")
	{
		value=m_cache.get(key);
		nextkey=m_cache.getNextKey(key);
		if(value!="XXX")
		{
			m_cache.del(key);
			tmp.Format("Deleting NoteID %s from train-cache.",key);
			((CNotesAntiSpamApp*)AfxGetApp())->debugger.Add(__FILE__,__LINE__,tmp);
		}
		else
		{
			tmp.Format("Keeping NoteID %s in train-cache.",key);
			((CNotesAntiSpamApp*)AfxGetApp())->debugger.Add(__FILE__,__LINE__,tmp);
		}
		key=nextkey;
	}
//#endif

	// close the file
	m_cache.closeFile();
}


BOOL CTrainIDCache::Check(const CString& msgID)
{
	CString key;
	BOOL retVal;

	key=msgID;
	retVal=m_cache.exists(key);

	return retVal;
}

void CTrainIDCache::AddEntry(const CString& msgID)
{
	CString key;

	key=msgID;
	m_cache.add(key,"XXX");
}

void CTrainIDCache::DelEntry(const CString& msgID)
{
	CString key;

	key=msgID;
	m_cache.del(key);
}
