// small c++ to open store then close a gdbm file 
// by Mike MacFaden 4/93  mike@premisys.com
// tested with gdbm 1.5 and gnu v2.2 c++ compiler

#ifdef STATIC_BUILD
# define DLLIMPORT
# define DLLEXPORT
#else
#ifdef WIN32
# define DLLEXPORT __declspec(dllexport)      // dll-creation
# define DLLIMPORT __declspec(dllimport)
#else
# define DLLIMPORT                            // static lib
# define DLLEXPORT
#endif
#endif

#ifdef USE_DLL
# define IMEXPORT DLLIMPORT
#else
# define IMEXPORT DLLEXPORT
#endif


#include <string.h>
#include <errno.h>
#include "iostream.h"
#include "gdbm.h"


int main(int argc, char *argv[])
{
	cout << "Sample C++ program create a gdbm file ./tstgdbm.gdbm." << endl;
	cout << gdbm_version << endl;
	GDBM_FILE pfile = gdbm_open("tstgdbm.gdbm", 512, GDBM_WRCREAT, 00664, 0);
	if (!pfile)
	{
		cout << "main:gdbm_open " << gdbm_errno << errno << endl;
		return -1;
	}
	
	datum key = {"foo", strlen("foo")+1};
	datum val = {"bar", strlen("bar")+1};
	
	cout << "key is  : " << key.dptr << endl;
	cout << "data is : " << val.dptr << endl;
	
	if (gdbm_store(pfile, key, val, GDBM_INSERT) != 0)
	{
		cout << "main:gdbm_store " << gdbm_errno << " " << errno << endl;
		cout << "main:gdbm_store " << gdbm_strerror(gdbm_errno) << endl;
		return -1;
	}
	gdbm_close(pfile);
	
	cout << "Sample C++ program complete" << endl;
	return 0;		
}
